/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.util.Collection;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.tools.CopyList;

public class AppendableGpxTrackSegment
extends WithAttributes
implements IGpxTrackSegment {
    private WayPoint[] wayPoints = new WayPoint[16];
    private int size;
    private Bounds bounds;
    private double length;

    public Bounds getBounds() {
        return this.bounds;
    }

    public Collection<WayPoint> getWayPoints() {
        return new CopyList((Object[])this.wayPoints, this.size);
    }

    public void addWaypoint(WayPoint p) {
        double distance;
        if (this.wayPoints.length == this.size) {
            WayPoint[] newWaypoints = new WayPoint[this.wayPoints.length * 2];
            System.arraycopy(this.wayPoints, 0, newWaypoints, 0, this.wayPoints.length);
            this.wayPoints = newWaypoints;
        }
        if (this.size > 0 && !Double.isNaN(distance = this.wayPoints[this.size - 1].greatCircleDistance((ILatLon)p)) && !Double.isInfinite(distance)) {
            this.length += distance;
        }
        if (this.bounds == null) {
            this.bounds = new Bounds(p.getCoor());
        } else {
            this.bounds.extend(p.getCoor());
        }
        this.wayPoints[this.size] = p;
        ++this.size;
    }

    public double length() {
        return this.length;
    }

    public int getUpdateCount() {
        return this.size;
    }
}

