/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit.lib.records.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openstreetmap.josm.plugins.fit.lib.global.FitDevDataRecord;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperField;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitField;
import org.openstreetmap.josm.plugins.fit.lib.utils.DevDataUtils;
import org.openstreetmap.josm.plugins.fit.lib.utils.NumberUtils;
import org.openstreetmap.josm.plugins.fit.lib.utils.StringUtils;

public record FitDeveloperFieldDescriptionMessage(short developerDataIndex, short fieldDefinitionNumber, short fitBaseTypeId, String fieldName, String units, short nativeFieldNumber, FitDevDataRecord devData) {
    public static FitDeveloperFieldDescriptionMessage parse(boolean littleEndian, List<FitField> fieldList, List<FitDeveloperField> developerFieldList, FitDeveloperFieldDescriptionMessage[] developerFields, InputStream inputStream) throws IOException {
        short developerDataIndex = 255;
        short fieldDefinitionNumber = 255;
        short fitBaseTypeId = 255;
        String fieldName = "";
        String units = "";
        short nativeFieldNumber = Short.MAX_VALUE;
        block7: for (FitField fitField : fieldList) {
            short size = fitField.size();
            switch (fitField.fieldDefinitionNumber()) {
                case 0: {
                    developerDataIndex = NumberUtils.decodeShort(size, littleEndian, inputStream);
                    continue block7;
                }
                case 1: {
                    fieldDefinitionNumber = NumberUtils.decodeShort(size, littleEndian, inputStream);
                    continue block7;
                }
                case 2: {
                    fitBaseTypeId = NumberUtils.decodeShort(size, littleEndian, inputStream);
                    continue block7;
                }
                case 3: {
                    fieldName = StringUtils.decodeString(inputStream);
                    continue block7;
                }
                case 8: {
                    units = StringUtils.decodeString(inputStream);
                    continue block7;
                }
            }
            inputStream.readNBytes(size);
        }
        return new FitDeveloperFieldDescriptionMessage(developerDataIndex, fieldDefinitionNumber, fitBaseTypeId, fieldName, units, nativeFieldNumber, DevDataUtils.parseDevFields(littleEndian, developerFieldList, developerFields, inputStream));
    }
}

