/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.RecordComponent;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.fit.lib.FitReader;
import org.openstreetmap.josm.plugins.fit.lib.FitReaderOptions;
import org.openstreetmap.josm.plugins.fit.lib.global.FitData;
import org.openstreetmap.josm.plugins.fit.lib.global.FitEvent;
import org.openstreetmap.josm.plugins.fit.lib.global.HeartRateCadenceDistanceSpeed;
import org.openstreetmap.josm.tools.I18n;

public class FitPlugin
extends Plugin {
    public FitPlugin(PluginInformation info) {
        super(info);
        ExtensionFileFilter.addImporter((FileImporter)new FitImporter());
    }

    private static final class FitImporter
    extends FileImporter {
        public FitImporter() {
            super(new ExtensionFileFilter("fit", "fit", I18n.tr((String)"FIT Files (*.fit)", (Object[])new Object[0])));
        }

        public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                FitData[] records = FitReader.read(inputStream, FitReaderOptions.TRY_TO_FINISH);
                GpxData gpxData = new GpxData(true);
                progressMonitor.beginTask(I18n.tr((String)"Processing FIT records", (Object[])new Object[0]), records.length);
                ArrayList<WayPoint> waypoints = new ArrayList<WayPoint>(records.length % 1000);
                for (int i = 0; i < records.length; ++i) {
                    FitData r = records[i];
                    if (i % 1000 == 0) {
                        progressMonitor.worked(1);
                    }
                    if (r instanceof HeartRateCadenceDistanceSpeed) {
                        HeartRateCadenceDistanceSpeed heartRateCadenceDistanceSpeed = (HeartRateCadenceDistanceSpeed)r;
                        double lat = heartRateCadenceDistanceSpeed.lat();
                        double lon = heartRateCadenceDistanceSpeed.lon();
                        if (Double.isNaN(lat) || Double.isNaN(lon)) continue;
                        WayPoint waypoint = new WayPoint(new LatLon(lat, lon));
                        waypoint.setInstant(heartRateCadenceDistanceSpeed.timestamp());
                        TreeMap<String, Object> map = new TreeMap<String, Object>();
                        for (RecordComponent component : HeartRateCadenceDistanceSpeed.class.getRecordComponents()) {
                            if (Arrays.asList("lat", "lon", "timestamp", "unknown").contains(component.getName())) continue;
                            try {
                                map.put(component.getName(), component.getAccessor().invoke((Object)heartRateCadenceDistanceSpeed, new Object[0]));
                            }
                            catch (ReflectiveOperationException e) {
                                throw new IOException(e);
                            }
                        }
                        map.put("unknown", Arrays.deepToString((Object[])heartRateCadenceDistanceSpeed.unknown()));
                        waypoint.attr.putAll(map);
                        if (!waypoints.isEmpty() && Math.abs(waypoints.getLast().getInstant().getEpochSecond() - waypoint.getInstant().getEpochSecond()) > TimeUnit.DAYS.toDays(365L)) {
                            FitImporter.createTrack(gpxData, new ArrayList<WayPoint>(waypoints));
                            waypoints.clear();
                            continue;
                        }
                        waypoints.add(waypoint);
                        continue;
                    }
                    if (!(r instanceof FitEvent)) continue;
                    gpxData.addTrack((IGpxTrack)new GpxTrack(Collections.singleton(new ArrayList<WayPoint>(waypoints)), Collections.emptyMap()));
                    waypoints.clear();
                }
                waypoints.trimToSize();
                FitImporter.createTrack(gpxData, waypoints);
                gpxData.endUpdate();
                MainApplication.getLayerManager().addLayer((Layer)new GpxLayer(gpxData, file.getName(), true));
            }
        }

        private static void createTrack(GpxData gpxData, ArrayList<WayPoint> waypoints) {
            if (waypoints.size() > 1) {
                gpxData.addTrack((IGpxTrack)new GpxTrack(Collections.singleton(waypoints), Collections.emptyMap()));
            } else if (!waypoints.isEmpty()) {
                gpxData.addWaypoint(waypoints.get(0));
            }
        }
    }
}

