/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import relcontext.actions.PublicTransportHelper;
import relcontext.relationfix.RelationFixer;

public class PublicTransportFixer
extends RelationFixer {
    public PublicTransportFixer() {
        super("route", "public_transport");
    }

    @Override
    public boolean isRelationGood(Relation rel) {
        for (RelationMember m : rel.getMembers()) {
            if (m.getType() == OsmPrimitiveType.NODE && !m.getRole().startsWith("stop") && !m.getRole().startsWith("platform")) {
                this.setWarningMessage(I18n.tr((String)"Node without ''stop'' or ''platform'' role found", (Object[])new Object[0]));
                return false;
            }
            if (m.getType() != OsmPrimitiveType.WAY || !PublicTransportHelper.isWayPlatform(m) || m.getRole().startsWith("platform")) continue;
            this.setWarningMessage(I18n.tr((String)"Way platform without ''platform'' role found", (Object[])new Object[0]) + " r" + m.getUniqueId());
            return false;
        }
        this.clearWarningMessage();
        return true;
    }

    @Override
    public Command fixRelation(Relation rel) {
        List<RelationMember> members = PublicTransportFixer.fixStopPlatformRole(rel.getMembers());
        if (!members.equals(rel.getMembers())) {
            DataSet ds = (DataSet)Utils.firstNonNull((Object[])new DataSet[]{rel.getDataSet(), MainApplication.getLayerManager().getEditDataSet()});
            return new ChangeMembersCommand(ds, rel, rel.getMembers());
        }
        return null;
    }

    private static List<RelationMember> fixStopPlatformRole(List<RelationMember> origMembers) {
        List<RelationMember> members = origMembers;
        for (int i = 0; i < members.size(); ++i) {
            RelationMember m = members.get(i);
            String role = PublicTransportHelper.getRoleByMember(m);
            if (role == null || m.getRole().startsWith(role)) continue;
            if (members == origMembers) {
                members = new ArrayList<RelationMember>(origMembers);
            }
            members.set(i, new RelationMember(role, m.getMember()));
        }
        return members;
    }
}

