/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javafx.application.Platform;
import org.openstreetmap.josm.plugins.streetside.CubeMapTileXY;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.Logging;

public final class GraphicsUtils {
    private static final Logger LOGGER = Logger.getLogger(GraphicsUtils.class.getCanonicalName());

    private GraphicsUtils() {
    }

    public static BufferedImage buildMultiTiledCubemapFaceImage(Map<CubeMapTileXY, BufferedImage> tiles, int zoom) {
        BufferedImage[] faceTileImages = new BufferedImage[tiles.size()];
        for (Map.Entry<CubeMapTileXY, BufferedImage> entry : tiles.entrySet()) {
            int index = GraphicsUtils.cubeMapTileToIndex(entry.getKey(), zoom);
            if (index >= faceTileImages.length) {
                faceTileImages = Arrays.copyOf(faceTileImages, index + 1);
            }
            faceTileImages[index] = entry.getValue();
        }
        return GraphicsUtils.buildMultiTiledCubemapFaceImage(faceTileImages);
    }

    static int cubeMapTileToIndex(CubeMapTileXY tile, int zoom) {
        return (1 << zoom) * tile.y() + tile.x();
    }

    public static BufferedImage buildMultiTiledCubemapFaceImage(BufferedImage[] tiles) {
        int rows;
        long start = System.currentTimeMillis();
        int zoom = Math.toIntExact(Math.round(Math.log(tiles.length) / Math.log(4.0)));
        int pixelBuffer = zoom >= 1 ? 2 : 1;
        BufferedImage[] croppedTiles = GraphicsUtils.cropMultiTiledImages(tiles, pixelBuffer);
        int cols = rows = Math.toIntExact(Math.round(Math.pow(2.0, zoom)));
        int chunkWidth = Arrays.stream(croppedTiles).filter(Objects::nonNull).findFirst().orElseThrow().getWidth();
        int chunkHeight = Arrays.stream(croppedTiles).filter(Objects::nonNull).findFirst().orElseThrow().getHeight();
        BufferedImage img = new BufferedImage(chunkWidth * cols, chunkHeight * rows, 2);
        int num = 0;
        Graphics2D g2d = img.createGraphics();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                BufferedImage tile;
                if ((tile = croppedTiles[num++]) == null) continue;
                g2d.drawImage((Image)tile, chunkWidth * j, chunkHeight * i, null);
            }
        }
        g2d.dispose();
        if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
            LOGGER.log(Logging.LEVEL_DEBUG, "Image concatenated in {0} millisecs.", System.currentTimeMillis() - start);
        }
        return img;
    }

    public static BufferedImage rotateImage(BufferedImage bufImg) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        tx.translate(-bufImg.getWidth(null), -bufImg.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bufImg = op.filter(bufImg, null);
        return bufImg;
    }

    private static BufferedImage[] cropMultiTiledImages(BufferedImage[] tiles, int pixelBuffer) {
        long start = System.currentTimeMillis();
        BufferedImage[] res = new BufferedImage[tiles.length];
        for (int i = 0; i < tiles.length; ++i) {
            if (tiles[i] == null) continue;
            res[i] = tiles[i].getSubimage(pixelBuffer, pixelBuffer, 256 - pixelBuffer, 256 - pixelBuffer);
        }
        if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
            LOGGER.log(Logging.LEVEL_DEBUG, "Images cropped in {0} millisecs.", System.currentTimeMillis() - start);
        }
        return res;
    }

    public static final class PlatformHelper {
        private PlatformHelper() {
        }

        public static void run(Runnable treatment) {
            if (treatment == null) {
                throw new IllegalArgumentException("The treatment to perform can not be null");
            }
            if (Platform.isFxApplicationThread()) {
                treatment.run();
            } else {
                Platform.runLater((Runnable)treatment);
            }
        }
    }
}

