/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.download;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public abstract class BoundsDownloadRunnable
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(BoundsDownloadRunnable.class.getCanonicalName());
    protected final Bounds bounds;

    protected BoundsDownloadRunnable(Bounds bounds) {
        this.bounds = bounds;
    }

    protected abstract Function<Bounds, URL> getUrlGenerator();

    @Override
    public void run() {
        block5: {
            URL nextURL = this.getUrlGenerator().apply(this.bounds);
            if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
                LOGGER.log(Logging.LEVEL_DEBUG, "Downloading bounds: URL: {0}", nextURL);
            }
            try {
                while (nextURL != null) {
                    if (Thread.interrupted()) {
                        LOGGER.log(Logging.LEVEL_ERROR, "{0} for {1} interrupted!", new Object[]{this.getClass().getSimpleName(), this.bounds});
                        return;
                    }
                    URLConnection con = nextURL.openConnection();
                    this.run(con);
                    nextURL = StreetsideURL.APIv3.parseNextFromLinkHeaderValue(con.getHeaderField("Link"));
                }
            }
            catch (IOException e) {
                String message = "Could not read from URL " + String.valueOf(nextURL) + "!";
                LOGGER.log(Logging.LEVEL_WARN, message, e);
                if (GraphicsEnvironment.isHeadless()) break block5;
                new Notification(message).setIcon((Icon)StreetsidePlugin.LOGO.setSize(ImageProvider.ImageSizes.LARGEICON).get()).setDuration(Notification.TIME_LONG).show();
            }
        }
    }

    public abstract void run(URLConnection var1) throws IOException;
}

