/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.openstreetmap.josm.plugins.streetside.cubemap.CameraTransformer;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBox;

public class ThreeSixtyDegreeViewerPanel
extends JFXPanel {
    private static final long serialVersionUID = -7032369684012156320L;
    private static final CameraTransformer cameraTransform = new CameraTransformer();
    private static final double CAMERA_DISTANCE = 5000.0;
    private static Scene cubemapScene;
    private static Scene defaultScene;
    private static Scene loadingScene;
    private static Group root;
    private static Group subGroup;
    private static CubemapBox cubemapBox;
    private static PerspectiveCamera camera;
    private static double mousePosX;
    private static double mousePosY;
    private static double mouseOldX;
    private static double mouseOldY;

    private static Scene createDefaultScene() {
        TextArea textArea = new TextArea();
        textArea.setText("No Streetside image selected.");
        VBox vbox = new VBox(new Node[]{textArea});
        ThreeSixtyDegreeViewerPanel.initializeStatic();
        cubemapScene = new Scene((Parent)new Group(new Node[]{root}), 1024.0, 668.0, true, SceneAntialiasing.BALANCED);
        cubemapScene.setFill((Paint)Color.TRANSPARENT);
        cubemapScene.setCamera((Camera)camera);
        cubemapScene.setOnKeyPressed(ThreeSixtyDegreeViewerPanel::keyPressed);
        cubemapScene.setOnMousePressed(ThreeSixtyDegreeViewerPanel::mouseClicked);
        cubemapScene.setOnMouseDragged(ThreeSixtyDegreeViewerPanel::mouseDragged);
        root.getChildren().addAll((Object[])new Node[]{cubemapBox, subGroup});
        root.setAutoSizeChildren(true);
        subGroup.setAutoSizeChildren(true);
        Platform.setImplicitExit((boolean)false);
        defaultScene = new Scene((Parent)vbox, 200.0, 100.0);
        return defaultScene;
    }

    private static void keyPressed(KeyEvent event) {
        KeyCode keycode;
        double change = 10.0;
        if (event.isShiftDown()) {
            change = 50.0;
        }
        if ((keycode = event.getCode()) == KeyCode.W) {
            camera.setTranslateZ(camera.getTranslateZ() + change);
        }
        if (keycode == KeyCode.S) {
            camera.setTranslateZ(camera.getTranslateZ() - change);
        }
        if (keycode == KeyCode.A) {
            camera.setTranslateX(camera.getTranslateX() - change);
        }
        if (keycode == KeyCode.D) {
            camera.setTranslateX(camera.getTranslateX() + change);
        }
    }

    private static void mouseClicked(MouseEvent me) {
        mousePosX = me.getSceneX();
        mousePosY = me.getSceneY();
        mouseOldX = me.getSceneX();
        mouseOldY = me.getSceneY();
    }

    private static void mouseDragged(MouseEvent me) {
        mouseOldX = mousePosX;
        mouseOldY = mousePosY;
        mousePosX = me.getSceneX();
        mousePosY = me.getSceneY();
        double mouseDeltaX = mousePosX - mouseOldX;
        double mouseDeltaY = mousePosY - mouseOldY;
        double modifier = 0.375;
        double modifierFactor = 0.1;
        if (me.isControlDown()) {
            modifier = 0.1;
        }
        if (me.isShiftDown()) {
            modifier = 50.0;
        }
        if (me.isSecondaryButtonDown()) {
            cameraTransform.setRy(((ThreeSixtyDegreeViewerPanel.cameraTransform.ry.getAngle() - mouseDeltaX * 0.1 * modifier * 2.0) % 360.0 + 540.0) % 360.0 - 180.0);
            cameraTransform.setRx(((ThreeSixtyDegreeViewerPanel.cameraTransform.rx.getAngle() + mouseDeltaY * 0.1 * modifier * 2.0) % 360.0 + 540.0) % 360.0 - 180.0);
        } else if (me.isPrimaryButtonDown()) {
            double z = camera.getTranslateZ();
            double newZ = z + mouseDeltaX * 0.1 * modifier;
            camera.setTranslateZ(newZ);
        } else if (me.isMiddleButtonDown()) {
            cameraTransform.setTx(ThreeSixtyDegreeViewerPanel.cameraTransform.t.getX() + mouseDeltaX * 0.1 * modifier * 0.3);
            cameraTransform.setTy(ThreeSixtyDegreeViewerPanel.cameraTransform.t.getY() + mouseDeltaY * 0.1 * modifier * 0.3);
        }
    }

    private static void createLoadingScene() {
        Label label = new Label(" Loading...");
        label.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)14.0));
        VBox vbox = new VBox(new Node[]{label});
        loadingScene = new Scene((Parent)vbox, 200.0, 100.0);
    }

    private static void initializeStatic() {
        root = new Group();
        camera = new PerspectiveCamera(true);
        cameraTransform.setTranslate(0.0, 0.0, 0.0);
        cameraTransform.getChildren().addAll((Object[])new Node[]{camera});
        camera.setNearClip(0.1);
        camera.setFarClip(1000000.0);
        camera.setFieldOfView(42.0);
        camera.setTranslateZ(-5000.0);
        PointLight light = new PointLight(Color.WHITE);
        cameraTransform.getChildren().add((Object)light);
        light.setTranslateX(camera.getTranslateX());
        light.setTranslateY(camera.getTranslateY());
        light.setTranslateZ(camera.getTranslateZ());
        root.getChildren().add((Object)cameraTransform);
        cubemapBox = new CubemapBox(null, null, null, null, null, null, 100000.0, camera);
        subGroup = new Group();
        subGroup.getChildren().add((Object)cameraTransform);
    }

    void initialize() {
        ThreeSixtyDegreeViewerPanel.initializeStatic();
        ThreeSixtyDegreeViewerPanel.createLoadingScene();
        Platform.runLater(() -> this.setScene(ThreeSixtyDegreeViewerPanel.createDefaultScene()));
    }

    public CubemapBox getCubemapBox() {
        if (cubemapBox == null) {
            this.initialize();
        }
        return cubemapBox;
    }

    public Scene getDefaultScene() {
        return defaultScene;
    }

    public Scene getCubemapScene() {
        return cubemapScene;
    }

    public Scene getLoadingScene() {
        return loadingScene;
    }
}

