/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.List;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;

public record StreetsideImage(String id, double lat, double lon, double heading, double pitch, double roll, Instant vintageStart, Instant vintageEnd, String logo, String copyright, int zoomMin, int zoomMax, int imageHeight, int imageWidth, List<String> imageUrlSubdomains) implements StreetsideAbstractImage
{
    public StreetsideImage {
        if (lat > 90.0 || lat < -90.0) {
            throw new IllegalArgumentException("Invalid latitude: " + lat);
        }
        if (lon > 180.0 || lon < -180.0) {
            throw new IllegalArgumentException("Invalid longitude: " + lon);
        }
        if (pitch > 360.0 || pitch < -360.0) {
            throw new IllegalArgumentException("Invalid pitch: " + pitch);
        }
        if (roll > 360.0 || roll < -360.0) {
            throw new IllegalArgumentException("Invalid roll: " + roll);
        }
    }

    @Override
    public int compareTo(@Nonnull StreetsideAbstractImage o) {
        if (o instanceof StreetsideImage) {
            StreetsideImage other = (StreetsideImage)o;
            if (this.vintageStart.compareTo(other.vintageStart) != 0) {
                return this.vintageStart.compareTo(other.vintageStart);
            }
            if (this.vintageEnd.compareTo(other.vintageEnd) != 0) {
                return this.vintageEnd.compareTo(other.vintageEnd);
            }
            if (this.id.compareTo(o.id()) != 0) {
                return this.id.compareTo(o.id());
            }
            return (int)Math.round(this.lat + this.lon + this.heading + this.pitch + this.roll - (other.lat + other.lon + other.heading + other.pitch + other.roll));
        }
        return this.hashCode() - o.hashCode();
    }
}

