/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils;

import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.utils.PluginState;
import org.openstreetmap.josm.tools.I18n;

public final class StreetsideUtils {
    private StreetsideUtils() {
    }

    public static void updateHelpText() {
        if (MainApplication.getMap() == null || MainApplication.getMap().statusLine == null) {
            return;
        }
        StringBuilder ret = new StringBuilder();
        if (PluginState.isDownloading()) {
            ret.append(I18n.tr((String)"Downloading Streetside images", (Object[])new Object[0]));
        } else if (StreetsideLayer.hasInstance() && !StreetsideLayer.getInstance().getData().getImages().isEmpty()) {
            ret.append(I18n.tr((String)"Total Streetside images: {0}", (Object[])new Object[]{StreetsideLayer.getInstance().getToolTipText()}));
        } else {
            ret.append(I18n.tr((String)"No images found", (Object[])new Object[0]));
        }
        if (StreetsideLayer.hasInstance() && StreetsideLayer.getInstance().mode != null) {
            ret.append(" \u2014 ").append(I18n.tr((String)StreetsideLayer.getInstance().mode.toString(), (Object[])new Object[0]));
        }
        MainApplication.getMap().statusLine.setHelpText(ret.toString());
    }
}

