/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.mode;

import java.awt.event.MouseEvent;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideMainDialog;
import org.openstreetmap.josm.plugins.streetside.mode.AbstractMode;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;

public class SelectMode
extends AbstractMode {
    private boolean nothingHighlighted;
    private boolean imageHighlighted;

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        StreetsideLayer.getInstance().getData().setSelectedImage(this.getClosest(e.getPoint()));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (MainApplication.getLayerManager().getActiveLayer() instanceof OsmDataLayer && MainApplication.getMap().mapMode != MainApplication.getMap().mapModeSelect) {
            return;
        }
        if (Boolean.FALSE.equals(StreetsideProperties.HOVER_ENABLED.get())) {
            return;
        }
        StreetsideImage closestTemp = this.getClosest(e.getPoint());
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        if (editLayer != null) {
            if (closestTemp != null && !this.imageHighlighted) {
                if (MainApplication.getMap().mapMode != null) {
                    MainApplication.getMap().mapMode.putValue("active", (Object)Boolean.FALSE);
                }
                this.imageHighlighted = true;
            } else if (closestTemp == null && this.imageHighlighted && this.nothingHighlighted) {
                if (MainApplication.getMap().mapMode != null) {
                    MainApplication.getMap().mapMode.putValue("active", (Object)Boolean.TRUE);
                }
                this.nothingHighlighted = false;
            } else if (this.imageHighlighted && !this.nothingHighlighted && editLayer.data != null) {
                for (OsmPrimitive primivitive : MainApplication.getLayerManager().getEditLayer().data.allPrimitives()) {
                    primivitive.setHighlighted(false);
                }
                this.imageHighlighted = false;
                this.nothingHighlighted = true;
            }
        }
        if (StreetsideLayer.getInstance().getData().getHighlightedImage() != closestTemp && closestTemp != null) {
            StreetsideLayer.getInstance().getData().setHighlightedImage(closestTemp);
            StreetsideMainDialog.getInstance().setImage(closestTemp);
            StreetsideMainDialog.getInstance().updateImage(false);
        } else if (StreetsideLayer.getInstance().getData().getHighlightedImage() != closestTemp && closestTemp == null) {
            StreetsideLayer.getInstance().getData().setHighlightedImage(null);
            StreetsideMainDialog.getInstance().setImage(StreetsideLayer.getInstance().getData().getSelectedImage());
            StreetsideMainDialog.getInstance().updateImage();
        }
        StreetsideLayer.invalidateInstance();
    }

    public String toString() {
        return I18n.tr((String)"Select mode", (Object[])new Object[0]);
    }
}

