/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import relcontext.relationfix.RelationFixer;

public class AssociatedStreetFixer
extends RelationFixer {
    private static final String ADDR_HOUSENUMBER = "addr:housenumber";
    private static final String BUILDING = "building";
    private static final String HOUSE = "house";
    private static final String STREET = "street";

    public AssociatedStreetFixer() {
        super("associatedStreet");
    }

    @Override
    public boolean isRelationGood(Relation rel) {
        for (RelationMember m : rel.getMembers()) {
            if (m.getType() == OsmPrimitiveType.NODE && !HOUSE.equals(m.getRole())) {
                this.setWarningMessage(I18n.tr((String)"Node without ''house'' role found", (Object[])new Object[0]));
                return false;
            }
            if (m.getType() == OsmPrimitiveType.WAY && !HOUSE.equals(m.getRole()) && !STREET.equals(m.getRole())) {
                this.setWarningMessage(I18n.tr((String)"Way without ''house'' or ''street'' role found", (Object[])new Object[0]));
                return false;
            }
            if (m.getType() != OsmPrimitiveType.RELATION || HOUSE.equals(m.getRole())) continue;
            this.setWarningMessage(I18n.tr((String)"Relation without ''house'' role found", (Object[])new Object[0]));
            return false;
        }
        if (!rel.hasKey("name")) {
            this.setWarningMessage(I18n.tr((String)"Relation does not have name", (Object[])new Object[0]));
            return false;
        }
        String streetName = rel.get("name");
        if (streetName == null) {
            streetName = "";
        }
        for (RelationMember m : rel.getMembers()) {
            String anotherName;
            if (!STREET.equals(m.getRole()) || streetName.equals(m.getWay().get("name")) || (anotherName = m.getWay().get("name")) == null || anotherName.isEmpty()) continue;
            this.setWarningMessage(I18n.tr((String)"Relation has streets with different names", (Object[])new Object[0]));
            return false;
        }
        this.clearWarningMessage();
        return true;
    }

    @Override
    public Command fixRelation(Relation source) {
        List members = source.getMembers();
        boolean fixed = false;
        for (int i = 0; i < members.size(); ++i) {
            RelationMember m = (RelationMember)members.get(i);
            if (m.isNode()) {
                Node node = m.getNode();
                if (HOUSE.equals(m.getRole()) || !node.hasKey(BUILDING) && !node.hasKey(ADDR_HOUSENUMBER)) continue;
                fixed = true;
                members.set(i, new RelationMember(HOUSE, (OsmPrimitive)node));
                continue;
            }
            if (m.isWay()) {
                Way way = m.getWay();
                if (!STREET.equals(m.getRole()) && way.hasKey("highway")) {
                    fixed = true;
                    members.set(i, new RelationMember(STREET, (OsmPrimitive)way));
                    continue;
                }
                if (HOUSE.equals(m.getRole()) || !way.hasKey(BUILDING) && !way.hasKey(ADDR_HOUSENUMBER)) continue;
                fixed = true;
                members.set(i, new RelationMember(HOUSE, (OsmPrimitive)way));
                continue;
            }
            if (!m.isRelation()) continue;
            Relation relation = m.getRelation();
            if (HOUSE.equals(m.getRole()) || !relation.hasKey(BUILDING) && !relation.hasKey(ADDR_HOUSENUMBER) && !"multipolygon".equals(relation.get("type"))) continue;
            fixed = true;
            members.set(i, new RelationMember(HOUSE, (OsmPrimitive)relation));
        }
        HashMap<Object, Integer> streetNames = new HashMap<Object, Integer>();
        for (RelationMember m : members) {
            Object name;
            if (!STREET.equals(m.getRole()) || !m.isWay() || (name = m.getWay().get("name")) == null || ((String)name).isEmpty()) continue;
            Integer count = (Integer)streetNames.get(name);
            streetNames.put(name, count != null ? count + 1 : 1);
        }
        String commonName = "";
        Integer commonCount = 0;
        for (Map.Entry entry : streetNames.entrySet()) {
            if ((Integer)entry.getValue() <= commonCount) continue;
            commonCount = (Integer)entry.getValue();
            commonName = (String)entry.getKey();
        }
        HashMap<String, String> nameTag = new HashMap<String, String>();
        if (!source.hasKey("name") && !commonName.isEmpty()) {
            nameTag.put("name", commonName);
        }
        ArrayList<Object> commandList = new ArrayList<Object>();
        DataSet ds = (DataSet)Utils.firstNonNull((Object[])new DataSet[]{source.getDataSet(), MainApplication.getLayerManager().getEditDataSet()});
        if (fixed) {
            commandList.add(new ChangeMembersCommand(ds, source, members));
        }
        if (!nameTag.isEmpty()) {
            commandList.add(new ChangePropertyCommand(ds, Collections.singleton(source), nameTag));
        }
        if (commandList.isEmpty()) {
            return null;
        }
        return SequenceCommand.wrapIfNeeded((String)I18n.tr((String)"fix associatedStreet relation", (Object[])new Object[0]), commandList);
    }
}

