/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.util.logging.Logger;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.Logging;

public final class CubemapUtils {
    public static final int NUM_SIDES = 6;
    private static final Logger LOGGER = Logger.getLogger(CubemapUtils.class.getCanonicalName());
    private static final int NUM_BASE = 4;

    private CubemapUtils() {
    }

    public static int getMaxCols(StreetsideAbstractImage image) {
        if (Boolean.TRUE.equals(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get())) {
            return image.xCols(image.zoomMax());
        }
        return image.xCols(image.zoomMin());
    }

    public static int getMaxRows(StreetsideAbstractImage image) {
        return CubemapUtils.getMaxCols(image);
    }

    public static String convertDecimal2Quaternary(long inputNum) {
        return Long.toString(inputNum, 4);
    }

    public static String convertQuaternary2Decimal(String inputNum) {
        try {
            return Long.toString(Long.valueOf(inputNum, 4));
        }
        catch (NumberFormatException numberFormatException) {
            Logging.trace((Throwable)numberFormatException);
            LOGGER.log(Logging.LEVEL_ERROR, "Error converting quadkey {0} to decimal.", inputNum);
            return "000000000";
        }
    }

    public static enum CubemapFaces {
        FRONT("01"),
        RIGHT("02"),
        BACK("03"),
        LEFT("10"),
        UP("11"),
        DOWN("12");

        private final String value;

        private CubemapFaces(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String faceId() {
            return this.value.substring(0, 1);
        }

        public String startingTileId() {
            return this.value.substring(1, 2);
        }
    }
}

