/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.IAddressEditContainerListener;
import org.openstreetmap.josm.plugins.fixAddresses.ICommandListener;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;

public abstract class AbstractAddressEditAction
extends JosmAction
implements IAddressEditContainerListener,
ICommandListener {
    private AddressEditSelectionEvent event;
    protected AddressEditContainer container;
    protected List<Command> commands;
    private String txName;

    public AbstractAddressEditAction(String name, String iconName, String tooltip, String toolbar) {
        super(name, iconName, tooltip, null, true, toolbar, true);
        this.setEnabled(false);
    }

    public AbstractAddressEditAction(String name) {
        this(name, null, "", null);
    }

    public AddressEditContainer getContainer() {
        return this.container;
    }

    public void setContainer(AddressEditContainer container) {
        if (container != null) {
            container.removeChangedListener(this);
        }
        this.container = container;
        this.updateEnabledState();
        if (container != null) {
            container.addChangedListener(this);
        }
    }

    protected AddressEditSelectionEvent getEvent() {
        return this.event;
    }

    public void setEvent(AddressEditSelectionEvent event) {
        this.event = event;
        this.updateEnabledState();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.event != null) {
            this.addressEditActionPerformed(this.event);
            this.event = null;
        } else if (this.container != null) {
            this.addressEditActionPerformed(this.container);
        } else {
            throw new RuntimeException("AbstractAddressEditAction has no container or event");
        }
    }

    protected void updateEnabledState() {
        if (this.event != null) {
            this.updateEnabledState(this.event);
        } else if (this.container != null) {
            this.updateEnabledState(this.container);
        } else {
            super.updateEnabledState();
        }
    }

    protected abstract void updateEnabledState(AddressEditContainer var1);

    protected abstract void updateEnabledState(AddressEditSelectionEvent var1);

    public abstract void addressEditActionPerformed(AddressEditSelectionEvent var1);

    public abstract void addressEditActionPerformed(AddressEditContainer var1);

    @Override
    public void containerChanged(AddressEditContainer container) {
        this.updateEnabledState();
    }

    @Override
    public void entityChanged(IOSMEntity node) {
        this.container.removeProblemsOfSource(node);
        node.visit(this.container, this.container);
        this.updateEnabledState();
    }

    public void beginTransaction(String txName) {
        if (this.commands != null && this.commands.size() > 0) {
            throw new RuntimeException("TX has not been closed (missing finishTransaction?)");
        }
        this.commands = new ArrayList<Command>();
        if (StringUtils.isNullOrEmpty(txName)) {
            throw new RuntimeException("Transaction must have a name");
        }
        this.txName = txName;
    }

    public void finishTransaction() {
        if (this.commands == null) {
            throw new RuntimeException("No command list available. Did you forget to call beginTransaction?");
        }
        if (!this.commands.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand(this.txName, this.commands));
            this.commands.clear();
            if (this.container != null) {
                this.container.invalidate();
            }
        }
    }

    public void beginObjectTransaction(IOSMEntity entity) {
        if (entity == null) {
            throw new RuntimeException("Entity must not be null");
        }
        entity.addCommandListener(this);
    }

    public void finishObjectTransaction(IOSMEntity entity) {
        if (entity == null) {
            throw new RuntimeException("Entity must not be null");
        }
        entity.removeCommandListener(this);
    }

    @Override
    public void commandIssued(IOSMEntity entity, Command command) {
        if (this.commands == null) {
            throw new RuntimeException("No command list available. Did you forget to call beginTransaction?");
        }
        this.commands.add(command);
    }
}

