/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.preferences;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.FilterInfo;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Logging;

public class FiltersDownloader
implements ActionListener {
    private static volatile File pluginDir;
    public static Set<JsonObject> filtersMeta;
    public static Set<String> filterTitles;
    public static List<URL> binariesLocalUrls;
    public static ClassLoader loader;
    public static Map<String, String> urlsMap;
    private static Set<JsonObject> filtersMetaToLoad;
    static List<FilterInfo> filtersInfoList;

    public static List<FilterInfo> downloadFiltersInfoList() {
        try {
            Document doc = Jsoup.connect(HelpUtil.getWikiBaseHelpUrl() + "/ImageFilters").get();
            for (Element element : doc.getElementsByTag("tr")) {
                Elements elems = element.getElementsByTag("td");
                if (elems.isEmpty()) continue;
                String name = ((Element)elems.get(0)).text();
                String owner = ((Element)elems.get(1)).text();
                String description = ((Element)elems.get(2)).text();
                String link = ((Element)elems.get(0)).getElementsByTag("a").attr("href");
                JsonObject meta = FiltersDownloader.loadMeta(link);
                if (meta == null) continue;
                boolean needToLoad = Config.getPref().getBoolean("rasterfilters." + meta.getString("name"));
                if (needToLoad) {
                    JsonArray binaries = meta.getJsonArray("binaries");
                    filterTitles.add(meta.getString("title"));
                    for (int i = 0; i < binaries.size(); ++i) {
                        filtersMetaToLoad.add(meta);
                        FiltersDownloader.loadBinaryToFile(binaries.getString(i));
                    }
                }
                FilterInfo newFilterInfo = new FilterInfo(name, description, meta, needToLoad);
                newFilterInfo.setOwner(owner);
                if (filtersInfoList.contains(newFilterInfo)) continue;
                filtersInfoList.add(newFilterInfo);
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
        FiltersDownloader.loadBinariesFromMeta(filtersMetaToLoad);
        return filtersInfoList;
    }

    public static JsonObject loadMeta(String link) {
        Pattern p = Pattern.compile("ImageFilters/\\w.*");
        Matcher m = p.matcher(link);
        if (m.find()) {
            link = link.substring(m.start());
        }
        JsonObject meta = null;
        try {
            Document doc = Jsoup.connect(HelpUtil.getWikiBaseHelpUrl() + "/" + link).get();
            try (JsonReader reader = Json.createReader((Reader)new StringReader(doc.getElementsByTag("pre").first().text()));){
                meta = reader.readObject();
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
        if (meta != null) {
            filtersMeta.add(meta);
        }
        return meta;
    }

    public static void initFilters() {
        block12: {
            try {
                BufferedReader br = Files.newBufferedReader(new File(pluginDir, "urls.map").toPath(), StandardCharsets.UTF_8);
                Throwable throwable = null;
                block9: while (true) {
                    try {
                        String temp;
                        while ((temp = br.readLine()) != null) {
                            String[] mapEntry = temp.split("\\t");
                            File fileUrl = new File(mapEntry[1]);
                            if (!fileUrl.exists()) continue;
                            try {
                                URL url = new URL("jar", "", fileUrl.toURI().toURL() + "!/");
                                Logging.debug((String)("binaryUrl: " + url.toString()));
                                binariesLocalUrls.add(url);
                                continue block9;
                            }
                            catch (MalformedURLException e) {
                                Logging.debug((String)("Initializing filters with unknown protocol. \n" + e.getMessage()));
                            }
                        }
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (br != null) {
                        FiltersDownloader.$closeResource(throwable, br);
                    }
                }
            }
            catch (IOException e) {
                Logging.error((Throwable)e);
            }
        }
        loader = new URLClassLoader(binariesLocalUrls.toArray(new URL[binariesLocalUrls.size()]), FiltersDownloader.class.getClassLoader());
    }

    public static void destroyFilters() {
        filterTitles.clear();
        binariesLocalUrls.clear();
        filtersMeta.clear();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (FilterInfo temp : filtersInfoList) {
            if (temp.isNeedToDownload()) {
                filtersMetaToLoad.add(temp.getMeta());
                filterTitles.add(temp.getMeta().getString("title"));
                continue;
            }
            filterTitles.remove(temp.getMeta().getString("title"));
        }
        FiltersDownloader.loadBinariesFromMeta(filtersMetaToLoad);
        filtersMetaToLoad.clear();
    }

    public static void loadBinariesFromMeta(Set<JsonObject> metaList) {
        File file = new File(pluginDir, "urls.map");
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (JsonObject temp : metaList) {
                JsonArray binaries = temp.getJsonArray("binaries");
                for (int i = 0; i < binaries.size(); ++i) {
                    String localFile = FiltersDownloader.loadBinaryToFile(binaries.getString(i));
                    try {
                        writer.append(binaries.getString(i));
                        writer.append("\t");
                        writer.append(localFile);
                        writer.append("\n");
                        continue;
                    }
                    catch (IOException e) {
                        Logging.error((Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
    }

    public static void setPluginDir(File dir) {
        pluginDir = dir;
    }

    public static String loadBinaryToFile(String fromUrl) {
        Pattern p = Pattern.compile("\\w.*/");
        Matcher m = p.matcher(fromUrl);
        String localFile = null;
        if (m.find() && pluginDir.exists()) {
            localFile = fromUrl.substring(m.end());
        }
        try {
            File file = new File(pluginDir.getAbsolutePath(), localFile);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            try (InputStream in = HttpClient.create((URL)new URL(fromUrl)).connect().getContent();){
                Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            return localFile;
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
            return null;
        }
    }

    static {
        filtersMeta = new HashSet<JsonObject>();
        filterTitles = new TreeSet<String>();
        binariesLocalUrls = new ArrayList<URL>();
        urlsMap = new HashMap<String, String>();
        filtersMetaToLoad = new HashSet<JsonObject>();
        filtersInfoList = new ArrayList<FilterInfo>();
    }
}

