/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.model;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.plugins.rasterfilters.values.BooleanValue;
import org.openstreetmap.josm.plugins.rasterfilters.values.ColorValue;
import org.openstreetmap.josm.plugins.rasterfilters.values.SelectValue;
import org.openstreetmap.josm.plugins.rasterfilters.values.SliderValue;
import org.openstreetmap.josm.plugins.rasterfilters.values.Value;

public class FilterStateModel {
    private Map<String, Value<?>> params = new HashMap();
    private String filterClassName;

    public Map<String, Value<?>> getParams() {
        return this.params;
    }

    public String getFilterClassName() {
        return this.filterClassName;
    }

    public void setFilterClassName(String filterClassName) {
        this.filterClassName = filterClassName;
    }

    public void addParams(JsonObject json) {
        String parameterName = json.getString("name");
        String valueType = json.getString("value_type");
        if ("linear_slider".equals(json.getString("type"))) {
            if ("float".equals(valueType) || "double".equals(valueType)) {
                double defaultValue = json.getJsonNumber("default").doubleValue();
                SliderValue<Double> value = new SliderValue<Double>(parameterName, defaultValue);
                this.params.put(parameterName, value);
            } else if ("integer".equals(valueType)) {
                int defaultValue = json.getJsonNumber("default").intValue();
                SliderValue<Integer> value = new SliderValue<Integer>(parameterName, defaultValue);
                this.params.put(parameterName, value);
            }
        } else if ("checkbox".equals(json.getString("type"))) {
            boolean defaultValue = json.getBoolean("default");
            BooleanValue value = new BooleanValue(parameterName, defaultValue);
            this.params.put(parameterName, value);
        } else if ("select".equals(json.getString("type"))) {
            String defaultValue = json.getString("default");
            SelectValue<String> value = new SelectValue<String>(parameterName, defaultValue);
            this.params.put(parameterName, value);
        } else if ("colorpicker".equals(json.getString("type"))) {
            JsonObject defaultColorJson = json.getJsonObject("default");
            int r = defaultColorJson.getInt("red");
            int g = defaultColorJson.getInt("green");
            int b = defaultColorJson.getInt("blue");
            Color defaultColor = new Color(r, g, b);
            ColorValue<Color> value = new ColorValue<Color>(parameterName, defaultColor);
            this.params.put(parameterName, value);
        }
    }

    public JsonObject encodeJson() {
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        for (Map.Entry<String, Value<?>> entry : this.params.entrySet()) {
            Object value = entry.getValue().getValue();
            if (value instanceof String) {
                jsonBuilder.add(entry.getKey(), (JsonValue)Json.createObjectBuilder().add("value", (String)value).build());
            }
            if (value instanceof Boolean) {
                jsonBuilder.add(entry.getKey(), (JsonValue)Json.createObjectBuilder().add("value", ((Boolean)value).booleanValue()).build());
            }
            if (value instanceof Number) {
                if (value instanceof Double) {
                    jsonBuilder.add(entry.getKey(), (JsonValue)Json.createObjectBuilder().add("value", ((Double)value).doubleValue()).build());
                } else if (value instanceof Integer) {
                    jsonBuilder.add(entry.getKey(), (JsonValue)Json.createObjectBuilder().add("value", ((Integer)value).intValue()).build());
                }
            }
            if (!(value instanceof Color)) continue;
            jsonBuilder.add(entry.getKey(), (JsonValue)Json.createObjectBuilder().add("value", (JsonValue)Json.createObjectBuilder().add("red", ((Color)value).getRed()).add("green", ((Color)value).getGreen()).add("blue", ((Color)value).getBlue()).build()).build());
        }
        return jsonBuilder.build();
    }
}

