/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class ReconstructPolygonAction
extends JosmAction
implements ChosenRelationListener {
    private final transient ChosenRelation rel;
    private static final List<String> IRRELEVANT_KEYS = Arrays.asList("source", "created_by", "note");

    public ReconstructPolygonAction(ChosenRelation rel) {
        super(I18n.tr((String)"Reconstruct polygon", (Object[])new Object[0]), "dialogs/filter", I18n.tr((String)"Reconstruct polygon from multipolygon relation", (Object[])new Object[0]), Shortcut.registerShortcut((String)"reltoolbox:reconstructpoly", (String)I18n.tr((String)"Relation Toolbox: {0}", (Object[])new Object[]{I18n.tr((String)"Reconstruct polygon from multipolygon relation", (Object[])new Object[0])}), (int)65535, (int)5000), false, false);
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(ReconstructPolygonAction.isSuitableRelation(rel.get()));
    }

    public void actionPerformed(ActionEvent e) {
        Relation r = this.rel.get();
        boolean relationReused = false;
        ArrayList<Way> ways = new ArrayList<Way>();
        boolean wont = false;
        for (RelationMember m : r.getMembers()) {
            if (m.isWay()) {
                ways.add(m.getWay());
                continue;
            }
            wont = true;
        }
        if (wont) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Multipolygon must consist only of ways", (Object[])new Object[0]), I18n.tr((String)"Reconstruct polygon", (Object[])new Object[0]), 0);
            return;
        }
        MultipolygonBuilder mpc = new MultipolygonBuilder();
        String error = mpc.makeFromWays(ways);
        if (error != null) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), error);
            return;
        }
        this.rel.clear();
        ArrayList<Object> commands = new ArrayList<Object>();
        Command relationDeleteCommand = DeleteCommand.delete(Collections.singleton(r), (boolean)true, (boolean)true);
        if (relationDeleteCommand == null) {
            return;
        }
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        for (MultipolygonBuilder.JoinedPolygon p2 : mpc.outerWays) {
            ArrayList<MultipolygonBuilder.JoinedPolygon> myInnerWays = new ArrayList<MultipolygonBuilder.JoinedPolygon>();
            for (MultipolygonBuilder.JoinedPolygon i : mpc.innerWays) {
                EastNorth en = ((Way)i.ways.get(0)).firstNode().getEastNorth();
                if (!p2.area.contains(en.east(), en.north())) continue;
                myInnerWays.add(i);
            }
            if (!myInnerWays.isEmpty()) {
                ArrayList<RelationMember> members = new ArrayList<RelationMember>();
                for (Way w : p2.ways) {
                    members.add(new RelationMember("outer", (OsmPrimitive)w));
                }
                for (MultipolygonBuilder.JoinedPolygon i : myInnerWays) {
                    for (Object w : i.ways) {
                        members.add(new RelationMember("inner", (OsmPrimitive)w));
                    }
                }
                if (relationReused) {
                    Relation n = new Relation();
                    n.setKeys(r.getKeys());
                    n.setMembers(members);
                    commands.add(new AddCommand(ds, (OsmPrimitive)n));
                    continue;
                }
                relationReused = true;
                commands.add(new ChangeMembersCommand(r, members));
                continue;
            }
            TagMap tags = ((Way)p2.ways.get(0)).getKeys();
            if (!((Way)p2.ways.get(0)).hasAreaTags()) {
                tags.clear();
            }
            List relations = ((Way)p2.ways.get(0)).getReferrers();
            HashSet<String> noTags = new HashSet<String>(r.keySet());
            for (int i = 1; i < p2.ways.size(); ++i) {
                Object w;
                Way w2 = (Way)p2.ways.get(i);
                w = w2.keySet().iterator();
                while (w.hasNext()) {
                    String key = (String)w.next();
                    String value = w2.get(key);
                    if (noTags.contains(key) || !tags.containsKey(key) || ((String)tags.get(key)).equals(value)) continue;
                    tags.remove(key);
                    noTags.add(key);
                }
                List referrers = w2.getReferrers();
                relations.removeIf(osmPrimitive -> !referrers.contains(osmPrimitive));
            }
            tags.putAll(r.getKeys());
            tags.remove("type");
            Object candidateWay = null;
            for (Object w : p2.ways) {
                if (w.getReferrers().size() != 1) continue;
                HashSet keys = new HashSet(w.keySet());
                keys.removeAll(tags.keySet());
                IRRELEVANT_KEYS.forEach(keys::remove);
                if (!keys.isEmpty()) continue;
                if (candidateWay == null) {
                    candidateWay = w;
                    continue;
                }
                if (candidateWay.isNew() && !w.isNew()) {
                    Object tmp = w;
                    w = candidateWay;
                    candidateWay = tmp;
                }
                commands.add(new DeleteCommand((OsmPrimitive)w));
            }
            Way result = candidateWay == null ? new Way() : new Way(candidateWay);
            result.setNodes(p2.nodes);
            result.addNode(result.firstNode());
            result.setKeys((Map)tags);
            commands.add(candidateWay == null ? new AddCommand(ds, (OsmPrimitive)result) : new ChangeCommand(candidateWay, (OsmPrimitive)result));
        }
        if (!relationReused) {
            commands.add(0, relationDeleteCommand);
        }
        UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Reconstruct polygons from relation {0}", (Object[])new Object[]{r.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
        Collection newSelection = UndoRedoHandler.getInstance().getLastCommand().getParticipatingPrimitives();
        newSelection.removeIf(p -> p.isDeleted());
        ds.setSelected(newSelection);
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(ReconstructPolygonAction.isSuitableRelation(newRelation));
    }

    private static boolean isSuitableRelation(Relation newRelation) {
        return newRelation != null && "multipolygon".equals(newRelation.get("type")) && newRelation.getMembersCount() != 0;
    }
}

