/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.data.imagery;

import jakarta.json.JsonObject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.pmtiles.lib.Header;
import org.openstreetmap.josm.plugins.pmtiles.lib.PMTiles;

public class PMTilesImageryInfo
extends ImageryInfo {
    private final Header header;
    private final JsonObject meta;

    public PMTilesImageryInfo(Header header) {
        Objects.requireNonNull(header);
        this.setBounds(new ImageryInfo.ImageryBounds(Double.toString(header.minLatitude()) + "," + header.minLongitude() + "," + header.maxLatitude() + "," + header.maxLongitude(), ","));
        this.setUrl("");
        this.minZoom = header.minZoom();
        this.maxZoom = header.maxZoom();
        this.setDefaultMaxZoom(this.maxZoom);
        this.setDefaultMinZoom(this.minZoom);
        this.header = header;
        try {
            this.meta = PMTiles.readMetadata(header);
            this.setName(this.meta.getString("name", null));
            this.description = this.meta.getString("description", null);
            this.setAttributionText(this.meta.getString("attribution", null));
            if ("overlay".equals(this.meta.getString("type", null))) {
                this.setOverlay(true);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Header header() {
        return this.header;
    }

    public JsonObject metadata() {
        return this.meta;
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.header.hashCode();
    }

    public boolean equals(Object o) {
        return super.equals(o) && this.header.equals(((PMTilesImageryInfo)((Object)o)).header);
    }
}

