/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListProvider;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdTransferable;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class PrimitiveIdListTransferHandler
extends TransferHandler {
    private PrimitiveIdListProvider provider;

    public static boolean isSupportedFlavor(DataFlavor[] transferFlavors) {
        for (DataFlavor df : transferFlavors) {
            if (!df.equals(PrimitiveIdTransferable.PRIMITIVE_ID_LIST_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    public PrimitiveIdListTransferHandler(PrimitiveIdListProvider provider) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)provider, (String)"provider");
        this.provider = provider;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new PrimitiveIdTransferable(this.provider.getSelectedPrimitiveIds());
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return PrimitiveIdListTransferHandler.isSupportedFlavor(transferFlavors);
    }
}

