/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.conflict.ConflictAddCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UserCancelException;
import reverter.ChangesetReverter;
import reverter.RevertChangesetCommand;
import reverter.RevertRedactedChangesetException;

public class RevertChangesetTask
extends PleaseWaitRunnable {
    private final Collection<Integer> changesetIds;
    private final ChangesetReverter.RevertType revertType;
    private boolean newLayer;
    private final DataSet oldDataSet;
    private ChangesetReverter rev;
    private boolean downloadConfirmed;
    private int numberOfConflicts;

    public RevertChangesetTask(int changesetId, ChangesetReverter.RevertType revertType) {
        this(changesetId, revertType, false);
    }

    public RevertChangesetTask(int changesetId, ChangesetReverter.RevertType revertType, boolean autoConfirmDownload) {
        this(changesetId, revertType, autoConfirmDownload, false);
    }

    public RevertChangesetTask(int changesetId, ChangesetReverter.RevertType revertType, boolean autoConfirmDownload, boolean newLayer) {
        this(Collections.singleton(changesetId), revertType, autoConfirmDownload, newLayer);
    }

    public RevertChangesetTask(Collection<Integer> changesetIds, ChangesetReverter.RevertType revertType, boolean autoConfirmDownload, boolean newLayer) {
        this(null, changesetIds, revertType, autoConfirmDownload, newLayer);
    }

    public RevertChangesetTask(ProgressMonitor progressMonitor, Collection<Integer> changesetIds, ChangesetReverter.RevertType revertType, boolean autoConfirmDownload, boolean newLayer) {
        super(I18n.tr((String)"Reverting...", (Object[])new Object[0]), progressMonitor, false);
        this.changesetIds = new ArrayList<Integer>(changesetIds);
        this.revertType = revertType;
        this.downloadConfirmed = autoConfirmDownload;
        this.newLayer = newLayer;
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        this.oldDataSet = editLayer == null ? null : editLayer.data;
    }

    private boolean checkAndDownloadMissing() throws OsmTransferException {
        if (!this.rev.hasMissingObjects()) {
            return true;
        }
        if (!this.downloadConfirmed) {
            Integer selectedOption = (Integer)GuiHelper.runInEDTAndWaitAndReturn((Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return JOptionPane.showConfirmDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"This changeset has objects that are not present in current dataset.\nIt is needed to download them before reverting. Do you want to continue?", (Object[])new Object[0]), I18n.tr((String)"Confirm", (Object[])new Object[0]), 0);
                }
            });
            boolean bl = this.downloadConfirmed = selectedOption != null && selectedOption == 0;
            if (!this.downloadConfirmed) {
                return false;
            }
        }
        this.progressMonitor.setTicks(0);
        this.rev.downloadMissingPrimitives(this.progressMonitor.createSubTaskMonitor(-1, false));
        return !this.progressMonitor.isCanceled();
    }

    protected void realRun() throws OsmTransferException {
        this.numberOfConflicts = 0;
        ArrayList<Command> allcmds = new ArrayList<Command>();
        Logging.info((String)"Reverting {0} changeset(s): {1}", (Object[])new Object[]{this.changesetIds.size(), this.changesetIds.stream().map(Long::toString).collect(Collectors.toList())});
        for (int changesetId : this.changesetIds) {
            try {
                Logging.info((String)"Reverting changeset {0}", (Object[])new Object[]{Long.toString(changesetId)});
                RevertChangesetCommand cmd = this.revertChangeset(changesetId);
                if (cmd != null) {
                    allcmds.add((Command)cmd);
                }
                Logging.info((String)"Reverted changeset {0}", (Object[])new Object[]{Long.toString(changesetId)});
                this.newLayer = false;
            }
            catch (OsmTransferException e) {
                RevertChangesetTask.rollback(allcmds);
                Logging.error((Throwable)e);
                throw e;
            }
            catch (UserCancelException e) {
                RevertChangesetTask.rollback(allcmds);
                GuiHelper.executeByMainWorkerInEDT(() -> new Notification(I18n.tr((String)"Revert was canceled", (Object[])new Object[0])).show());
                Logging.trace((Throwable)e);
                return;
            }
        }
        if (!allcmds.isEmpty()) {
            RevertChangesetCommand cmd = allcmds.size() == 1 ? (Command)allcmds.get(0) : new RevertChangesetCommand(I18n.tr((String)"Revert changesets", (Object[])new Object[0]), allcmds);
            GuiHelper.runInEDT(() -> this.lambda$realRun$1((Command)cmd));
        }
    }

    private static void rollback(List<Command> allcmds) {
        if (!allcmds.isEmpty()) {
            GuiHelper.runInEDT(() -> UndoRedoHandler.getInstance().undo(allcmds.size()));
        }
    }

    private RevertChangesetCommand revertChangeset(int changesetId) throws OsmTransferException, UserCancelException {
        int numConflicts;
        this.progressMonitor.indeterminateSubTask(I18n.tr((String)"Reverting changeset {0}", (Object[])new Object[]{Long.toString(changesetId)}));
        try {
            this.rev = new ChangesetReverter(changesetId, this.revertType, this.newLayer, this.oldDataSet, this.progressMonitor.createSubTaskMonitor(0, true));
        }
        catch (RevertRedactedChangesetException e) {
            GuiHelper.runInEDT(() -> new Notification(e.getMessage() + "<br>" + I18n.tr((String)"See {0}", (Object[])new Object[]{"<a href=\"https://www.openstreetmap.org/redactions\">https://www.openstreetmap.org/redactions</a>"})).setIcon(0).setDuration(Notification.TIME_LONG).show());
            this.progressMonitor.cancel();
        }
        if (this.progressMonitor.isCanceled()) {
            throw new UserCancelException();
        }
        int numOldConflicts = this.oldDataSet == null ? 0 : this.oldDataSet.getConflicts().size();
        this.rev.checkMissingCreated();
        this.rev.checkMissingUpdated();
        if (this.rev.hasMissingObjects()) {
            this.rev.checkMissingDeleted();
            if (!this.checkAndDownloadMissing()) {
                throw new UserCancelException();
            }
        } else {
            this.rev.checkMissingDeleted();
            this.rev.downloadMissingPrimitives(this.progressMonitor.createSubTaskMonitor(-1, false));
        }
        int n = numConflicts = this.oldDataSet == null ? 0 : this.oldDataSet.getConflicts().size();
        if (numConflicts > numOldConflicts) {
            GuiHelper.runInEDT(() -> new Notification(I18n.tr((String)"Please solve conflicts and maybe try again to revert.", (Object[])new Object[0])).setIcon(0).show());
            return null;
        }
        if (this.progressMonitor.isCanceled()) {
            throw new UserCancelException();
        }
        this.progressMonitor.setTicks(0);
        this.rev.downloadObjectsHistory(this.progressMonitor.createSubTaskMonitor(-1, false));
        if (this.progressMonitor.isCanceled()) {
            throw new UserCancelException();
        }
        if (!this.checkAndDownloadMissing()) {
            throw new UserCancelException();
        }
        this.progressMonitor.setTicks(0);
        this.rev.fixNodesWithoutCoordinates(this.progressMonitor.createSubTaskMonitor(-1, false));
        if (this.progressMonitor.isCanceled()) {
            throw new UserCancelException();
        }
        List<Command> cmds = this.rev.getCommands();
        if (cmds.isEmpty()) {
            Logging.warn((String)MessageFormat.format("No revert commands found for changeset {0}", Long.toString(changesetId)));
            return null;
        }
        GuiHelper.runInEDT(() -> {
            for (Command c : cmds) {
                if (c instanceof ConflictAddCommand) {
                    ++this.numberOfConflicts;
                }
                c.executeCommand();
            }
        });
        String desc = this.revertType == ChangesetReverter.RevertType.FULL ? I18n.tr((String)"Revert changeset {0}", (Object[])new Object[]{String.valueOf(changesetId)}) : I18n.tr((String)"Partially revert changeset {0}", (Object[])new Object[]{String.valueOf(changesetId)});
        return new RevertChangesetCommand(desc, cmds);
    }

    protected void cancel() {
    }

    protected void finish() {
    }

    public final int getNumberOfConflicts() {
        return this.numberOfConflicts;
    }

    private /* synthetic */ void lambda$realRun$1(Command cmd) {
        UndoRedoHandler.getInstance().add(cmd, false);
        if (this.numberOfConflicts > 0) {
            MainApplication.getMap().conflictDialog.warnNumNewConflicts(this.numberOfConflicts);
        }
    }
}

