/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Color;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import livegps.LiveGpsData;
import livegps.LiveGpsStatus;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.data.coor.conversion.ProjectedCoordinateFormat;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class LiveGpsDialog
extends ToggleDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 6183400754671501117L;
    private boolean statusGPSD;
    private boolean statusNMEA;
    private JLabel statusText;
    private JLabel statusLabel;
    private JLabel nmeaStatusText;
    private JLabel nmeaStatusLabel;
    private JLabel wayLabel;
    private JLabel latText;
    private JLabel latLabel;
    private JLabel longText;
    private JLabel longLabel;
    private JLabel courseLabel;
    private JLabel speedLabel;
    private JLabel wayText;
    private JPanel panel;
    private LiveGpsStatus status = new LiveGpsStatus(LiveGpsStatus.GpsStatus.CONNECTING, I18n.tr((String)"Connecting", (Object[])new Object[0]));
    private LiveGpsStatus nmeaStatus = new LiveGpsStatus(LiveGpsStatus.GpsStatus.CONNECTING, I18n.tr((String)"Connecting", (Object[])new Object[0]));
    private LiveGpsData data;

    public LiveGpsDialog(MapFrame mapFrame) {
        super(I18n.tr((String)"Live GPS", (Object[])new Object[0]), "livegps", I18n.tr((String)"Show GPS data.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:livegps", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Live GPS", (Object[])new Object[0])}), (int)71, (int)5010), 100);
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(7, 2));
        this.statusText = new JLabel(I18n.tr((String)"Status gpsd", (Object[])new Object[0]));
        this.panel.add(this.statusText);
        this.statusLabel = new JLabel();
        this.panel.add(this.statusLabel);
        this.nmeaStatusText = new JLabel(I18n.tr((String)"Status NMEA", (Object[])new Object[0]));
        this.panel.add(this.nmeaStatusText);
        this.nmeaStatusLabel = new JLabel();
        this.panel.add(this.nmeaStatusLabel);
        this.wayText = new JLabel(I18n.tr((String)"Way Info", (Object[])new Object[0]));
        this.panel.add(this.wayText);
        this.wayLabel = new JLabel();
        this.panel.add(this.wayLabel);
        this.latText = new JLabel(I18n.tr((String)"Latitude", (Object[])new Object[0]));
        this.panel.add(this.latText);
        this.latLabel = new JLabel();
        this.panel.add(this.latLabel);
        this.longText = new JLabel(I18n.tr((String)"Longitude", (Object[])new Object[0]));
        this.panel.add(this.longText);
        this.longLabel = new JLabel();
        this.panel.add(this.longLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Speed", (Object[])new Object[0])));
        this.speedLabel = new JLabel();
        this.panel.add(this.speedLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Course", (Object[])new Object[0])));
        this.courseLabel = new JLabel();
        this.panel.add(this.courseLabel);
        this.setStatusVisibility(true);
        if (Config.getPref().getBoolean("livegps.way.offset", false)) {
            this.wayText.setText(I18n.tr((String)"Way Info [m]", (Object[])new Object[0]));
        } else {
            this.wayText.setText(I18n.tr((String)"Way Info", (Object[])new Object[0]));
        }
        this.createLayout(this.panel, true, null);
    }

    private void setStatusVisibility(boolean init) {
        boolean statusNMEANew;
        boolean statusGPSDNew;
        boolean bl = statusGPSDNew = !Config.getPref().getBoolean("livegps.gpsd.disabled");
        if (init || this.statusGPSD != statusGPSDNew) {
            this.statusText.setVisible(statusGPSDNew);
            this.statusLabel.setVisible(statusGPSDNew);
            this.statusGPSD = statusGPSDNew;
        }
        boolean bl2 = statusNMEANew = !Config.getPref().get("livegps.serial.port").isEmpty();
        if (init || this.statusNMEA != statusNMEANew) {
            this.nmeaStatusText.setVisible(statusNMEANew);
            this.nmeaStatusLabel.setVisible(statusNMEANew);
            this.statusNMEA = statusNMEANew;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isVisible()) {
            return;
        }
        if ("gpsdata".equals(evt.getPropertyName())) {
            this.data = (LiveGpsData)evt.getNewValue();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LiveGpsDialog.this.data.isFix()) {
                        LiveGpsDialog.this.panel.setBackground(Color.WHITE);
                        ICoordinateFormat mCord = CoordinateFormatManager.getDefaultFormat();
                        if (ProjectedCoordinateFormat.INSTANCE.equals(mCord)) {
                            LiveGpsDialog.this.latText.setText(I18n.tr((String)"Northing", (Object[])new Object[0]));
                            LiveGpsDialog.this.longText.setText(I18n.tr((String)"Easting", (Object[])new Object[0]));
                        } else {
                            LiveGpsDialog.this.latText.setText(I18n.tr((String)"Latitude", (Object[])new Object[0]));
                            LiveGpsDialog.this.longText.setText(I18n.tr((String)"Longitude", (Object[])new Object[0]));
                        }
                        LiveGpsDialog.this.latLabel.setText(mCord.latToString((ILatLon)LiveGpsDialog.this.data.getLatLon()));
                        LiveGpsDialog.this.longLabel.setText(mCord.lonToString((ILatLon)LiveGpsDialog.this.data.getLatLon()));
                        double mySpeed = LiveGpsDialog.this.data.getSpeed() * 3.6f;
                        LiveGpsDialog.this.speedLabel.setText(I18n.tr((String)"{0} km/h", (Object[])new Object[]{Math.round(mySpeed * 100.0) / 100L}));
                        LiveGpsDialog.this.courseLabel.setText(I18n.tr((String)"{0} deg", (Object[])new Object[]{Float.valueOf(LiveGpsDialog.this.data.getCourse())}));
                        String wayString = LiveGpsDialog.this.data.getWayInfo();
                        if (!wayString.isEmpty()) {
                            LiveGpsDialog.this.wayLabel.setText(wayString);
                        } else {
                            LiveGpsDialog.this.wayLabel.setText(I18n.tr((String)"unknown", (Object[])new Object[0]));
                        }
                        if (Config.getPref().getBoolean("livegps.way.offset", false)) {
                            LiveGpsDialog.this.wayText.setText(I18n.tr((String)"Way Info [m]", (Object[])new Object[0]));
                        } else {
                            LiveGpsDialog.this.wayText.setText(I18n.tr((String)"Way Info", (Object[])new Object[0]));
                        }
                    } else {
                        LiveGpsDialog.this.latLabel.setText("");
                        LiveGpsDialog.this.longLabel.setText("");
                        LiveGpsDialog.this.speedLabel.setText("");
                        LiveGpsDialog.this.courseLabel.setText("");
                        LiveGpsDialog.this.panel.setBackground(Color.RED);
                    }
                }
            });
        } else if ("gpsstatus".equals(evt.getPropertyName())) {
            final LiveGpsStatus oldStatus = this.status;
            this.status = (LiveGpsStatus)evt.getNewValue();
            this.setStatusVisibility(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (oldStatus.getStatus() != LiveGpsStatus.GpsStatus.CONNECTION_FAILED || LiveGpsDialog.this.status.getStatus() != LiveGpsStatus.GpsStatus.CONNECTING || LiveGpsDialog.this.nmeaStatus.getStatus() != LiveGpsStatus.GpsStatus.CONNECTED) {
                        LiveGpsDialog.this.statusLabel.setText(LiveGpsDialog.this.status.getStatusMessage());
                    }
                    if (LiveGpsDialog.this.status.getStatus() != LiveGpsStatus.GpsStatus.CONNECTED && LiveGpsDialog.this.nmeaStatus.getStatus() != LiveGpsStatus.GpsStatus.CONNECTED) {
                        LiveGpsDialog.this.panel.setBackground(Color.RED);
                    } else {
                        LiveGpsDialog.this.panel.setBackground(Color.WHITE);
                    }
                }
            });
        } else if ("nmeastatus".equals(evt.getPropertyName())) {
            this.nmeaStatus = (LiveGpsStatus)evt.getNewValue();
            this.setStatusVisibility(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LiveGpsDialog.this.nmeaStatusLabel.setText(LiveGpsDialog.this.nmeaStatus.getStatusMessage());
                }
            });
        }
    }
}

