/*
 * Decompiled with CFR 0.152.
 */
package com.bric.plaf;

import com.bric.util.JVM;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.swing.UIManager;

public class PlafPaintUtils {
    static final Color[] whites = new Color[]{new Color(255, 255, 255, 50), new Color(255, 255, 255, 100), new Color(255, 255, 255, 150)};
    static final Color[] blacks = new Color[]{new Color(0, 0, 0, 50), new Color(0, 0, 0, 100), new Color(0, 0, 0, 150)};
    private static Hashtable<String, TexturePaint> verticalGradients;
    private static Hashtable<String, TexturePaint> checkers;

    public static Color getFocusRingColor() {
        Color obj = UIManager.getColor("Focus.color");
        if (obj instanceof Color) {
            return obj;
        }
        obj = UIManager.getColor("focusRing");
        if (obj instanceof Color) {
            return obj;
        }
        return new Color(64, 113, 167);
    }

    public static void paintFocus(Graphics2D g, Shape shape, int pixelSize) {
        PlafPaintUtils.paintFocus(g, shape, pixelSize, PlafPaintUtils.getFocusRingColor(), true);
    }

    public static void paintFocus(Graphics2D g, Shape shape, int pixelSize, Color focusColor, boolean changeRenderingHints) {
        g = (Graphics2D)g.create();
        try {
            Color[] focusArray = new Color[]{new Color(focusColor.getRed(), focusColor.getGreen(), focusColor.getBlue(), 235 * focusColor.getAlpha() / 255), new Color(focusColor.getRed(), focusColor.getGreen(), focusColor.getBlue(), 130 * focusColor.getAlpha() / 255), new Color(focusColor.getRed(), focusColor.getGreen(), focusColor.getBlue(), 80 * focusColor.getAlpha() / 255)};
            if (changeRenderingHints) {
                if (JVM.usingQuartz) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                }
            }
            g.setStroke(new BasicStroke(2 * pixelSize + 1, 1, 1));
            g.setColor(focusArray[2]);
            g.draw(shape);
            if (2 * pixelSize + 1 > 0) {
                g.setStroke(new BasicStroke(2 * pixelSize - 2 + 1, 1, 1));
                g.setColor(focusArray[1]);
                g.draw(shape);
            }
            if (2 * pixelSize - 4 + 1 > 0) {
                g.setStroke(new BasicStroke(2 * pixelSize - 4 + 1, 1, 1));
                g.setColor(focusArray[0]);
                g.draw(shape);
            }
        }
        finally {
            g.dispose();
        }
    }

    public static void drawBevel(Graphics2D g, Rectangle r) {
        g.setStroke(new BasicStroke(1.0f));
        PlafPaintUtils.drawColors(blacks, g, r.x, r.y + r.height, r.x + r.width, r.y + r.height, 5);
        PlafPaintUtils.drawColors(blacks, g, r.x + r.width, r.y, r.x + r.width, r.y + r.height, 3);
        PlafPaintUtils.drawColors(whites, g, r.x, r.y, r.x + r.width, r.y, 1);
        PlafPaintUtils.drawColors(whites, g, r.x, r.y, r.x, r.y + r.height, 7);
        g.setColor(new Color(120, 120, 120));
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private static void drawColors(Color[] colors, Graphics g, int x1, int y1, int x2, int y2, int direction) {
        int a = 0;
        while (a < colors.length) {
            g.setColor(colors[colors.length - a - 1]);
            if (direction == 5) {
                g.drawLine(x1, y1 - a, x2, y2 - a);
            } else if (direction == 1) {
                g.drawLine(x1, y1 + a, x2, y2 + a);
            } else if (direction == 3) {
                g.drawLine(x1 - a, y1, x2 - a, y2);
            } else if (direction == 7) {
                g.drawLine(x1 + a, y1, x2 + a, y2);
            }
            ++a;
        }
    }

    static synchronized Paint getVerticalGradient(String name, int height, int y, float[] positions, Color[] colors) {
        String key;
        TexturePaint paint;
        if (verticalGradients == null) {
            verticalGradients = new Hashtable();
        }
        if ((paint = verticalGradients.get(key = String.valueOf(name) + " " + height + " " + y)) == null) {
            height = Math.max(height, 1);
            BufferedImage bi = new BufferedImage(1, height, 2);
            int[] array = new int[height];
            int a = 0;
            while (a < array.length) {
                float f = a;
                f /= (float)(array.length - 1);
                boolean hit = false;
                int b = 1;
                while (b < positions.length) {
                    if (f >= positions[b - 1] && f < positions[b]) {
                        float p = (f - positions[b - 1]) / (positions[b] - positions[b - 1]);
                        array[a] = PlafPaintUtils.tween(colors[b - 1], colors[b], p).getRGB();
                        hit = true;
                        break;
                    }
                    ++b;
                }
                if (!hit) {
                    array[a] = colors[colors.length - 1].getRGB();
                }
                ++a;
            }
            bi.getRaster().setDataElements(0, 0, 1, height, array);
            paint = new TexturePaint(bi, new Rectangle(0, y, 1, height));
            verticalGradients.put(key, paint);
        }
        return paint;
    }

    private static Color tween(Color c1, Color c2, float p) {
        int r1 = c1.getRed();
        int g1 = c1.getGreen();
        int b1 = c1.getBlue();
        int a1 = c1.getAlpha();
        int r2 = c2.getRed();
        int g2 = c2.getGreen();
        int b2 = c2.getBlue();
        int a2 = c2.getAlpha();
        return new Color((int)((float)r1 * (1.0f - p) + (float)r2 * p), (int)((float)g1 * (1.0f - p) + (float)g2 * p), (int)((float)b1 * (1.0f - p) + (float)b2 * p), (int)((float)a1 * (1.0f - p) + (float)a2 * p));
    }

    public static TexturePaint getCheckerBoard(int checkerSize) {
        return PlafPaintUtils.getCheckerBoard(checkerSize, Color.white, Color.lightGray);
    }

    public static TexturePaint getCheckerBoard(int checkerSize, Color color1, Color color2) {
        TexturePaint paint;
        String key = String.valueOf(checkerSize) + " " + color1.toString() + " " + color2.toString();
        if (checkers == null) {
            checkers = new Hashtable();
        }
        if ((paint = checkers.get(key)) == null) {
            BufferedImage bi = new BufferedImage(2 * checkerSize, 2 * checkerSize, 1);
            Graphics2D g = bi.createGraphics();
            g.setColor(color1);
            g.fillRect(0, 0, 2 * checkerSize, 2 * checkerSize);
            g.setColor(color2);
            g.fillRect(0, 0, checkerSize, checkerSize);
            g.fillRect(checkerSize, checkerSize, checkerSize, checkerSize);
            g.dispose();
            paint = new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
            checkers.put(key, paint);
        }
        return paint;
    }
}

