/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.housenumbertool;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.plugins.housenumbertool.Dto;
import org.openstreetmap.josm.plugins.housenumbertool.HouseNumberHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class TagDialog
extends ExtendedDialog {
    private static final long serialVersionUID = -4781477945608720136L;
    private static final String APPLY_CHANGES = I18n.tr((String)"Apply Changes", (Object[])new Object[0]);
    private static final String TAG_STREET_OR_PLACE = I18n.tr((String)"Use tag ''addr:street'' or ''addr:place''", (Object[])new Object[0]);
    private static final String TAG_BUILDING = "building";
    private static final String TAG_SOURCE = "source";
    private static final String TAG_ADDR_COUNTRY = "addr:country";
    private static final String TAG_ADDR_STATE = "addr:state";
    private static final String TAG_ADDR_CITY = "addr:city";
    private static final String TAG_ADDR_POSTCODE = "addr:postcode";
    private static final String TAG_ADDR_HOUSENUMBER = "addr:housenumber";
    private static final String TAG_ADDR_STREET = "addr:street";
    private static final String TAG_ADDR_PLACE = "addr:place";
    private static final String TAG_ADDR_SUBURB = "addr:suburb";
    private static final String[] BUILDING_STRINGS = new String[]{"yes", "apartments", "chapel", "church", "commercial", "dormitory", "hotel", "house", "residential", "terrace", "industrial", "retail", "warehouse", "cathedral", "civic", "hospital", "school", "train_station", "transportation", "university", "public", "bridge", "bunker", "cabin", "construction", "farm_auxiliary", "garage", "garages", "greenhouse", "hangar", "hut", "roof", "shed", "stable"};
    private static final int FPS_MIN = -10;
    private static final int FPS_MAX = 10;
    private final File pluginDir;
    private AutoCompletionManager acm;
    private final OsmPrimitive selection;
    private static final String TEMPLATE_DATA = "/template.data";
    private AutoCompComboBox<AutoCompletionItem> source;
    private AutoCompComboBox<AutoCompletionItem> country;
    private AutoCompComboBox<AutoCompletionItem> stateTag;
    private AutoCompComboBox<AutoCompletionItem> suburb;
    private AutoCompComboBox<AutoCompletionItem> city;
    private AutoCompComboBox<AutoCompletionItem> postcode;
    private AutoCompComboBox<AutoCompletionItem> street;
    private JTextField housenumber;
    private JCheckBox buildingEnabled;
    private JCheckBox sourceEnabled;
    private JCheckBox countryEnabled;
    private JCheckBox stateEnabled;
    private JCheckBox cityEnabled;
    private JCheckBox suburbEnabled;
    private JCheckBox zipEnabled;
    private JCheckBox streetEnabled;
    private JCheckBox housenumberEnabled;
    private JSlider housenumberChangeSequence;
    private JComboBox<String> building;
    private JRadioButton streetRadio;
    private JRadioButton placeRadio;

    public TagDialog(File pluginDir, OsmPrimitive selection) {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"House Number Editor", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
        this.pluginDir = pluginDir;
        this.selection = selection;
        JPanel editPanel = this.createContentPane();
        this.setPreferredSize(new Dimension(900, 500));
        this.setMinimumSize(new Dimension(900, 500));
        this.setContent(editPanel);
        this.setButtonIcons(new String[]{"ok", "cancel"});
        this.setDefaultButton(1);
        this.setupDialog();
        this.getRootPane().setDefaultButton(this.defaultButton);
        this.setLocationRelativeTo(null);
        SwingUtilities.invokeLater(() -> {
            this.housenumber.requestFocus();
            this.housenumber.selectAll();
        });
    }

    private JPanel createContentPane() {
        this.acm = AutoCompletionManager.of((DataSet)this.selection.getDataSet());
        Dto dto = this.loadDto();
        JPanel editPanel = new JPanel(new GridBagLayout());
        JLabel labelNewValues = new JLabel();
        Font newLabelFont = new Font(labelNewValues.getFont().getName(), 1, labelNewValues.getFont().getSize());
        labelNewValues.setFont(newLabelFont);
        labelNewValues.setText(I18n.tr((String)"New values:", (Object[])new Object[0]));
        editPanel.add((Component)labelNewValues, GBC.std().grid(3, 0).insets(0, 5, 10, 5));
        JLabel labelExistingValues = new JLabel();
        labelExistingValues.setFont(newLabelFont);
        labelExistingValues.setText(I18n.tr((String)"Existing values:", (Object[])new Object[0]));
        editPanel.add((Component)labelExistingValues, GBC.std().span(3).weight(0.0, 0.0).grid(5, 0).insets(0, 5, 10, 5));
        JButton getAllButton = new JButton("<<");
        getAllButton.setPreferredSize(new Dimension(60, 24));
        getAllButton.setToolTipText(I18n.tr((String)"Accept all existing values", (Object[])new Object[0]));
        getAllButton.addActionListener(actionEvent -> this.acceptAllExistingValues());
        editPanel.add((Component)getAllButton, GBC.eol().grid(7, 0).anchor(13).insets(0, 5, 10, 5));
        GBC columnOne = GBC.std().span(3).insets(5, 5, 0, 5);
        GBC columnTwo = GBC.std().span(1).weight(1.0, 0.0).fill(2).insets(5, 5, 0, 5);
        GBC columnThree = GBC.std().insets(5, 5, 0, 5);
        GBC columnFour = GBC.eol().weight(1.0, 0.0).fill(2).insets(5, 5, 0, 5);
        this.buildingEnabled = TagDialog.generateCheckbox(TAG_BUILDING, dto.isSaveBuilding());
        editPanel.add((Component)this.buildingEnabled, columnOne);
        Arrays.sort(BUILDING_STRINGS);
        this.building = new JosmComboBox((Object[])BUILDING_STRINGS);
        this.building.setSelectedItem(dto.getBuilding());
        this.building.setMaximumRowCount(50);
        editPanel.add(this.building, columnTwo);
        editPanel.add((Component)TagDialog.generateAcceptButton(actionEvent -> this.building.setSelectedItem(this.selection.get(TAG_BUILDING))), columnThree);
        editPanel.add((Component)TagDialog.generateTextField(this.selection.get(TAG_BUILDING)), columnFour);
        this.sourceEnabled = TagDialog.generateCheckbox(TAG_SOURCE, dto.isSaveSource());
        editPanel.add((Component)this.sourceEnabled, columnOne);
        this.source = TagDialog.generateAutoCompTextField((Collection<AutoCompletionItem>)this.acm.getTagValues(TAG_SOURCE), dto.getSource());
        editPanel.add((Component)this.source, columnTwo);
        editPanel.add((Component)TagDialog.generateAcceptButton(actionEvent -> this.source.setSelectedItem((Object)this.selection.get(TAG_SOURCE))), columnThree);
        editPanel.add((Component)TagDialog.generateTextField(this.selection.get(TAG_SOURCE)), columnFour);
        this.countryEnabled = TagDialog.generateCheckbox(TAG_ADDR_COUNTRY, dto.isSaveCountry());
        editPanel.add((Component)this.countryEnabled, columnOne);
        this.country = TagDialog.generateAutoCompTextField((Collection<AutoCompletionItem>)this.acm.getTagValues(TAG_ADDR_COUNTRY), dto.getCountry());
        editPanel.add((Component)this.country, columnTwo);
        editPanel.add((Component)TagDialog.generateAcceptButton(actionEvent -> this.country.setSelectedItem((Object)this.selection.get(TAG_ADDR_COUNTRY))), columnThree);
        editPanel.add((Component)TagDialog.generateTextField(this.selection.get(TAG_ADDR_COUNTRY)), columnFour);
        this.stateEnabled = TagDialog.generateCheckbox(TAG_ADDR_STATE, dto.isSaveState());
        editPanel.add((Component)this.stateEnabled, columnOne);
        this.stateTag = TagDialog.generateAutoCompTextField((Collection<AutoCompletionItem>)this.acm.getTagValues(TAG_ADDR_STATE), dto.getState());
        editPanel.add((Component)this.stateTag, columnTwo);
        editPanel.add((Component)TagDialog.generateAcceptButton(actionEvent -> this.stateTag.setSelectedItem((Object)this.selection.get(TAG_ADDR_STATE))), columnThree);
        editPanel.add((Component)TagDialog.generateTextField(this.selection.get(TAG_ADDR_STATE)), columnFour);
        this.suburbEnabled = TagDialog.generateCheckbox(TAG_ADDR_SUBURB, dto.isSaveSuburb());
        editPanel.add((Component)this.suburbEnabled, columnOne);
        this.suburb = TagDialog.generateAutoCompTextField((Collection<AutoCompletionItem>)this.acm.getTagValues(TAG_ADDR_SUBURB), dto.getSuburb());
        editPanel.add((Component)this.suburb, columnTwo);
        editPanel.add((Component)TagDialog.generateAcceptButton(actionEvent -> this.suburb.setSelectedItem((Object)this.selection.get(TAG_ADDR_SUBURB))), columnThree);
        editPanel.add((Component)TagDialog.generateTextField(this.selection.get(TAG_ADDR_SUBURB)), columnFour);
        this.cityEnabled = TagDialog.generateCheckbox(TAG_ADDR_CITY, dto.isSaveCity());
        editPanel.add((Component)this.cityEnabled, columnOne);
        this.city = TagDialog.generateAutoCompTextField((Collection<AutoCompletionItem>)this.acm.getTagValues(TAG_ADDR_CITY), dto.getCity());
        editPanel.add((Component)this.city, columnTwo);
        editPanel.add((Component)TagDialog.generateAcceptButton(actionEvent -> this.city.setSelectedItem((Object)this.selection.get(TAG_ADDR_CITY))), columnThree);
        editPanel.add((Component)TagDialog.generateTextField(this.selection.get(TAG_ADDR_CITY)), columnFour);
        this.zipEnabled = TagDialog.generateCheckbox(TAG_ADDR_POSTCODE, dto.isSavePostcode());
        editPanel.add((Component)this.zipEnabled, columnOne);
        this.postcode = TagDialog.generateAutoCompTextField((Collection<AutoCompletionItem>)this.acm.getTagValues(TAG_ADDR_POSTCODE), dto.getPostcode());
        editPanel.add((Component)this.postcode, columnTwo);
        editPanel.add((Component)TagDialog.generateAcceptButton(actionEvent -> this.postcode.setSelectedItem((Object)this.selection.get(TAG_ADDR_POSTCODE))), columnThree);
        editPanel.add((Component)TagDialog.generateTextField(this.selection.get(TAG_ADDR_POSTCODE)), columnFour);
        this.streetEnabled = TagDialog.generateCheckbox(null, dto.isSaveStreet());
        editPanel.add((Component)this.streetEnabled, GBC.std().insets(5, 5, 0, 5));
        this.streetRadio = new JRadioButton(TAG_ADDR_STREET);
        this.streetRadio.setToolTipText(TAG_STREET_OR_PLACE);
        this.streetRadio.setSelected(dto.isTagStreet());
        this.streetRadio.addItemListener(new RadioChangeListener());
        editPanel.add((Component)this.streetRadio, GBC.std().weight(0.0, 0.0).insets(5, 5, 0, 5));
        this.placeRadio = new JRadioButton(TAG_ADDR_PLACE);
        this.placeRadio.setToolTipText(TAG_STREET_OR_PLACE);
        this.placeRadio.setSelected(!dto.isTagStreet());
        this.placeRadio.addItemListener(new RadioChangeListener());
        editPanel.add((Component)this.placeRadio, GBC.std().insets(5, 5, 0, 5));
        ButtonGroup g = new ButtonGroup();
        g.add(this.streetRadio);
        g.add(this.placeRadio);
        this.street = dto.isTagStreet() ? TagDialog.generateAutoCompTextField(TagDialog.getPossibleStreets(), dto.getStreet()) : TagDialog.generateAutoCompTextField((Collection<AutoCompletionItem>)this.acm.getTagValues(TAG_ADDR_PLACE), dto.getStreet());
        editPanel.add((Component)this.street, columnTwo);
        editPanel.add((Component)TagDialog.generateAcceptButton(actionEvent -> this.updateStreetOrPlaceValues()), columnThree);
        JosmTextField streetOrPlace = TagDialog.generateTextField(this.getStreetOrPlaceTag());
        streetOrPlace.setPreferredSize(new Dimension(50, 24));
        editPanel.add((Component)streetOrPlace, GBC.std().weight(0.0, 0.0).fill(2).insets(5, 5, 0, 5));
        JosmTextField existingStreet = TagDialog.generateTextField(this.getStreetOrPlaceValue());
        existingStreet.setPreferredSize(new Dimension(100, 24));
        editPanel.add((Component)existingStreet, GBC.eol().weight(1.0, 0.0).insets(5, 5, 0, 5).fill(2));
        this.housenumberEnabled = TagDialog.generateCheckbox(TAG_ADDR_HOUSENUMBER, dto.isSaveHousenumber());
        editPanel.add((Component)this.housenumberEnabled, columnOne);
        this.housenumber = TagDialog.generateTextField(HouseNumberHelper.incrementHouseNumber(dto.getHousenumber(), dto.getHousenumberChangeValue()));
        this.housenumber.setEditable(true);
        editPanel.add((Component)this.housenumber, columnTwo);
        editPanel.add((Component)TagDialog.generateAcceptButton(actionEvent -> this.housenumber.setText(this.selection.get(TAG_ADDR_HOUSENUMBER))), columnThree);
        editPanel.add((Component)TagDialog.generateTextField(this.selection.get(TAG_ADDR_HOUSENUMBER)), columnFour);
        JLabel seqLabel = new JLabel(I18n.tr((String)"House number increment:", (Object[])new Object[0]));
        editPanel.add((Component)seqLabel, columnOne);
        this.housenumberChangeSequence = new JSlider(0, -10, 10, dto.getHousenumberChangeValue());
        this.housenumberChangeSequence.setPaintTicks(true);
        this.housenumberChangeSequence.setMajorTickSpacing(1);
        this.housenumberChangeSequence.setMinorTickSpacing(1);
        this.housenumberChangeSequence.setPaintLabels(true);
        this.housenumberChangeSequence.setSnapToTicks(true);
        editPanel.add((Component)this.housenumberChangeSequence, GBC.eol().weight(1.0, 0.0).insets(20, 5, 10, 5).fill(2));
        return editPanel;
    }

    private static JCheckBox generateCheckbox(String text, boolean enabled) {
        JCheckBox checkBox = new JCheckBox(text, enabled);
        checkBox.setFocusable(false);
        checkBox.setToolTipText(APPLY_CHANGES);
        return checkBox;
    }

    private static JButton generateAcceptButton(ActionListener listener) {
        JButton button = new JButton("<");
        button.setPreferredSize(new Dimension(45, 24));
        button.setToolTipText(I18n.tr((String)"Accept existing value", (Object[])new Object[0]));
        button.addActionListener(listener);
        return button;
    }

    private static AutoCompComboBox<AutoCompletionItem> generateAutoCompTextField(Collection<AutoCompletionItem> tagValues, String selected) {
        AutoCompComboBox comboBox = new AutoCompComboBox();
        comboBox.getModel().addAllElements(tagValues);
        comboBox.setPreferredSize(new Dimension(200, 24));
        comboBox.setEditable(true);
        comboBox.setSelectedItem((Object)selected);
        return comboBox;
    }

    private static JosmTextField generateTextField(String startingText) {
        JosmTextField textField = new JosmTextField();
        textField.setText(startingText);
        textField.setPreferredSize(new Dimension(200, 24));
        textField.setEditable(false);
        return textField;
    }

    private void acceptAllExistingValues() {
        this.updateStreetOrPlaceValues();
        this.building.setSelectedItem(this.selection.get(TAG_BUILDING));
        this.source.setSelectedItem((Object)this.selection.get(TAG_SOURCE));
        this.country.setSelectedItem((Object)this.selection.get(TAG_ADDR_COUNTRY));
        this.stateTag.setSelectedItem((Object)this.selection.get(TAG_ADDR_STATE));
        this.suburb.setSelectedItem((Object)this.selection.get(TAG_ADDR_SUBURB));
        this.city.setSelectedItem((Object)this.selection.get(TAG_ADDR_CITY));
        this.postcode.setSelectedItem((Object)this.selection.get(TAG_ADDR_POSTCODE));
        this.housenumber.setText(this.selection.get(TAG_ADDR_HOUSENUMBER));
    }

    private void updateStreetOrPlaceValues() {
        if (this.selection.hasTag(TAG_ADDR_PLACE)) {
            this.placeRadio.setSelected(true);
            this.street.setSelectedItem((Object)this.selection.get(TAG_ADDR_PLACE));
        } else {
            this.streetRadio.setSelected(true);
            this.street.setSelectedItem((Object)this.selection.get(TAG_ADDR_STREET));
        }
    }

    private String getStreetOrPlaceValue() {
        if (this.selection.hasTag(TAG_ADDR_PLACE)) {
            return this.selection.get(TAG_ADDR_PLACE);
        }
        if (this.selection.hasTag(TAG_ADDR_STREET)) {
            return this.selection.get(TAG_ADDR_STREET);
        }
        return "";
    }

    private String getStreetOrPlaceTag() {
        if (this.selection.hasTag(TAG_ADDR_PLACE)) {
            return TAG_ADDR_PLACE;
        }
        if (this.selection.hasTag(TAG_ADDR_STREET)) {
            return TAG_ADDR_STREET;
        }
        return "";
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        if (buttonIndex == 0) {
            Dto dto = new Dto();
            dto.setSaveBuilding(this.buildingEnabled.isSelected());
            dto.setSaveSource(this.sourceEnabled.isSelected());
            dto.setSaveCity(this.cityEnabled.isSelected());
            dto.setSaveCountry(this.countryEnabled.isSelected());
            dto.setSaveState(this.stateEnabled.isSelected());
            dto.setSaveHousenumber(this.housenumberEnabled.isSelected());
            dto.setSavePostcode(this.zipEnabled.isSelected());
            dto.setSaveStreet(this.streetEnabled.isSelected());
            dto.setTagStreet(this.streetRadio.isSelected());
            dto.setSaveSuburb(this.suburbEnabled.isSelected());
            dto.setBuilding((String)this.building.getSelectedItem());
            dto.setSource(TagDialog.getAutoCompletingComboBoxValue(this.source));
            dto.setCity(TagDialog.getAutoCompletingComboBoxValue(this.city));
            dto.setCountry(TagDialog.getAutoCompletingComboBoxValue(this.country));
            dto.setHousenumber(this.housenumber.getText());
            dto.setPostcode(TagDialog.getAutoCompletingComboBoxValue(this.postcode));
            dto.setStreet(TagDialog.getAutoCompletingComboBoxValue(this.street));
            dto.setState(TagDialog.getAutoCompletingComboBoxValue(this.stateTag));
            dto.setSuburb(TagDialog.getAutoCompletingComboBoxValue(this.suburb));
            dto.setHousenumberChangeValue(this.housenumberChangeSequence.getValue());
            this.updateJOSMSelection(this.selection, dto);
            this.saveDto(dto);
        }
        this.setVisible(false);
    }

    private static String getAutoCompletingComboBoxValue(AutoCompComboBox<AutoCompletionItem> box) {
        Object item = box.getSelectedItem();
        if (item != null) {
            if (item instanceof String) {
                return (String)item;
            }
            if (item instanceof AutoCompletionItem) {
                return ((AutoCompletionItem)item).getValue();
            }
            return item.toString();
        }
        return "";
    }

    protected void saveDto(Dto dto) {
        block12: {
            File fileName = new File(this.pluginDir + TEMPLATE_DATA);
            try {
                if (!this.pluginDir.isDirectory() && !this.pluginDir.mkdirs()) break block12;
                try (FileOutputStream file = new FileOutputStream(fileName);
                     ObjectOutputStream o = new ObjectOutputStream(file);){
                    o.writeObject(dto);
                }
            }
            catch (IOException ex) {
                Logging.error((Throwable)ex);
                if (fileName.delete()) break block12;
                Logging.trace((String)"TagDialog: {0} not deleted", (Object[])new Object[]{fileName});
            }
        }
    }

    protected void updateJOSMSelection(OsmPrimitive selection, Dto dto) {
        ChangePropertyCommand command;
        String value;
        ArrayList<ChangePropertyCommand> commands = new ArrayList<ChangePropertyCommand>();
        if (dto.isSaveBuilding() && ((value = selection.get(TAG_BUILDING)) == null || !value.equals(dto.getBuilding()))) {
            command = new ChangePropertyCommand(selection, TAG_BUILDING, dto.getBuilding());
            commands.add(command);
        }
        if (dto.isSaveSource() && ((value = selection.get(TAG_SOURCE)) == null || !value.equals(dto.getSource()))) {
            command = new ChangePropertyCommand(selection, TAG_SOURCE, dto.getSource());
            commands.add(command);
        }
        if (dto.isSaveCity() && ((value = selection.get(TAG_ADDR_CITY)) == null || !value.equals(dto.getCity()))) {
            command = new ChangePropertyCommand(selection, TAG_ADDR_CITY, dto.getCity());
            commands.add(command);
        }
        if (dto.isSaveCountry() && ((value = selection.get(TAG_ADDR_COUNTRY)) == null || !value.equals(dto.getCountry()))) {
            command = new ChangePropertyCommand(selection, TAG_ADDR_COUNTRY, dto.getCountry());
            commands.add(command);
        }
        if (dto.isSaveSuburb() && ((value = selection.get(TAG_ADDR_SUBURB)) == null || !value.equals(dto.getSuburb()))) {
            command = new ChangePropertyCommand(selection, TAG_ADDR_SUBURB, dto.getSuburb());
            commands.add(command);
        }
        if (dto.isSaveHousenumber() && ((value = selection.get(TAG_ADDR_HOUSENUMBER)) == null || !value.equals(dto.getHousenumber()))) {
            command = new ChangePropertyCommand(selection, TAG_ADDR_HOUSENUMBER, dto.getHousenumber());
            commands.add(command);
        }
        if (dto.isSavePostcode() && ((value = selection.get(TAG_ADDR_POSTCODE)) == null || !value.equals(dto.getPostcode()))) {
            command = new ChangePropertyCommand(selection, TAG_ADDR_POSTCODE, dto.getPostcode());
            commands.add(command);
        }
        if (dto.isSaveStreet()) {
            if (dto.isTagStreet()) {
                value = selection.get(TAG_ADDR_STREET);
                if (value == null || !value.equals(dto.getStreet())) {
                    command = new ChangePropertyCommand(selection, TAG_ADDR_STREET, dto.getStreet());
                    commands.add(command);
                    if (selection.get(TAG_ADDR_PLACE) != null) {
                        ChangePropertyCommand command2 = new ChangePropertyCommand(selection, TAG_ADDR_PLACE, null);
                        commands.add(command2);
                    }
                }
            } else {
                value = selection.get(TAG_ADDR_PLACE);
                if (value == null || !value.equals(dto.getStreet())) {
                    command = new ChangePropertyCommand(selection, TAG_ADDR_PLACE, dto.getStreet());
                    commands.add(command);
                    if (selection.get(TAG_ADDR_STREET) != null) {
                        ChangePropertyCommand command2 = new ChangePropertyCommand(selection, TAG_ADDR_STREET, null);
                        commands.add(command2);
                    }
                }
            }
        }
        if (dto.isSaveState() && ((value = selection.get(TAG_ADDR_STATE)) == null || !value.equals(dto.getState()))) {
            command = new ChangePropertyCommand(selection, TAG_ADDR_STATE, dto.getState());
            commands.add(command);
        }
        if (!commands.isEmpty()) {
            SequenceCommand sequenceCommand = new SequenceCommand(I18n.trn((String)"Updating properties of up to {0} object", (String)"Updating properties of up to {0} objects", (long)commands.size(), (Object[])new Object[]{commands.size()}), commands);
            UndoRedoHandler.getInstance().add((Command)sequenceCommand);
        }
    }

    private static Collection<AutoCompletionItem> getPossibleStreets() {
        TreeSet<AutoCompletionItem> names = new TreeSet<AutoCompletionItem>();
        for (OsmPrimitive osm : MainApplication.getLayerManager().getEditDataSet().allNonDeletedPrimitives()) {
            if (osm.getKeys() == null || !osm.keySet().contains("highway") || !osm.keySet().contains("name")) continue;
            names.add(new AutoCompletionItem(osm.get("name")));
        }
        return names;
    }

    private Dto loadDto() {
        Dto dto;
        block14: {
            dto = new Dto();
            File fileName = new File(this.pluginDir + TEMPLATE_DATA);
            try {
                if (fileName.exists()) {
                    try (FileInputStream file = new FileInputStream(fileName);
                         ObjectInputStream o = new ObjectInputStream(file);){
                        dto = (Dto)o.readObject();
                        break block14;
                    }
                }
                this.loadExistingValuesToDto(dto);
            }
            catch (IOException | ClassNotFoundException ex) {
                Logging.error((Throwable)ex);
                if (!fileName.delete()) {
                    Logging.trace((String)"TagDialog: {0} not deleted", (Object[])new Object[]{fileName});
                }
                this.loadExistingValuesToDto(dto);
            }
        }
        dto.setHousenumberChangeValue(Utils.clamp((int)dto.getHousenumberChangeValue(), (int)-10, (int)10));
        return dto;
    }

    private void loadExistingValuesToDto(Dto dto) {
        dto.setCity(this.selection.get(TAG_ADDR_CITY));
        dto.setCountry(this.selection.get(TAG_ADDR_COUNTRY));
        dto.setSource(this.selection.get(TAG_SOURCE));
        dto.setHousenumber(this.selection.get(TAG_ADDR_HOUSENUMBER));
        dto.setPostcode(this.selection.get(TAG_ADDR_POSTCODE));
        dto.setStreet(this.selection.get(TAG_ADDR_STREET));
        dto.setState(this.selection.get(TAG_ADDR_STATE));
        dto.setSuburb(this.selection.get(TAG_ADDR_SUBURB));
    }

    class RadioChangeListener
    implements ItemListener {
        RadioChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (TagDialog.this.streetRadio.isSelected()) {
                TagDialog.this.street.getModel().addAllElements(TagDialog.getPossibleStreets());
            } else {
                TagDialog.this.street.getModel().addAllElements((Collection)TagDialog.this.acm.getTagValues(TagDialog.TAG_ADDR_PLACE));
            }
        }
    }
}

