/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.actions.downloadtasks;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.pmtiles.data.imagery.PMTilesImageryInfo;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesImageLayer;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesMVTLayer;
import org.openstreetmap.josm.plugins.pmtiles.lib.Header;
import org.openstreetmap.josm.plugins.pmtiles.lib.PMTiles;
import org.openstreetmap.josm.plugins.pmtiles.lib.TileType;
import org.openstreetmap.josm.tools.I18n;

public class DownloadPMTilesTask
implements DownloadTask {
    private boolean zoomAfterDownload;
    private boolean cancel;
    private String url;
    private final List<Object> errorObjects = new ArrayList<Object>();
    private Bounds bounds;

    private void addLayer() {
        if (this.cancel) {
            return;
        }
        try {
            Header header = PMTiles.readHeader(URI.create(this.url));
            PMTilesImageryInfo info = new PMTilesImageryInfo(header);
            if (header.tileType() == TileType.MVT) {
                MainApplication.getLayerManager().addLayer((Layer)new PMTilesMVTLayer(info));
            } else {
                MainApplication.getLayerManager().addLayer((Layer)new PMTilesImageLayer(info));
            }
        }
        catch (IOException e) {
            this.errorObjects.add(e);
        }
        if (this.zoomAfterDownload && this.bounds != null && MainApplication.getMap() != null && MainApplication.getMap().mapView != null) {
            MainApplication.getMap().mapView.zoomTo(this.bounds);
        }
    }

    public Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        this.bounds = downloadArea;
        return MainApplication.worker.submit(this::addLayer);
    }

    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        this.url = Objects.requireNonNull(url);
        return this.download(settings, null, progressMonitor);
    }

    public boolean acceptsUrl(String url, boolean isRemotecontrol) {
        return url.endsWith(".pmtiles");
    }

    public String getTitle() {
        return I18n.tr((String)"Add PMTiles layer", (Object[])new Object[0]);
    }

    public String[] getPatterns() {
        return new String[]{".*.pmtiles"};
    }

    public List<Object> getErrorObjects() {
        return Collections.unmodifiableList(this.errorObjects);
    }

    public void cancel() {
        this.cancel = true;
    }

    public String getConfirmationMessage(URL url) {
        return I18n.tr((String)"Do you want to add a layer based off of {0}?", (Object[])new Object[]{url.toExternalForm()});
    }

    public void setZoomAfterDownload(boolean zoomAfterDownload) {
        this.zoomAfterDownload = zoomAfterDownload;
    }
}

