/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.lib.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.openstreetmap.josm.plugins.pmtiles.lib.Header;
import org.openstreetmap.josm.plugins.pmtiles.lib.InternalCompression;
import org.openstreetmap.josm.plugins.pmtiles.lib.TileType;
import org.openstreetmap.josm.plugins.pmtiles.lib.internal.Util;

public final class HeaderParser {
    private static final String MAGIC_HEADER = "PMTiles";

    private HeaderParser() {
    }

    public static Header parse(URI location, InputStream inputStream) throws IOException {
        for (int i = 0; i < MAGIC_HEADER.length(); ++i) {
            if (inputStream.read() == MAGIC_HEADER.charAt(i)) continue;
            throw new IOException("Malformed PMTiles");
        }
        if (inputStream.read() != 3) {
            throw new IOException("Malformed PMTiles");
        }
        return new Header(location, HeaderParser.nextInt(inputStream), HeaderParser.nextInt(inputStream), HeaderParser.nextInt(inputStream), HeaderParser.nextInt(inputStream), HeaderParser.nextInt(inputStream), HeaderParser.nextInt(inputStream), HeaderParser.nextInt(inputStream), HeaderParser.nextInt(inputStream), HeaderParser.nextInt(inputStream), HeaderParser.nextInt(inputStream), HeaderParser.nextInt(inputStream), 1 == inputStream.read(), HeaderParser.nextCompressionType(inputStream), HeaderParser.nextCompressionType(inputStream), HeaderParser.nextTileType(inputStream), inputStream.read(), inputStream.read(), HeaderParser.nextDegrees(inputStream), HeaderParser.nextDegrees(inputStream), HeaderParser.nextDegrees(inputStream), HeaderParser.nextDegrees(inputStream), inputStream.read(), HeaderParser.nextDegrees(inputStream), HeaderParser.nextDegrees(inputStream));
    }

    private static double nextDegrees(InputStream inputStream) throws IOException {
        return (double)Util.nextInt(inputStream, 4) / 1.0E7;
    }

    private static long nextInt(InputStream inputStream) throws IOException {
        return Util.nextInt(inputStream, 8);
    }

    private static InternalCompression nextCompressionType(InputStream inputStream) throws IOException {
        int type = inputStream.read();
        return switch (type) {
            case 0 -> InternalCompression.UNKNOWN;
            case 1 -> InternalCompression.NONE;
            case 2 -> InternalCompression.GZIP;
            case 3 -> InternalCompression.BROTLI;
            case 4 -> InternalCompression.ZSTD;
            default -> throw new IllegalStateException("Unexpected value: " + type);
        };
    }

    private static TileType nextTileType(InputStream inputStream) throws IOException {
        int type = inputStream.read();
        return switch (type) {
            case 0 -> TileType.UNKNOWN;
            case 1 -> TileType.MVT;
            case 2 -> TileType.PNG;
            case 3 -> TileType.JPEG;
            case 4 -> TileType.WEBP;
            case 5 -> TileType.AVIF;
            default -> throw new IllegalStateException("Unexpected value: " + type);
        };
    }
}

