/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.lib;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.InflaterInputStream;
import org.apache.commons.compress.compressors.brotli.BrotliCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.openstreetmap.josm.plugins.pmtiles.lib.Directory;
import org.openstreetmap.josm.plugins.pmtiles.lib.DirectoryCache;
import org.openstreetmap.josm.plugins.pmtiles.lib.DirectoryEntry;
import org.openstreetmap.josm.plugins.pmtiles.lib.Header;
import org.openstreetmap.josm.plugins.pmtiles.lib.InternalCompression;
import org.openstreetmap.josm.plugins.pmtiles.lib.TileXYZ;
import org.openstreetmap.josm.plugins.pmtiles.lib.internal.DirectoryParser;
import org.openstreetmap.josm.plugins.pmtiles.lib.internal.HeaderParser;
import org.openstreetmap.josm.tools.Utils;

public final class PMTiles {
    private static final byte[] EMPTY_BYTE = new byte[0];

    private PMTiles() {
    }

    public static Header readHeader(URI location) throws IOException {
        try (InputStream inputStream = PMTiles.getInputStream(location, 0L, 127L);){
            Header header = HeaderParser.parse(location, inputStream);
            return header;
        }
    }

    public static JsonObject readMetadata(Header header) throws IOException {
        try (InputStream inputStream = PMTiles.decompressInputStream(header.internalCompression(), PMTiles.getInputStream(header.location(), header.metadataOffset(), header.metadataLength()));){
            JsonObject jsonObject;
            block12: {
                JsonReader reader = Json.createReader((InputStream)inputStream);
                try {
                    jsonObject = reader.readObject();
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return jsonObject;
        }
    }

    public static Directory readRootDirectory(Header header) throws IOException {
        try (InputStream inputStream = PMTiles.decompressInputStream(header.internalCompression(), PMTiles.getInputStream(header.location(), header.rootOffset(), header.rootLength()));){
            Directory directory = DirectoryParser.parse(inputStream);
            return directory;
        }
    }

    public static Directory readLeafDirectory(Header header, long offset, long length) throws IOException {
        try (InputStream inputStream = PMTiles.decompressInputStream(header.internalCompression(), PMTiles.getInputStream(header.location(), header.leafOffset() + offset, length));){
            Directory directory = DirectoryParser.parse(inputStream);
            return directory;
        }
    }

    public static byte[] readData(Header header, long index, DirectoryCache cachedDirectories) throws IOException {
        DirectoryEntry entry = PMTiles.getDataLocation(header, index, cachedDirectories);
        if (entry == null) {
            return EMPTY_BYTE;
        }
        try (InputStream inputStream = PMTiles.decompressInputStream(header.tileCompression(), PMTiles.getInputStream(header.location(), header.tileOffset() + entry.offset(), entry.length()));){
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
    }

    public static DirectoryEntry getDataLocation(Header header, long index, DirectoryCache cachedDirectories) throws IOException {
        DirectoryEntry leaf = null;
        for (Directory directory : cachedDirectories) {
            DirectoryEntry entry = PMTiles.getDataEntry(index, directory);
            if (entry != null && entry.isLeafDirectory()) {
                leaf = entry;
                continue;
            }
            if (entry == null) continue;
            return entry;
        }
        while (leaf != null) {
            Directory leafDirectory = PMTiles.readLeafDirectory(header, leaf.offset(), leaf.length());
            cachedDirectories.addDirectory(leafDirectory);
            leaf = PMTiles.getDataEntry(index, leafDirectory);
            if (leaf == null || !leaf.contains(index) || leaf.isLeafDirectory()) continue;
            return leaf;
        }
        return null;
    }

    private static DirectoryEntry getDataEntry(long index, Directory directory) {
        DirectoryEntry entry = null;
        for (DirectoryEntry current : directory) {
            if (current.contains(index)) {
                return current;
            }
            if (current.tileId() >= index || !current.isLeafDirectory() || entry != null && current.tileId() <= entry.tileId()) continue;
            entry = current;
        }
        return entry;
    }

    public static long convertToHilbert(TileXYZ tile) {
        return PMTiles.convertToHilbert(tile.z(), tile.x(), tile.y());
    }

    public static long convertToHilbert(int z, int x, int y) {
        double maxSquare = Math.pow(4.0, z);
        if ((double)x >= maxSquare || (double)y >= maxSquare) {
            throw new IllegalArgumentException("x or y out of bounds: " + z + " (x = " + x + ", y = " + y);
        }
        int start = 0;
        int currentZoom = z;
        while (currentZoom > 0) {
            start += (1 << --currentZoom) * (1 << currentZoom);
        }
        long d = 0L;
        int n = 1 << z;
        int[] xy = new int[]{x, y};
        for (int s = n / 2; s > 0; s /= 2) {
            int rx = (xy[0] & s) > 0 ? 1 : 0;
            int ry = (xy[1] & s) > 0 ? 1 : 0;
            d += (long)(s * s * (3 * rx ^ ry));
            PMTiles.rotate(n, xy, rx, ry);
        }
        return (long)start + d;
    }

    public static TileXYZ convertToXYZ(long hilbert) {
        double zTiles;
        int z = 0;
        int start = 0;
        while (!((double)start + (zTiles = Math.pow(4.0, z)) > (double)hilbert)) {
            start = (int)((double)start + zTiles);
            ++z;
        }
        long t = hilbert - (long)start;
        int[] xy = new int[]{0, 0};
        int n = 1 << z;
        for (int s = 1; s < n; s *= 2) {
            int rx = (int)(1L & t / 2L);
            int ry = (int)(1L & (t ^ (long)rx));
            PMTiles.rotate(s, xy, rx, ry);
            xy[0] = xy[0] + s * rx;
            xy[1] = xy[1] + s * ry;
            t /= 4L;
        }
        return new TileXYZ(z, xy[0], xy[1]);
    }

    private static void rotate(int n, int[] xy, int rx, int ry) {
        if (ry == 0) {
            if (rx == 1) {
                xy[0] = n - 1 - xy[0];
                xy[1] = n - 1 - xy[1];
            }
            int temp = xy[0];
            xy[0] = xy[1];
            xy[1] = temp;
        }
    }

    private static InputStream decompressInputStream(InternalCompression compression, InputStream inputStream) throws IOException {
        return switch (compression) {
            default -> throw new IncompatibleClassChangeError();
            case InternalCompression.GZIP -> new GzipCompressorInputStream(inputStream);
            case InternalCompression.ZSTD -> new InflaterInputStream(inputStream);
            case InternalCompression.BROTLI -> new BrotliCompressorInputStream(inputStream);
            case InternalCompression.NONE -> inputStream;
            case InternalCompression.UNKNOWN -> throw new UnsupportedOperationException("Unknown compression type");
        };
    }

    private static InputStream getInputStream(URI location, long start, long length) throws IOException {
        if (Utils.isLocalUrl((String)location.toString())) {
            Path file = Path.of(location);
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                if (start != is.skip(start)) {
                    throw new IOException("Something is wrong with the file");
                }
                if (length < Integer.MAX_VALUE) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(is.readNBytes((int)length));
                    return byteArrayInputStream;
                }
                throw new IOException("The PMTiles plugin currently does not support large streams from the file system");
            }
        }
        HttpRequest request = HttpRequest.newBuilder(location).header("Range", "bytes=" + start + "-" + (start + length - 1L)).header("User-Agent", "JOSM PMTiles v1").GET().build();
        try {
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
            HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() < 200 || response.statusCode() > 300) {
                throw new IOException("Bad response code for " + response.request().uri() + ": " + response.statusCode());
            }
            return response.body();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IOException(interruptedException);
        }
    }
}

