/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.gui.layers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.plugins.pmtiles.data.imagery.PMTilesImageryInfo;
import org.openstreetmap.josm.tools.TextUtils;
import org.openstreetmap.josm.tools.Utils;

interface PMTilesLayer
extends MapViewPaintable {
    public PMTilesImageryInfo getInfo();

    default public String getChangesetSourceTag() {
        StringBuilder sb = new StringBuilder();
        PMTilesImageryInfo info = this.getInfo();
        if (info.hasAttribution()) {
            sb.append(this.getInfo().getAttributionText(0, null, null).replaceAll("<a [^>]*>|</a>", "").replaceAll("  +", " "));
        }
        if (info.getName() != null) {
            if (!sb.isEmpty()) {
                sb.append(" - ");
            }
            sb.append(info.getName());
        }
        if (sb.isEmpty()) {
            String location = info.header().location().toString();
            if (Utils.isLocalUrl((String)location)) {
                String userName = Utils.getSystemProperty((String)"user.name");
                String userNameAlt = "<user.name>";
                sb.append(location.replace(userName, "<user.name>"));
            } else {
                sb.append(TextUtils.stripUrl((String)location));
            }
        }
        return sb.toString();
    }

    default public String[][] getInfoContent() {
        PMTilesImageryInfo info = this.getInfo();
        String[][] content = new String[][]{{"Maximum zoom", String.valueOf(info.getMaxZoom())}, {"Minimum zoom", String.valueOf(info.getMinZoom())}, {"Bounds", info.getBounds().toBBox().toStringCSV(",")}};
        return content;
    }

    default public void paint(Graphics2D g, MapView mv, Bounds box) {
        PMTilesImageryInfo info = this.getInfo();
        g.setStroke(new BasicStroke());
        g.setColor(Color.DARK_GRAY);
        if (info.getBounds().getShapes().isEmpty()) {
            Point lowerLeft = mv.getPoint(info.getBounds().getMin());
            Point upperRight = mv.getPoint(info.getBounds().getMax());
            g.drawRect(lowerLeft.x, upperRight.y, upperRight.x - lowerLeft.x, lowerLeft.y - upperRight.y);
        } else {
            for (Shape shape : info.getBounds().getShapes()) {
                Point last = null;
                for (ICoordinate coord : shape.getPoints()) {
                    Point point = mv.getPoint(new LatLon(coord.getLat(), coord.getLon()));
                    if (last != null) {
                        g.drawLine(last.x, last.y, point.x, point.y);
                    }
                    last = point;
                }
            }
        }
    }

    default public void visitBoundingBox(BoundingXYVisitor v) {
        v.visit((Bounds)this.getInfo().getBounds());
    }
}

