/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.gui.layers;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.jcs3.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.imagery.TileJobOptions;
import org.openstreetmap.josm.plugins.pmtiles.data.imagery.PMTilesImageryInfo;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTileJob;
import org.openstreetmap.josm.plugins.pmtiles.lib.DirectoryCache;
import org.openstreetmap.josm.plugins.pmtiles.lib.Header;
import org.openstreetmap.josm.plugins.pmtiles.lib.PMTiles;

public class PMTilesLoader
implements TileLoader {
    private static final ThreadPoolExecutor EXECUTOR = TMSCachedTileLoader.getNewThreadPoolExecutor((String)"pmtiles");
    private final Collection<PMTileJob> jobs = new HashSet<PMTileJob>();
    private final ICacheAccess<String, CacheEntry> cache;
    private final TileJobOptions options;
    private Header header;
    private DirectoryCache directoryCache;

    public PMTilesLoader(TileLoaderListener ignored, ICacheAccess<String, CacheEntry> cache, TileJobOptions options) {
        this.cache = cache;
        this.options = options;
    }

    public TileJob createTileLoaderJob(Tile tile) {
        PMTileJob job = new PMTileJob(this.cache, this.options, EXECUTOR, this.header, tile, this.directoryCache);
        this.jobs.add(job);
        return job;
    }

    public void cancelOutstandingTasks() {
        this.jobs.forEach(JCSCachedTileLoaderJob::handleJobCancellation);
        this.jobs.clear();
    }

    public boolean hasOutstandingTasks() {
        return this.jobs.isEmpty();
    }

    void setInfo(PMTilesImageryInfo info) {
        this.header = info.header();
        try {
            this.directoryCache = new DirectoryCache(PMTiles.readRootDirectory(this.header));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

