/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class DownloadParentsAction
extends AbstractAction
implements ChosenRelationListener {
    private final ChosenRelation rel;

    public DownloadParentsAction(ChosenRelation rel) {
        super(I18n.tr((String)"Download referrers", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"download"));
        this.putValue("ShortDescription", I18n.tr((String)"Download referrers for the chosen relation and its members.", (Object[])new Object[0]));
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(rel.get() != null && MainApplication.getLayerManager().getEditLayer() != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation relation = this.rel.get();
        if (relation == null) {
            return;
        }
        ArrayList<Relation> objects = new ArrayList<Relation>();
        objects.add(relation);
        objects.addAll(relation.getMemberPrimitives());
        MainApplication.worker.submit((Runnable)new DownloadReferrersTask(MainApplication.getLayerManager().getEditLayer(), objects));
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(newRelation != null && MainApplication.getLayerManager().getEditLayer() != null);
    }

    protected void downloadMembers(Relation rel) {
        if (!rel.isNew()) {
            MainApplication.worker.submit((Runnable)new DownloadRelationTask(Collections.singletonList(rel), MainApplication.getLayerManager().getEditLayer()));
        }
    }

    protected void downloadIncomplete(Relation rel) {
        if (rel.isNew()) {
            return;
        }
        HashSet ret = new HashSet(rel.getIncompleteMembers());
        if (ret.isEmpty()) {
            return;
        }
        MainApplication.worker.submit((Runnable)new DownloadRelationMemberTask(Collections.singletonList(rel), ret, MainApplication.getLayerManager().getEditLayer()));
    }
}

