/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchShpHandler;

public class ParisShpHandler
extends FrenchShpHandler {
    public final Map<String, Node> nodeMap = new HashMap<String, Node>();
    protected OsmPrimitive dataPrimitive;
    protected Way closedWay;
    protected List<Way> ways;
    public List<Node> nodes;

    public ParisShpHandler() {
        this.setDbfCharset(Charset.forName("Cp850"));
    }

    private Node getNode(EastNorth en, String key) {
        Node n = this.nodeMap.get(key);
        return n;
    }

    protected Node createOrGetNode(DataSet ds, EastNorth en) {
        String key = en.getX() + "/" + en.getY();
        Node n = this.getNode(en, key);
        if (n == null) {
            n = new Node(en);
            this.nodeMap.put(key, n);
            ds.addPrimitive((OsmPrimitive)n);
        }
        return n;
    }

    protected final void initFeaturesPrimitives(Set<OsmPrimitive> featurePrimitives) {
        this.dataPrimitive = null;
        this.closedWay = null;
        this.ways = new ArrayList<Way>();
        this.nodes = new ArrayList<Node>();
        for (OsmPrimitive p : featurePrimitives) {
            if (p.hasKeys()) {
                this.dataPrimitive = p;
            }
            if (p instanceof Way) {
                Way w = (Way)p;
                this.ways.add(w);
                if (!w.isClosed()) continue;
                this.closedWay = w;
                continue;
            }
            if (!(p instanceof Node)) continue;
            this.nodes.add((Node)p);
        }
    }

    protected final void removePrimitives(DataSet result) {
        for (Way w : this.ways) {
            w.setNodes(null);
            result.removePrimitive((PrimitiveId)w);
        }
        for (Node n : this.nodes) {
            result.removePrimitive((PrimitiveId)n);
        }
    }
}

