/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.urbanisme;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class SanisetteHandler
extends ToulouseDataSetHandler {
    public SanisetteHandler() {
        super("sanisettes", "amenity=toilets");
        this.setWikiPage("Sanisettes");
        this.setCategory(CAT_URBANISME);
    }

    public boolean acceptsFilename(String filename) {
        return SanisetteHandler.acceptsCsvKmzTabFilename((String)filename, (String[])new String[]{"Sanisette"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.remove("name");
            n.put("amenity", "toilets");
            n.put("supervised", "no");
            n.put("unisex", "yes");
            n.put("fee", "no");
            n.put("operator", "JCDecaux");
            n.put("opening_hours", "24/7");
            SanisetteHandler.replace((IPrimitive)n, (String)"numero", (String)"ref:FR:ToulouseMetropole");
            SanisetteHandler.replace((IPrimitive)n, (String)"PMR", (String)"wheelchair", (String[])new String[]{"true", "false"}, (String[])new String[]{"yes", "no"});
            String valide = n.get("emplacement_valide");
            if (valide != null && valide.equalsIgnoreCase("non")) {
                n.put("fixme", "L'emplacement semble invalide !");
            } else {
                n.remove("emplacement_valide");
            }
            n.remove("adresse");
            n.remove("INSEE");
            n.remove("color");
        }
    }
}

