/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.urbanisme;

import java.util.HashMap;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.plugins.opendata.core.util.NamesFrUtils;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class NumerosRueHandler
extends ToulouseDataSetHandler {
    public NumerosRueHandler() {
        super("numero-de-rue", "addr:housenumber");
        this.setWikiPage("Num\u00e9ros de rue");
        this.setCategory(CAT_URBANISME);
    }

    public boolean acceptsFilename(String filename) {
        return NumerosRueHandler.acceptsCsvKmzTabFilename((String)filename, (String[])new String[]{"Numeros"});
    }

    public void updateDataSet(DataSet ds) {
        HashMap<String, Relation> associatedStreets = new HashMap<String, Relation>();
        for (Node n : ds.getNodes()) {
            NumerosRueHandler.replace((IPrimitive)n, (String)"no", (String)"addr:housenumber");
            n.remove("numero");
            NumerosRueHandler.replace((IPrimitive)n, (String)"lib_off", (String)"addr:street");
            n.remove("mot_directeur");
            n.remove("name");
            n.remove("rivoli");
            String fantoir = n.get("nrivoli").substring(6);
            n.remove("nrivoli");
            n.remove("color");
            String streetName = NamesFrUtils.checkStreetName((OsmPrimitive)n, (String)"addr:street");
            Relation street = (Relation)associatedStreets.get(n.get("sti"));
            if (street == null) {
                street = new Relation();
                associatedStreets.put(n.get("sti"), street);
                street.put("type", "associatedStreet");
                street.put("name", streetName);
                street.put("ref:FR:FANTOIR", fantoir);
                ds.addPrimitive((OsmPrimitive)street);
            }
            street.addMember(new RelationMember("house", (OsmPrimitive)n));
            n.remove("sti");
        }
    }
}

