/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.urbanisme;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class CommuneHandler
extends ToulouseDataSetHandler {
    public CommuneHandler() {
        super("communes", "admin_level=8");
        this.setName("Communes");
        this.setCategory(CAT_URBANISME);
        this.setMenuIcon("presets/misc/boundaries.svg");
    }

    public boolean acceptsFilename(String filename) {
        return CommuneHandler.acceptsKmzTabFilename((String)filename, (String[])new String[]{"Limites_Communes"});
    }

    public void updateDataSet(DataSet ds) {
        for (Relation r : ds.getRelations()) {
            r.put("type", "boundary");
            r.put("boundary", "administrative");
            r.put("admin_level", "8");
            CommuneHandler.replace((IPrimitive)r, (String)"libelle", (String)"name");
            CommuneHandler.replace((IPrimitive)r, (String)"code_insee", (String)"ref:INSEE");
        }
    }
}

