/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.transport;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.urbanisme.VoirieHandler;

public class Zone30Handler
extends VoirieHandler {
    public Zone30Handler() {
        super("zones-30", "Street", "maxspeed=30");
        this.setWikiPage("Zones 30");
        this.setCategory(CAT_TRANSPORT);
    }

    @Override
    public boolean acceptsFilename(String filename) {
        return Zone30Handler.acceptsKmzTabFilename((String)filename, (String[])new String[]{"Zone30"});
    }

    @Override
    public void updateDataSet(DataSet ds) {
        super.updateDataSet(ds);
        for (Way w : ds.getWays()) {
            w.put("zone:maxspeed", "FR:30");
            w.put("maxspeed", "30");
            Zone30Handler.replace((IPrimitive)w, (String)"SensUnique", (String)"oneway", (String[])new String[]{"oui", "non"}, (String[])new String[]{"yes", "no"});
            Zone30Handler.replace((IPrimitive)w, (String)"Annee", (String)"start_date");
            Zone30Handler.replace((IPrimitive)w, (String)"Longueur", (String)"length");
            w.remove("code_insee");
            w.remove("commune");
            w.remove("MotDir");
        }
    }

    @Override
    protected String getStreetId(Way w) {
        return w.get("code_insee") + "/" + w.get("name");
    }
}

