/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.transport;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchAdministrativeUnit;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.DataGouvDataSetHandler;
import org.openstreetmap.josm.tools.Pair;

public class Route500Handler
extends DataGouvDataSetHandler {
    private static final String OSMFR_PORTAL = "http://osm13.openstreetmap.fr/~cquest/route500/";
    private static final String ARCHIVE_PATTERN = "ROUTE500_1-1_SHP_LAMB93_D..._20..-..-..";
    private static final String SHP_PATTERN = "(EMPRISE|NOEUD_FERRE|TRONCON_VOIE_FERREE|ZONE_OCCUPATION_SOL|COTE_FRONTIERE|TRONCON_HYDROGRAPHIQUE|COMMUNE|LIMITE_ADMINISTRATIVE|COMMUNICATION_RESTREINTE|NOEUD_COMMUNE|NOEUD_ROUTIER|TRONCON_ROUTE|AERODROME)";

    public Route500Handler() {
        super("572583");
        this.setName("Route 500");
        try {
            this.setLocalPortalURL("http://professionnels.ign.fr/route500");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public boolean acceptsFilename(String filename) {
        return Route500Handler.accepts7ZipFilename((String)filename, (String[])new String[]{ARCHIVE_PATTERN}) || Route500Handler.acceptsShpFilename((String)filename, (String[])new String[]{SHP_PATTERN});
    }

    public void updateDataSet(DataSet ds) {
    }

    public List<Pair<String, URL>> getDataURLs() {
        ArrayList<Pair<String, URL>> result = new ArrayList<Pair<String, URL>>();
        try {
            for (FrenchAdministrativeUnit.FrenchDepartment dpt : FrenchAdministrativeUnit.allDepartments) {
                if (!dpt.getCode().startsWith("0")) continue;
                result.add(this.getRoute500URL(dpt.getCode(), dpt.getName()));
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Pair<String, URL> getRoute500URL(String code, String name) throws MalformedURLException {
        return new Pair((Object)name, (Object)new URL("http://osm13.openstreetmap.fr/~cquest/route500/ROUTE500_1-1_SHP_LAMB93_D" + code + "_2012-11-21.7z"));
    }
}

