/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.hydrologie;

import java.net.MalformedURLException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.DataGouvDataSetHandler;

public class ROEHandler
extends DataGouvDataSetHandler {
    public ROEHandler() {
        super("r\u00e9f\u00e9rentiel-des-obstacles-\u00e0-l'\u00e9coulement-30381987");
        this.setName("R\u00e9f\u00e9rentiel des Obstacles \u00e0 l\u2019\u00c9coulement");
        try {
            this.setDataURL("http://www.eaufrance.fr/docs/ROE/donnee_obstacles_ecoulement_v3.zip");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public boolean acceptsFilename(String filename) {
        return ROEHandler.acceptsMifTabFilename((String)filename, (String[])new String[]{"roe_version._20......_wlatin1"}) || ROEHandler.acceptsShpFilename((String)filename, (String[])new String[]{"roe_version._20......_system_L93"}) || ROEHandler.acceptsXlsFilename((String)filename, (String[])new String[]{"roe_version._20......_wlatin1"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            ROEHandler.replace((IPrimitive)n, (String)"Id_ROE", (String)"ref:FR:ROE");
            ROEHandler.replace((IPrimitive)n, (String)"Nom", (String)"name");
            n.remove("XL2e");
            n.remove("YL2e");
            n.remove("XL93");
            n.remove("YL93");
            ROEHandler.replace((IPrimitive)n, (String)"typeCd", (String)"waterway", (String[])new String[]{"1.1", "1.2", "1.6"}, (String[])new String[]{"dam", "weir", "lock_gate"});
            ROEHandler.replace((IPrimitive)n, (String)"typeCd", (String)"man_made", (String[])new String[]{"1.3", "1.5"}, (String[])new String[]{"dyke", "groyne"});
            ROEHandler.replace((IPrimitive)n, (String)"typeCd", (String)"bridge", (String[])new String[]{"1.4"}, (String[])new String[]{"yes"});
            n.remove("typeCd");
        }
    }
}

