/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.ecologie;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.DefaultSpreadSheetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetReader;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.DataGouvDataSetHandler;
import org.openstreetmap.josm.tools.Pair;

public class AssainissementHandler
extends DataGouvDataSetHandler {
    public AssainissementHandler() {
        super("assainissement-collectif-30381843");
        this.setName("Assainissement collectif");
        this.setSpreadSheetHandler((SpreadSheetHandler)new InternalOdsHandler());
    }

    public boolean acceptsFilename(String filename) {
        return AssainissementHandler.acceptsOdsFilename((String)filename, (String[])new String[]{"Export_ERU_20.."});
    }

    public void updateDataSet(DataSet ds) {
    }

    public List<Pair<String, URL>> getDataURLs() {
        ArrayList<Pair<String, URL>> result = new ArrayList<Pair<String, URL>>();
        try {
            result.add((Pair<String, URL>)new Pair((Object)"Donn\u00e9es 2009", (Object)new URL("http://www.assainissement.developpement-durable.gouv.fr/telecharger2.php")));
            result.add((Pair<String, URL>)new Pair((Object)"Donn\u00e9es 2010", (Object)new URL("http://www.assainissement.developpement-durable.gouv.fr/telecharger2_2010.php")));
            result.add((Pair<String, URL>)new Pair((Object)"Donn\u00e9es 2011", (Object)new URL("http://www.assainissement.developpement-durable.gouv.fr/telecharger2_2011.php")));
            result.add((Pair<String, URL>)new Pair((Object)"Donn\u00e9es 2012", (Object)new URL("http://www.assainissement.developpement-durable.gouv.fr/telecharger2_2012.php")));
            result.add((Pair<String, URL>)new Pair((Object)"Donn\u00e9es 2013", (Object)new URL("http://www.assainissement.developpement-durable.gouv.fr/telecharger2_2013.php")));
            result.add((Pair<String, URL>)new Pair((Object)"Donn\u00e9es 2014", (Object)new URL("http://www.assainissement.developpement-durable.gouv.fr/telecharger2_2014.php")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private final class InternalOdsHandler
    extends DefaultSpreadSheetHandler {
        private Node nodeWithKeys;
        private final Set<String> interestingKeys = new HashSet<String>();

        public InternalOdsHandler() {
            this.setSheetNumber(1);
        }

        private void updateTag(Node node, String odsKey, String osmKey) {
            String value = this.nodeWithKeys.get(odsKey);
            this.removeTag(odsKey);
            if (value != null && !value.isEmpty()) {
                this.addTag(node, osmKey, value);
            }
        }

        private void addTag(Node node, String osmKey, String value) {
            node.put(osmKey, value);
            this.interestingKeys.add(osmKey);
        }

        private void removeTag(String odsKey) {
            this.nodeWithKeys.remove(odsKey);
        }

        private void removeUninterestingTags() {
            for (String key : this.nodeWithKeys.getKeys().keySet()) {
                if (this.interestingKeys.contains(key)) continue;
                this.nodeWithKeys.remove(key);
            }
        }

        public void nodesAdded(DataSet ds, Map<SpreadSheetReader.CoordinateColumns, Node> nodes, String[] header, int lineNumber) {
            Node steuNode = null;
            Node rejetNode = null;
            for (SpreadSheetReader.CoordinateColumns c : nodes.keySet()) {
                if (header[c.xCol].contains("STEU") && header[c.yCol].contains("STEU")) {
                    steuNode = nodes.get(c);
                    continue;
                }
                if (header[c.xCol].contains("rejet") && header[c.yCol].contains("rejet")) {
                    rejetNode = nodes.get(c);
                    continue;
                }
                System.err.println("Line " + lineNumber + ": Unexpected coordinate columns: " + c);
            }
            if (steuNode == null || rejetNode == null) {
                System.err.println("Line " + lineNumber + ": 'STEU' or 'rejet' information not found");
                return;
            }
            this.nodeWithKeys = steuNode.hasKeys() ? steuNode : rejetNode;
            this.addTag(steuNode, "man_made", "wastewater_plant");
            this.updateTag(steuNode, "Code du STEU", "ref");
            this.updateTag(steuNode, "Nom du STEU", "name");
            this.updateTag(steuNode, "Date de mise en service du STEU", "start_date");
            this.updateTag(steuNode, "Date de mise hors service du STEU", "end_date");
            this.updateTag(steuNode, "Exploitant", "operator");
            this.updateTag(steuNode, "Capacit\u00e9 nominale en EH", "capacity");
            this.updateTag(rejetNode, "Nom du milieu de rejet", "name");
            Way pipeline = new Way();
            pipeline.addNode(steuNode);
            pipeline.addNode(rejetNode);
            if (pipeline.getLength() > 1.0) {
                ds.addPrimitive((OsmPrimitive)pipeline);
            }
            this.removeUninterestingTags();
        }
    }
}

