/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.administration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.WordUtils;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.DataGouvDataSetHandler;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class GeoFlaHandler
extends DataGouvDataSetHandler {
    private static final String ADMIN_LEVEL = "admin_level";

    public GeoFlaHandler() {
        this.setName("GEOFLA\u00ae");
        this.getShpHandler().setPreferMultipolygonToSimpleWay(true);
        try {
            this.setLocalPortalURL("http://professionnels.ign.fr/geofla#tab-3");
        }
        catch (MalformedURLException e) {
            Logging.error((Throwable)e);
        }
    }

    public String getLocalPortalIconName() {
        return "data.fr.ign_24.png";
    }

    public boolean acceptsFilename(String filename) {
        return this.isDepartementFile(filename) || this.isCommuneFile(filename) || this.isCantonFile(filename) || this.isArrondissementFile(filename);
    }

    protected boolean isDepartementFile(String filename) {
        return GeoFlaHandler.acceptsShpMifFilename((String)filename, (String[])new String[]{"DEPARTEMENT"}) || GeoFlaHandler.acceptsShpMifFilename((String)filename, (String[])new String[]{"LIMITE_DEPARTEMENT"});
    }

    protected boolean isCommuneFile(String filename) {
        return GeoFlaHandler.acceptsShpFilename((String)filename, (String[])new String[]{"COMMUNE"}) || GeoFlaHandler.acceptsShpFilename((String)filename, (String[])new String[]{"LIMITE_COMMUNE"});
    }

    protected boolean isCantonFile(String filename) {
        return GeoFlaHandler.acceptsShpFilename((String)filename, (String[])new String[]{"CANTON"}) || GeoFlaHandler.acceptsShpFilename((String)filename, (String[])new String[]{"LIMITE_CANTON"});
    }

    protected boolean isArrondissementFile(String filename) {
        return GeoFlaHandler.acceptsShpFilename((String)filename, (String[])new String[]{"ARRONDISSEMENT"}) || GeoFlaHandler.acceptsShpFilename((String)filename, (String[])new String[]{"LIMITE_ARRONDISSEMENT"});
    }

    public void updateDataSet(DataSet ds) {
        String filename = this.getAssociatedFile().getName();
        if (this.isDepartementFile(filename)) {
            this.setNationalPortalPath("GEOFLA\u00ae-D\u00e9partements-30383060");
        } else if (this.isCommuneFile(filename)) {
            this.setNationalPortalPath("GEOFLA\u00ae-Communes-30383083");
        }
        for (OsmPrimitive p : ds.allPrimitives()) {
            String population;
            LatLon llChefLieu;
            LatLon llCentroid;
            if (!GeoFlaHandler.hasKeyIgnoreCase(p, "Id_geofla", "Id_G\u00e9oFLA")) continue;
            String deptName = WordUtils.capitalizeFully((String)GeoFlaHandler.getAndRemoveIgnoreCase(p, "Nom_dept", "Nom_D\u00e9partement"));
            if ("Reunion".equals(deptName)) {
                deptName = "La R\u00e9union";
            }
            if (this.isDepartementFile(filename)) {
                p.put("name", deptName);
            } else if (this.isCommuneFile(filename)) {
                p.put("name", WordUtils.capitalizeFully((String)GeoFlaHandler.getAndRemoveIgnoreCase(p, "NOM_COM")));
                GeoFlaHandler.replace((IPrimitive)p, (String)"INSEE_COM", (String)"ref:INSEE");
            }
            GeoFlaHandler.getAndRemoveIgnoreCase(p, "NOM_REG");
            GeoFlaHandler.replace((IPrimitive)p, (String)"POPULATION", (String)"population");
            p.put("boundary", "administrative");
            String nature = GeoFlaHandler.getIgnoreCase(p, "Nature");
            if ("Fronti\u00e8re internationale".equalsIgnoreCase(nature) || "Limite c\u00f4ti\u00e8re".equalsIgnoreCase(nature)) {
                p.put(ADMIN_LEVEL, "2");
            } else if ("Limite de r\u00e9gion".equalsIgnoreCase(nature)) {
                p.put(ADMIN_LEVEL, "4");
            } else if (this.isDepartementFile(filename) || "Limite de d\u00e9partement".equalsIgnoreCase(nature)) {
                p.put(ADMIN_LEVEL, "6");
            } else if (this.isArrondissementFile(filename) || "Limite d'arrondissement".equalsIgnoreCase(nature)) {
                p.put(ADMIN_LEVEL, "7");
            } else if (this.isCommuneFile(filename)) {
                p.put(ADMIN_LEVEL, "8");
            }
            if (p instanceof Relation) {
                p.put("type", "boundary");
            }
            if ((llCentroid = GeoFlaHandler.getLatLon(p, deptName, "centroid", "Centro\u00efde")) != null) {
                Node centroid = new Node(llCentroid);
                ds.addPrimitive((OsmPrimitive)centroid);
                if (p instanceof Relation) {
                    ((Relation)p).addMember(new RelationMember("centroid", (OsmPrimitive)centroid));
                }
            }
            if ((llChefLieu = GeoFlaHandler.getLatLon(p, deptName, "chf_lieu", "Chef_Lieu")) == null) continue;
            Node chefLieu = new Node(llChefLieu);
            ds.addPrimitive((OsmPrimitive)chefLieu);
            String name = WordUtils.capitalizeFully((String)GeoFlaHandler.getAndRemoveIgnoreCase(p, "Nom_chf", "Nom_Chef_lieu"));
            if (name != null) {
                if (this.isArrondissementFile(filename)) {
                    p.put("name", name);
                }
                chefLieu.put("name", name);
            }
            if ((population = p.get("population")) != null) {
                try {
                    int pop = Integer.parseInt(population);
                    if (pop < 2000) {
                        chefLieu.put("place", "village");
                    } else if (pop < 100000) {
                        chefLieu.put("place", "town");
                    } else {
                        chefLieu.put("place", "city");
                    }
                }
                catch (NumberFormatException e) {
                    Logging.warn((String)("Invalid population: " + population));
                }
            }
            if (!(p instanceof Relation)) continue;
            ((Relation)p).addMember(new RelationMember("admin_centre", (OsmPrimitive)chefLieu));
        }
    }

    protected static boolean hasKeyIgnoreCase(OsmPrimitive p, String ... strings) {
        return GeoFlaHandler.getIgnoreCase(p, strings) != null;
    }

    protected static String getIgnoreCase(OsmPrimitive p, String ... strings) {
        String result = null;
        for (String s : strings) {
            if (result == null) {
                result = p.get(s);
            }
            if (result == null) {
                result = p.get(s.toUpperCase());
            }
            if (result != null) continue;
            result = p.get(s.toLowerCase());
        }
        return result;
    }

    protected static void removeIgnoreCase(OsmPrimitive p, String ... strings) {
        for (String s : strings) {
            p.remove(s);
            p.remove(s.toUpperCase());
            p.remove(s.toLowerCase());
        }
    }

    protected static String getAndRemoveIgnoreCase(OsmPrimitive p, String ... strings) {
        String result = GeoFlaHandler.getIgnoreCase(p, strings);
        GeoFlaHandler.removeIgnoreCase(p, strings);
        return result;
    }

    protected static LatLon getLatLon(OsmPrimitive p, String dptName, String shortAttribute, String longAttribute) {
        String x = GeoFlaHandler.getAndRemoveIgnoreCase(p, "X_" + shortAttribute, "Abscisse_" + longAttribute);
        String y = GeoFlaHandler.getAndRemoveIgnoreCase(p, "Y_" + shortAttribute, "Ordonn\u00e9e_" + longAttribute);
        if (x != null && y != null) {
            try {
                String dptCode = GeoFlaHandler.getIgnoreCase(p, "Code_dept", "Code_D\u00e9partement");
                if (dptCode != null && dptCode.equals("97") && dptName != null) {
                    if (dptName.equals("Guadeloupe")) {
                        dptCode = "971";
                    } else if (dptName.equals("Martinique")) {
                        dptCode = "972";
                    } else if (dptName.equals("Guyane")) {
                        dptCode = "973";
                    } else if (dptName.equals("La R\u00e9union")) {
                        dptCode = "974";
                    } else if (dptName.equals("Mayotte")) {
                        dptCode = "976";
                    } else {
                        Logging.error((String)("Unknown French department: " + dptName));
                    }
                }
                return GeoFlaHandler.getLatLonByDptCode((EastNorth)new EastNorth(Double.parseDouble(x), Double.parseDouble(y)), (String)dptCode, (boolean)false);
            }
            catch (NumberFormatException e) {
                Logging.error((Throwable)e);
            }
        }
        return null;
    }

    private Pair<String, URL> getGeoflaURL(String name, String urlSuffix) throws MalformedURLException {
        return new Pair((Object)name, (Object)new URL("https://wxs-telechargement.ign.fr/oikr5jryiph0iwhw36053ptm/telechargement/inspire/" + urlSuffix));
    }

    public List<Pair<String, URL>> getDataURLs() {
        ArrayList<Pair<String, URL>> result = new ArrayList<Pair<String, URL>>();
        try {
            result.add(this.getGeoflaURL("2014 Communes France M\u00e9tropolitaine", "GEOFLA_THEME-COMMUNE_2014_GEOFLA_2-0_COMMUNE_SHP_LAMB93_FXX_2014-12-05/file/GEOFLA_2-0_COMMUNE_SHP_LAMB93_FXX_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 Communes Guadeloupe", "GEOFLA_THEME-COMMUNE_2014_GEOFLA_2-0_COMMUNE_SHP_UTM20W84GUAD_D971_2014-12-08/file/GEOFLA_2-0_COMMUNE_SHP_UTM20W84GUAD_D971_2014-12-08.7z"));
            result.add(this.getGeoflaURL("2014 Communes Martinique", "GEOFLA_THEME-COMMUNE_2014_GEOFLA_2-0_COMMUNE_SHP_UTM20W84MART_D972_2014-12-08/file/GEOFLA_2-0_COMMUNE_SHP_UTM20W84MART_D972_2014-12-08.7z"));
            result.add(this.getGeoflaURL("2014 Communes Guyane", "GEOFLA_THEME-COMMUNE_2014_GEOFLA_2-0_COMMUNE_SHP_UTM22RGFG95_D973_2014-12-05/file/GEOFLA_2-0_COMMUNE_SHP_UTM22RGFG95_D973_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 Communes R\u00e9union", "GEOFLA_THEME-COMMUNE_2014_GEOFLA_2-0_COMMUNE_SHP_RGR92UTM40S_D974_2014-12-05/file/GEOFLA_2-0_COMMUNE_SHP_RGR92UTM40S_D974_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 Communes Mayotte", "GEOFLA_THEME-COMMUNE_2014_GEOFLA_2-0_COMMUNE_SHP_RGM04UTM38S_D976_2014-12-05/file/GEOFLA_2-0_COMMUNE_SHP_RGM04UTM38S_D976_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 Cantons France M\u00e9tropolitaine", "GEOFLA_THEME-CANTON_2014_GEOFLA_2-0_CANTON_SHP_LAMB93_FXX_2014-12-05/file/GEOFLA_2-0_CANTON_SHP_LAMB93_FXX_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 Cantons Guadeloupe", "GEOFLA_THEME-CANTON_2014_GEOFLA_2-0_CANTON_SHP_UTM20W84GUAD_D971_2014-12-08/file/GEOFLA_2-0_CANTON_SHP_UTM20W84GUAD_D971_2014-12-08.7z"));
            result.add(this.getGeoflaURL("2014 Cantons Martinique", "GEOFLA_THEME-CANTON_2014_GEOFLA_2-0_CANTON_SHP_UTM20W84MART_D972_2014-12-08/file/GEOFLA_2-0_CANTON_SHP_UTM20W84MART_D972_2014-12-08.7z"));
            result.add(this.getGeoflaURL("2014 Cantons Guyane", "GEOFLA_THEME-CANTON_2014_GEOFLA_2-0_CANTON_SHP_UTM22RGFG95_D973_2014-12-05/file/GEOFLA_2-0_CANTON_SHP_UTM22RGFG95_D973_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 Cantons R\u00e9union", "GEOFLA_THEME-CANTON_2014_GEOFLA_2-0_CANTON_SHP_RGR92UTM40S_D974_2014-12-05/file/GEOFLA_2-0_CANTON_SHP_RGR92UTM40S_D974_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 Cantons Mayotte", "GEOFLA_THEME-CANTON_2014_GEOFLA_2-0_CANTON_SHP_RGM04UTM38S_D976_2014-12-05/file/GEOFLA_2-0_CANTON_SHP_RGM04UTM38S_D976_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 Arrondissements France M\u00e9tropolitaine", "GEOFLA_THEME-ARRONDISSEMENT_2014_GEOFLA_2-0_ARRONDISSEMENT_SHP_LAMB93_FXX_2014-12-05/file/GEOFLA_2-0_ARRONDISSEMENT_SHP_LAMB93_FXX_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 Arrondissements Guadeloupe", "GEOFLA_THEME-ARRONDISSEMENT_2014_GEOFLA_2-0_ARRONDISSEMENT_SHP_UTM20W84GUAD_D971_2014-12-08/file/GEOFLA_2-0_ARRONDISSEMENT_SHP_UTM20W84GUAD_D971_2014-12-08.7z"));
            result.add(this.getGeoflaURL("2014 Arrondissements Martinique", "GEOFLA_THEME-ARRONDISSEMENT_2014_GEOFLA_2-0_ARRONDISSEMENT_SHP_UTM20W84MART_D972_2014-12-08/file/GEOFLA_2-0_ARRONDISSEMENT_SHP_UTM20W84MART_D972_2014-12-08.7z"));
            result.add(this.getGeoflaURL("2014 Arrondissements Guyane", "GEOFLA_THEME-ARRONDISSEMENT_2014_GEOFLA_2-0_ARRONDISSEMENT_SHP_UTM22RGFG95_D973_2014-12-05/file/GEOFLA_2-0_ARRONDISSEMENT_SHP_UTM22RGFG95_D973_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 Arrondissements R\u00e9union", "GEOFLA_THEME-ARRONDISSEMENT_2014_GEOFLA_2-0_ARRONDISSEMENT_SHP_RGR92UTM40S_D974_2014-12-05/file/GEOFLA_2-0_ARRONDISSEMENT_SHP_RGR92UTM40S_D974_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 D\u00e9partements France M\u00e9tropolitaine", "GEOFLA_THEME-DEPARTEMENTS_2014_GEOFLA_2-0_DEPARTEMENT_SHP_LAMB93_FXX_2014-12-05/file/GEOFLA_2-0_DEPARTEMENT_SHP_LAMB93_FXX_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 D\u00e9partements Guadeloupe", "GEOFLA_THEME-DEPARTEMENTS_2014_GEOFLA_2-0_DEPARTEMENT_SHP_UTM20W84GUAD_D971_2014-12-08/file/GEOFLA_2-0_DEPARTEMENT_SHP_UTM20W84GUAD_D971_2014-12-08.7z"));
            result.add(this.getGeoflaURL("2014 D\u00e9partements Martinique", "GEOFLA_THEME-DEPARTEMENTS_2014_GEOFLA_2-0_DEPARTEMENT_SHP_UTM20W84MART_D972_2014-12-08/file/GEOFLA_2-0_DEPARTEMENT_SHP_UTM20W84MART_D972_2014-12-08.7z"));
            result.add(this.getGeoflaURL("2014 D\u00e9partements Guyane", "GEOFLA_THEME-DEPARTEMENTS_2014_GEOFLA_2-0_DEPARTEMENT_SHP_UTM22RGFG95_D973_2014-12-05/file/GEOFLA_2-0_DEPARTEMENT_SHP_UTM22RGFG95_D973_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 D\u00e9partements R\u00e9union", "GEOFLA_THEME-DEPARTEMENTS_2014_GEOFLA_2-0_DEPARTEMENT_SHP_RGR92UTM40S_D974_2014-12-05/file/GEOFLA_2-0_DEPARTEMENT_SHP_RGR92UTM40S_D974_2014-12-05.7z"));
            result.add(this.getGeoflaURL("2014 D\u00e9partements Mayotte", "GEOFLA_THEME-DEPARTEMENTS_2014_GEOFLA_2-0_DEPARTEMENT_SHP_RGM04UTM38S_D976_2014-12-05/file/GEOFLA_2-0_DEPARTEMENT_SHP_RGM04UTM38S_D976_2014-12-05.7z"));
        }
        catch (MalformedURLException e) {
            Logging.error((Throwable)e);
        }
        return result;
    }
}

