/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiContainer;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiUtil;
import org.openstreetmap.josm.plugins.turnlanes.gui.InteractiveElement;
import org.openstreetmap.josm.plugins.turnlanes.gui.Path;
import org.openstreetmap.josm.plugins.turnlanes.gui.RoadGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.State;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;

final class LaneGui {
    static final NumberFormat METER_FORMAT = new DecimalFormat("0.0m");
    private final RoadGui road;
    private final Lane lane;
    final Path2D area = new Path2D.Double();
    final OutgoingConnector outgoing = new OutgoingConnector();
    final LengthSlider lengthSlider;
    private Shape clip;
    private double length;

    LaneGui(RoadGui road, Lane lane) {
        this.road = road;
        this.lane = lane;
        this.lengthSlider = lane.isExtra() ? new LengthSlider() : null;
        this.length = lane.isExtra() ? lane.getLength() / road.getContainer().getMpp() : Double.NaN;
    }

    public double getLength() {
        return this.lane.isExtra() ? this.length : this.road.getLength();
    }

    public Lane getModel() {
        return this.lane;
    }

    public RoadGui getRoad() {
        return this.road;
    }

    public GuiContainer getContainer() {
        return this.getRoad().getContainer();
    }

    public Path recalculate(Path inner, Path2D innerLine) {
        Path outer;
        double leftLength;
        Lane leftModel;
        this.area.reset();
        double W = this.road.getContainer().getModel().isLeftDirection() ? -this.getContainer().getLaneWidth() : this.getContainer().getLaneWidth();
        double L = this.getLength();
        double WW = 3.0 / this.getContainer().getMpp();
        LaneGui left = this.left();
        Lane lane = leftModel = left == null ? null : left.getModel();
        double d = leftModel == null || !leftModel.getOutgoingRoadEnd().equals(this.getModel().getOutgoingRoadEnd()) ? Double.NEGATIVE_INFINITY : (leftLength = leftModel.getKind() == Lane.Kind.EXTRA_LEFT ? left.getLength() : L);
        if (this.getModel().getKind() == Lane.Kind.EXTRA_LEFT) {
            double AL = 30.0 / this.getContainer().getMpp();
            double SL = Math.max(L, leftLength + AL);
            outer = inner.offset(W, SL, SL + AL, 0.0);
            GuiUtil.area(this.area, inner.subpath(0.0, L, true), outer.subpath(0.0, L + WW, true));
            this.lengthSlider.move(inner.getPoint(L, true));
            if (L > leftLength) {
                innerLine.append(inner.subpath(leftLength + WW, L, true).getIterator(), leftLength >= 0.0 || this.getModel().getOutgoingRoadEnd().isFromEnd());
                Point2D op = outer.getPoint(L + WW, true);
                innerLine.lineTo(op.getX(), op.getY());
            }
        } else if (this.getModel().getKind() == Lane.Kind.EXTRA_RIGHT) {
            outer = inner.offset(W, L, L + WW, 0.0);
            GuiUtil.area(this.area, inner.subpath(0.0, L + WW, true), outer.subpath(0.0, L, true));
            this.lengthSlider.move(outer.getPoint(L, true));
        } else {
            outer = inner.offset(W, -1.0, -1.0, W);
            GuiUtil.area(this.area, inner, outer);
            if (leftLength < L) {
                innerLine.append(inner.subpath(leftLength + WW, L, true).getIterator(), leftLength >= 0.0 || this.getModel().getOutgoingRoadEnd().isFromEnd());
            }
        }
        return outer;
    }

    private LaneGui left() {
        List<LaneGui> lanes = this.getRoad().getLanes(this.getModel().getOutgoingRoadEnd());
        int i = lanes.indexOf(this);
        return i > 0 ? lanes.get(i - 1) : null;
    }

    public void fill(Graphics2D g2d) {
        Shape old = g2d.getClip();
        g2d.clip(this.clip);
        g2d.fill(this.area);
        g2d.setClip(old);
    }

    public void setClip(Shape clip) {
        this.clip = clip;
    }

    public boolean contains(Point2D p) {
        return this.area.contains(p) && this.clip.contains(p);
    }

    final class OutgoingConnector
    extends InteractiveElement {
        private final Point2D center = new Point2D.Double();
        private final Ellipse2D circle = new Ellipse2D.Double();
        private Point2D dragLocation;
        private RoadGui.IncomingConnector dropTarget;

        private OutgoingConnector() {
        }

        @Override
        public void paintBackground(Graphics2D g2d, State state) {
            if (this.isActive(state)) {
                Composite old = g2d.getComposite();
                g2d.setComposite(((AlphaComposite)old).derive(0.2f));
                g2d.setColor(new Color(255, 127, 31));
                LaneGui.this.fill(g2d);
                g2d.setComposite(old);
            }
            if (this.dragLocation != null) {
                State.Connecting s = (State.Connecting)state;
                Path2D.Double path = new Path2D.Double();
                ((Path2D)path).moveTo(this.center.getX(), this.center.getY());
                List<RoadGui.ViaConnector> vias = s.getViaConnectors();
                for (int i = 0; i < vias.size() - 1; i += 2) {
                    RoadGui.ViaConnector v = vias.get(i);
                    Path.SimplePathIterator it = v.getRoad().getLaneMiddle(v.getRoadEnd().isFromEnd()).getIterator();
                    ((Path2D)path).append(it, true);
                }
                if ((vias.size() & 1) != 0) {
                    RoadGui.ViaConnector last = vias.get(vias.size() - 1);
                    ((Path2D)path).lineTo(last.getCenter().getX(), last.getCenter().getY());
                }
                if (this.dropTarget == null) {
                    g2d.setColor(GuiContainer.RED);
                    ((Path2D)path).lineTo(this.dragLocation.getX(), this.dragLocation.getY());
                } else {
                    g2d.setColor(GuiContainer.GREEN);
                    ((Path2D)path).lineTo(this.dropTarget.getCenter().getX(), this.dropTarget.getCenter().getY());
                }
                g2d.setStroke(LaneGui.this.getContainer().getConnectionStroke());
                g2d.draw(path);
            }
        }

        @Override
        public void paint(Graphics2D g2d, State state) {
            if (this.isVisible(state)) {
                Composite old = g2d.getComposite();
                if (this.isActive(state)) {
                    g2d.setComposite(((AlphaComposite)old).derive(1.0f));
                }
                g2d.setColor(Color.WHITE);
                g2d.fill(this.circle);
                g2d.setComposite(old);
            }
        }

        private boolean isActive(State state) {
            return state instanceof State.OutgoingActive && LaneGui.this.equals(((State.OutgoingActive)state).getLane());
        }

        private boolean isVisible(State state) {
            if (state instanceof State.Connecting) {
                return ((State.Connecting)state).getLane().equals(LaneGui.this.getModel());
            }
            return !LaneGui.this.getRoad().getModel().isPrimary() && LaneGui.this.getModel().getOutgoingJunction().isPrimary();
        }

        @Override
        public boolean contains(Point2D p, State state) {
            return this.isVisible(state) && (this.circle.contains(p) || LaneGui.this.contains(p));
        }

        @Override
        public InteractiveElement.Type getType() {
            return InteractiveElement.Type.OUTGOING_CONNECTOR;
        }

        @Override
        public State activate(State old) {
            return new State.OutgoingActive(LaneGui.this);
        }

        @Override
        boolean beginDrag(double x, double y) {
            return this.circle.contains(x, y);
        }

        @Override
        State.Connecting drag(double x, double y, InteractiveElement target, State old) {
            this.dragLocation = new Point2D.Double(x, y);
            this.dropTarget = null;
            if (!(old instanceof State.Connecting)) {
                return new State.Connecting(LaneGui.this.getModel());
            }
            State.Connecting s = (State.Connecting)old;
            if (target != null && target.getType() == InteractiveElement.Type.INCOMING_CONNECTOR) {
                this.dropTarget = (RoadGui.IncomingConnector)target;
                return (s.getViaConnectors().size() & 1) == 0 ? s : s.pop();
            }
            if (target != null && target.getType() == InteractiveElement.Type.VIA_CONNECTOR) {
                return s.next((RoadGui.ViaConnector)target);
            }
            return s;
        }

        @Override
        State drop(double x, double y, InteractiveElement target, State old) {
            State.Connecting s = this.drag(x, y, target, old);
            this.dragLocation = null;
            if (this.dropTarget == null) {
                return this.activate(old);
            }
            ArrayList<Road> via = new ArrayList<Road>();
            assert ((s.getViaConnectors().size() & 1) == 0);
            for (int i = 0; i < s.getViaConnectors().size(); i += 2) {
                RoadGui.ViaConnector a = s.getViaConnectors().get(i);
                RoadGui.ViaConnector b = s.getViaConnectors().get(i + 1);
                assert (a.getRoadEnd().getOppositeEnd().equals(b.getRoadEnd()));
                via.add(a.getRoadEnd().getRoad());
            }
            LaneGui.this.getModel().addTurn(via, this.dropTarget.getRoadEnd());
            this.dropTarget = null;
            return new State.Dirty(this.activate(old));
        }

        public Point2D getCenter() {
            return (Point2D)this.center.clone();
        }

        void move(double x, double y) {
            double r = LaneGui.this.getRoad().connectorRadius;
            this.center.setLocation(x, y);
            this.circle.setFrame(x - r, y - r, 2.0 * r, 2.0 * r);
        }

        @Override
        int getZIndex() {
            return 1;
        }
    }

    final class LengthSlider
    extends InteractiveElement {
        private final Point2D center = new Point2D.Double();
        private final Ellipse2D circle = new Ellipse2D.Double();
        private Point2D dragDelta;

        private LengthSlider() {
        }

        @Override
        public void paint(Graphics2D g2d, State state) {
            if (this.isVisible(state)) {
                g2d.setColor(Color.BLUE);
                g2d.fill(this.circle);
                String len = METER_FORMAT.format(LaneGui.this.getLength() * LaneGui.this.getRoad().getContainer().getMpp());
                Rectangle2D bounds = this.circle.getBounds2D();
                g2d.setFont(g2d.getFont().deriveFont(1, (float)bounds.getHeight()));
                g2d.drawString(len, (float)bounds.getMaxX(), (float)bounds.getMaxY());
            }
        }

        private boolean isVisible(State state) {
            if (state instanceof State.OutgoingActive) {
                return LaneGui.this.equals(((State.OutgoingActive)state).getLane());
            }
            return false;
        }

        @Override
        public boolean contains(Point2D p, State state) {
            return this.isVisible(state) && this.circle.contains(p);
        }

        @Override
        public InteractiveElement.Type getType() {
            return InteractiveElement.Type.INCOMING_CONNECTOR;
        }

        @Override
        boolean beginDrag(double x, double y) {
            this.dragDelta = new Point2D.Double(this.center.getX() - x, this.center.getY() - y);
            return true;
        }

        @Override
        State drag(double x, double y, InteractiveElement target, State old) {
            this.move(x + this.dragDelta.getX(), y + this.dragDelta.getY(), false);
            return new State.Dirty(old);
        }

        @Override
        State drop(double x, double y, InteractiveElement target, State old) {
            this.move(x + this.dragDelta.getX(), y + this.dragDelta.getY(), true);
            return old;
        }

        void move(double x, double y, boolean updateModel) {
            double r = LaneGui.this.getRoad().connectorRadius;
            double offset = LaneGui.this.getRoad().getOffset(x, y);
            double newLength = LaneGui.this.getModel().getOutgoingRoadEnd().isFromEnd() ? offset : LaneGui.this.getRoad().getLength() - offset;
            double adjustedLength = Math.min(Math.max(newLength, 0.1), LaneGui.this.getRoad().getLength());
            LaneGui.this.length = adjustedLength;
            if (updateModel) {
                LaneGui.this.getModel().setLength(adjustedLength * LaneGui.this.getRoad().getContainer().getMpp());
            }
            this.center.setLocation(x, y);
            this.circle.setFrame(x - r, y - r, 2.0 * r, 2.0 * r);
        }

        public void move(Point2D loc) {
            double x = loc.getX();
            double y = loc.getY();
            double r = LaneGui.this.getRoad().connectorRadius;
            this.center.setLocation(x, y);
            this.circle.setFrame(x - r, y - r, 2.0 * r, 2.0 * r);
        }

        @Override
        int getZIndex() {
            return 2;
        }
    }
}

