/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo.catastro;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.tools.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class CatastroRecord {
    public static final String fURL = "http://ovc.catastro.meh.es/OVCServWeb/OVCWcfLibres/OVCFotoFachada.svc/RecuperarFotoFachadaGet?ReferenciaCatastral=";
    public static final String cURL = "http://www.catastro.meh.es/";
    public static final String cSource = "Direcci\u00f3n General del Catastro";
    public static final String eURL = "https://www.verexif.com/ver.php?foto_file=&foto_url=";
    private ArrayList<JsonObject> errors;
    private ArrayList<JsonObject> coords;

    CatastroRecord() {
        this.init();
    }

    private void init() {
        this.errors = new ArrayList();
        this.coords = new ArrayList();
    }

    public void parseXML(String xmlStr) {
        this.init();
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(xmlStr.getBytes(StandardCharsets.UTF_8));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(input);
            doc.getDocumentElement().normalize();
            this.parseErrors(doc);
            this.parseCoordenadas(doc);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logging.warn((Throwable)e);
        }
    }

    private void parseErrors(Document doc) {
        NodeList nList = doc.getElementsByTagName("err");
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            Element eElement = (Element)nNode;
            String code = eElement.getElementsByTagName("cod").item(0).getTextContent();
            String desc = eElement.getElementsByTagName("des").item(0).getTextContent();
            JsonObject error = Json.createObjectBuilder().add("code", code).add("desc", desc).build();
            this.errors.add(error);
            Logging.info((String)("Error: (" + code + ") " + desc));
        }
    }

    private void parseCoordenadas(Document doc) {
        NodeList nList = doc.getElementsByTagName("coord");
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            Element eElement = (Element)nNode;
            String ref = eElement.getElementsByTagName("pc1").item(0).getTextContent() + eElement.getElementsByTagName("pc2").item(0).getTextContent();
            String address = eElement.getElementsByTagName("ldt").item(0).getTextContent();
            JsonObject coord = Json.createObjectBuilder().add("ref", ref).add("address", address).build();
            this.coords.add(coord);
            Logging.info((String)("Referencia Catastral: " + ref));
            Logging.info((String)("Direcci\u00f3n: " + address));
        }
    }

    public String getHtml() {
        StringBuilder r = new StringBuilder();
        r.append("<html><body bgcolor=\"white\" color=\"black\" ><table><tr><td>");
        r.append("<br/>");
        for (JsonObject coord : this.coords) {
            r.append("<i><u>Informaci\u00f3n de la parcela</u></i><br/>");
            r.append("<b>Referencia Catastral: </b>").append(coord.getString("ref")).append("<br/>");
            r.append("<b>Direcci\u00f3n: </b>").append(coord.getString("address")).append("<br/>");
            r.append("<b>Fotograf\u00eda de fachada:</b> <a href=\"").append(fURL).append(coord.getString("ref")).append("\">").append("Enlace a web de Catastro</a> (<a href=\"").append(eURL).append(fURL).append(coord.getString("ref")).append("\">metadatos</a>)<br/><br/>");
        }
        if (!this.errors.isEmpty()) {
            r.append("<i><u>Errores</u></i><br/>");
        }
        for (JsonObject error : this.errors) {
            r.append("(").append(error.getString("code")).append(") ");
            r.append(error.getString("desc")).append("<br/>");
        }
        r.append("<hr/>");
        r.append("<center><i>Fuente: <a href=\"http://www.catastro.meh.es/\">Direcci\u00f3n General del Catastro</a></i></center>");
        r.append("</td></tr></table></body></html>");
        return r.toString();
    }

    public void performAction(String act) {
    }
}

