/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.plaf.FocusArrowListener;
import com.bric.swing.DelegateFocusTraversalPolicy;
import com.bric.util.JVM;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class DialogFooter
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static KeyStroke escapeKey = KeyStroke.getKeyStroke(27, 0);
    private static KeyStroke commandPeriodKey = KeyStroke.getKeyStroke(46, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    public static ResourceBundle strings = ResourceBundle.getBundle("com.bric.swing.resources.DialogFooter");
    public static String PROPERTY_OPTION = "DialogFooter.propertyOption";
    private static int uniqueCtr = 0;
    public static final int CANCEL_OPTION = uniqueCtr++;
    public static final int OK_OPTION = uniqueCtr++;
    public static final int NO_OPTION = uniqueCtr++;
    public static final int YES_OPTION = uniqueCtr++;
    public static final int YES_NO_OPTION = uniqueCtr++;
    public static final int YES_NO_CANCEL_OPTION = uniqueCtr++;
    public static final int OK_CANCEL_OPTION = uniqueCtr++;
    public static final int SAVE_DONT_SAVE_CANCEL_OPTION = uniqueCtr++;
    public static final int DONT_SAVE_SAVE_OPTION = uniqueCtr++;
    public static final int SAVE_OPTION = uniqueCtr++;
    public static final int DONT_SAVE_OPTION = uniqueCtr++;
    public static final int UNDEFINED_OPTION = uniqueCtr++;
    private static AncestorListener escapeTriggerListener = new AncestorListener(){

        @Override
        public void ancestorAdded(AncestorEvent event) {
            JButton button = (JButton)event.getComponent();
            Window w = SwingUtilities.getWindowAncestor(button);
            if (w instanceof RootPaneContainer) {
                this.setRootPaneContainer(button, (RootPaneContainer)((Object)w));
            } else {
                this.setRootPaneContainer(button, null);
            }
        }

        private void setRootPaneContainer(JButton button, RootPaneContainer c) {
            RootPaneContainer lastContainer = (RootPaneContainer)button.getClientProperty("bric.footer.rpc");
            if (lastContainer == c) {
                return;
            }
            if (lastContainer != null) {
                lastContainer.getRootPane().getInputMap(1).remove(escapeKey);
                lastContainer.getRootPane().getActionMap().remove(escapeKey);
                if (JVM.isMac) {
                    lastContainer.getRootPane().getInputMap(1).remove(commandPeriodKey);
                }
            }
            if (c != null) {
                c.getRootPane().getInputMap(1).put(escapeKey, escapeKey);
                c.getRootPane().getActionMap().put(escapeKey, new ClickAction(button));
                if (JVM.isMac) {
                    c.getRootPane().getInputMap(1).put(commandPeriodKey, escapeKey);
                }
            }
            button.putClientProperty("bric.footer.rpc", c);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            this.ancestorAdded(event);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.ancestorAdded(event);
        }
    };
    public static final String PROPERTY_META_SHORTCUT = "Dialog.meta.shortcut";
    public static final String PROPERTY_UNSAFE = "Dialog.Unsafe.Action";
    public static boolean reverseButtonOrder = JVM.isMac;
    protected JComponent[] leftControls;
    protected JComponent[] dismissControls;
    protected JComponent lastSelectedComponent;
    protected boolean autoClose = false;
    protected JButton defaultButton = null;
    int buttonWidthPadding;
    int buttonHeightPadding;
    int buttonGap;
    int unsafeButtonGap;
    boolean fillWidth = false;
    private final ActionListener innerActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogFooter.this.lastSelectedComponent = (JComponent)e.getSource();
            DialogFooter.this.fireActionListeners(e);
            if (DialogFooter.this.autoClose) {
                closeDialogAndDisposeAction.actionPerformed(e);
            }
        }
    };
    private final HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            this.processRootPane();
            this.processWindow();
        }

        private void processRootPane() {
            JRootPane root = SwingUtilities.getRootPane(DialogFooter.this);
            if (root == null) {
                return;
            }
            root.setDefaultButton(DialogFooter.this.defaultButton);
            int a = 0;
            while (a < DialogFooter.this.dismissControls.length) {
                Character ch;
                if (DialogFooter.this.dismissControls[a] instanceof JButton && (ch = (Character)DialogFooter.this.dismissControls[a].getClientProperty(DialogFooter.PROPERTY_META_SHORTCUT)) != null) {
                    KeyStroke keyStroke = KeyStroke.getKeyStroke((int)ch.charValue(), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
                    root.getInputMap(1).put(keyStroke, keyStroke);
                    root.getActionMap().put(keyStroke, new ClickAction((JButton)DialogFooter.this.dismissControls[a]));
                }
                ++a;
            }
        }

        private void processWindow() {
            Window window = SwingUtilities.getWindowAncestor(DialogFooter.this);
            if (window == null) {
                return;
            }
            window.setFocusTraversalPolicy(new DelegateFocusTraversalPolicy(window.getFocusTraversalPolicy()){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getDefaultComponent(Container focusCycleRoot) {
                    JButton button;
                    Component defaultComponent = super.getDefaultComponent(focusCycleRoot);
                    if (DialogFooter.this.isAncestorOf(defaultComponent) && (button = (this).DialogFooter.this.defaultButton) != null && button.isShowing() && button.isEnabled() && button.isFocusable()) {
                        return button;
                    }
                    return defaultComponent;
                }
            });
        }
    };
    private Vector<ActionListener> listeners;
    public static Action closeDialogAndDisposeAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Component src = (Component)e.getSource();
            Container parent = src.getParent();
            while (parent != null) {
                if (parent instanceof JInternalFrame) {
                    ((JInternalFrame)parent).setVisible(false);
                    ((JInternalFrame)parent).dispose();
                    return;
                }
                if (parent instanceof Window) {
                    ((Window)parent).setVisible(false);
                    ((Window)parent).dispose();
                    return;
                }
                parent = parent.getParent();
            }
        }
    };

    public static JButton createCancelButton(boolean escapeKeyIsTrigger) {
        JButton button = new JButton(strings.getString("dialogCancelButton"));
        button.setMnemonic(strings.getString("dialogCancelMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, new Integer(CANCEL_OPTION));
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    public static void makeEscapeKeyActivate(AbstractButton button) {
        button.addAncestorListener(escapeTriggerListener);
    }

    public static JButton createOKButton() {
        return DialogFooter.createOKButton(false);
    }

    public static JButton createOKButton(boolean escapeKeyIsTrigger) {
        JButton button = new JButton(strings.getString("dialogOKButton"));
        button.setMnemonic(strings.getString("dialogOKMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, new Integer(OK_OPTION));
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    public static JButton createYesButton() {
        return DialogFooter.createYesButton(false);
    }

    public static JButton createYesButton(boolean escapeKeyIsTrigger) {
        JButton button = new JButton(strings.getString("dialogYesButton"));
        button.setMnemonic(strings.getString("dialogYesMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, new Integer(YES_OPTION));
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    public static JButton createNoButton() {
        return DialogFooter.createNoButton(false);
    }

    public static JButton createNoButton(boolean escapeKeyIsTrigger) {
        JButton button = new JButton(strings.getString("dialogNoButton"));
        button.setMnemonic(strings.getString("dialogNoMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, new Integer(NO_OPTION));
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    public static JButton createSaveButton() {
        return DialogFooter.createSaveButton(false);
    }

    public static JButton createSaveButton(boolean escapeKeyIsTrigger) {
        JButton button = new JButton(strings.getString("dialogSaveButton"));
        button.setMnemonic(strings.getString("dialogSaveMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, new Integer(SAVE_OPTION));
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    public static JButton createDontSaveButton() {
        return DialogFooter.createDontSaveButton(false);
    }

    public static JButton createDontSaveButton(boolean escapeKeyIsTrigger) {
        String text = strings.getString("dialogDontSaveButton");
        JButton button = new JButton(text);
        button.setMnemonic(strings.getString("dialogDontSaveMnemonic").charAt(0));
        button.putClientProperty(PROPERTY_OPTION, new Integer(DONT_SAVE_OPTION));
        button.putClientProperty(PROPERTY_META_SHORTCUT, new Character(text.charAt(0)));
        if (escapeKeyIsTrigger) {
            DialogFooter.makeEscapeKeyActivate(button);
        }
        return button;
    }

    public static DialogFooter createDialogFooter(int options, EscapeKeyBehavior escapeKeyBehavior) {
        return DialogFooter.createDialogFooter(new JComponent[0], options, escapeKeyBehavior);
    }

    public static DialogFooter createDialogFooter(JComponent[] leftComponents, int options, EscapeKeyBehavior escapeKeyBehavior) {
        if (options == CANCEL_OPTION) {
            return DialogFooter.createDialogFooter(leftComponents, options, CANCEL_OPTION, escapeKeyBehavior);
        }
        if (options == DONT_SAVE_OPTION) {
            return DialogFooter.createDialogFooter(leftComponents, options, DONT_SAVE_OPTION, escapeKeyBehavior);
        }
        if (options == NO_OPTION) {
            return DialogFooter.createDialogFooter(leftComponents, options, NO_OPTION, escapeKeyBehavior);
        }
        if (options == OK_CANCEL_OPTION) {
            return DialogFooter.createDialogFooter(leftComponents, options, OK_OPTION, escapeKeyBehavior);
        }
        if (options == OK_OPTION) {
            return DialogFooter.createDialogFooter(leftComponents, options, OK_OPTION, escapeKeyBehavior);
        }
        if (options == SAVE_DONT_SAVE_CANCEL_OPTION) {
            return DialogFooter.createDialogFooter(leftComponents, options, SAVE_OPTION, escapeKeyBehavior);
        }
        if (options == DONT_SAVE_SAVE_OPTION) {
            return DialogFooter.createDialogFooter(leftComponents, options, DONT_SAVE_OPTION, escapeKeyBehavior);
        }
        if (options == SAVE_OPTION) {
            return DialogFooter.createDialogFooter(leftComponents, options, SAVE_OPTION, escapeKeyBehavior);
        }
        if (options == YES_NO_CANCEL_OPTION) {
            return DialogFooter.createDialogFooter(leftComponents, options, YES_OPTION, escapeKeyBehavior);
        }
        if (options == YES_NO_OPTION) {
            return DialogFooter.createDialogFooter(leftComponents, options, YES_OPTION, escapeKeyBehavior);
        }
        if (options == YES_OPTION) {
            return DialogFooter.createDialogFooter(leftComponents, options, YES_OPTION, escapeKeyBehavior);
        }
        throw new IllegalArgumentException("unrecognized option type (" + options + ")");
    }

    public static DialogFooter createDialogFooter(JComponent[] leftComponents, int options, int defaultButton, EscapeKeyBehavior escapeKeyBehavior) {
        JComponent[] dismissControls;
        JButton cancelButton = null;
        JButton dontSaveButton = null;
        JButton noButton = null;
        JButton okButton = null;
        JButton saveButton = null;
        JButton yesButton = null;
        if (escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT) {
            int buttonCount = 1;
            if (options == OK_CANCEL_OPTION || options == YES_NO_OPTION || options == DONT_SAVE_SAVE_OPTION) {
                buttonCount = 2;
            } else if (options == SAVE_DONT_SAVE_CANCEL_OPTION || options == YES_NO_CANCEL_OPTION) {
                buttonCount = 3;
            }
            if (defaultButton != -1) {
                --buttonCount;
            }
            if (buttonCount > 1) {
                throw new IllegalArgumentException("request for escape key to map to " + buttonCount + " buttons.");
            }
        }
        if (options == CANCEL_OPTION || options == OK_CANCEL_OPTION || options == SAVE_DONT_SAVE_CANCEL_OPTION || options == YES_NO_CANCEL_OPTION) {
            cancelButton = DialogFooter.createCancelButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_CANCEL || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != CANCEL_OPTION || defaultButton == CANCEL_OPTION && escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT);
        }
        if (options == DONT_SAVE_OPTION || options == SAVE_DONT_SAVE_CANCEL_OPTION || options == DONT_SAVE_SAVE_OPTION) {
            dontSaveButton = DialogFooter.createDontSaveButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != DONT_SAVE_OPTION || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT && defaultButton == DONT_SAVE_OPTION);
        }
        if (options == NO_OPTION || options == YES_NO_OPTION || options == YES_NO_CANCEL_OPTION) {
            noButton = DialogFooter.createNoButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != NO_OPTION || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT && defaultButton == NO_OPTION);
        }
        if (options == OK_OPTION || options == OK_CANCEL_OPTION) {
            okButton = DialogFooter.createOKButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != OK_OPTION || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT && defaultButton == OK_OPTION);
        }
        if (options == SAVE_OPTION || options == SAVE_DONT_SAVE_CANCEL_OPTION || options == DONT_SAVE_SAVE_OPTION) {
            saveButton = DialogFooter.createSaveButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != SAVE_OPTION || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT && defaultButton == SAVE_OPTION);
        }
        if (options == YES_OPTION || options == YES_NO_OPTION || options == YES_NO_CANCEL_OPTION) {
            yesButton = DialogFooter.createYesButton(escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_NONDEFAULT && defaultButton != YES_OPTION || escapeKeyBehavior == EscapeKeyBehavior.TRIGGERS_DEFAULT && defaultButton == YES_OPTION);
        }
        if (options == CANCEL_OPTION) {
            dismissControls = new JButton[]{cancelButton};
        } else if (options == DONT_SAVE_OPTION) {
            dismissControls = new JButton[]{dontSaveButton};
        } else if (options == NO_OPTION) {
            dismissControls = new JButton[]{noButton};
        } else if (options == OK_CANCEL_OPTION) {
            dismissControls = new JButton[]{okButton, cancelButton};
        } else if (options == OK_OPTION) {
            dismissControls = new JButton[]{okButton};
        } else if (options == DONT_SAVE_SAVE_OPTION) {
            dismissControls = new JButton[]{dontSaveButton, saveButton};
        } else if (options == SAVE_DONT_SAVE_CANCEL_OPTION) {
            DialogFooter.setUnsafe(dontSaveButton, true);
            dismissControls = new JButton[]{saveButton, dontSaveButton, cancelButton};
        } else if (options == SAVE_OPTION) {
            dismissControls = new JButton[]{saveButton};
        } else if (options == YES_NO_CANCEL_OPTION) {
            dismissControls = new JButton[]{yesButton, noButton, cancelButton};
        } else if (options == YES_NO_OPTION) {
            dismissControls = new JButton[]{yesButton, noButton};
        } else if (options == YES_OPTION) {
            dismissControls = new JButton[]{yesButton};
        } else {
            throw new IllegalArgumentException("Unrecognized dialog type.");
        }
        JComponent theDefaultButton = null;
        int a = 0;
        while (a < dismissControls.length) {
            int i = (Integer)dismissControls[a].getClientProperty(PROPERTY_OPTION);
            if (i == defaultButton) {
                theDefaultButton = dismissControls[a];
            }
            ++a;
        }
        DialogFooter footer = new DialogFooter(leftComponents, dismissControls, true, (JButton)theDefaultButton);
        return footer;
    }

    private static JComponent[] copy(JComponent[] c) {
        JComponent[] newArray = new JComponent[c.length];
        int a = 0;
        while (a < c.length) {
            newArray[a] = c[a];
            ++a;
        }
        return newArray;
    }

    public DialogFooter(JComponent[] leftControls, JComponent[] dismissControls, boolean autoClose, JButton defaultButton) {
        super(new GridBagLayout());
        this.autoClose = autoClose;
        if (leftControls == null) {
            leftControls = new JComponent[]{};
        }
        if (dismissControls == null) {
            dismissControls = new JComponent[]{};
        }
        this.leftControls = DialogFooter.copy(leftControls);
        this.dismissControls = DialogFooter.copy(dismissControls);
        this.defaultButton = defaultButton;
        int a = 0;
        while (a < dismissControls.length) {
            dismissControls[a].putClientProperty("dialog.footer.index", new Integer(a));
            if (dismissControls[a] instanceof JButton) {
                ((JButton)dismissControls[a]).addActionListener(this.innerActionListener);
            } else {
                try {
                    Class<?> cl = dismissControls[a].getClass();
                    Method m = cl.getMethod("addActionListener", ActionListener.class);
                    m.invoke((Object)dismissControls[a], this.innerActionListener);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++a;
        }
        this.addHierarchyListener(this.hierarchyListener);
        a = 0;
        while (a < leftControls.length) {
            DialogFooter.addFocusArrowListener(leftControls[a]);
            ++a;
        }
        a = 0;
        while (a < dismissControls.length) {
            DialogFooter.addFocusArrowListener(dismissControls[a]);
            ++a;
        }
        if (JVM.isMac) {
            this.setButtonGap(12);
        } else if (JVM.isVista) {
            this.setButtonGap(8);
        } else {
            this.setButtonGap(6);
        }
        this.setUnsafeButtonGap(24);
        this.installGUI();
    }

    public void setInternalButtonPadding(int widthPadding, int heightPadding) {
        if (this.buttonWidthPadding == widthPadding && this.buttonHeightPadding == heightPadding) {
            return;
        }
        this.buttonWidthPadding = widthPadding;
        this.buttonHeightPadding = heightPadding;
        this.installGUI();
    }

    public void setButtonGap(int gap) {
        if (this.buttonGap == gap) {
            return;
        }
        this.buttonGap = gap;
        this.installGUI();
    }

    public void setFillWidth(boolean b) {
        if (this.fillWidth == b) {
            return;
        }
        this.fillWidth = b;
        this.installGUI();
    }

    public void setUnsafeButtonGap(int unsafeGap) {
        if (this.unsafeButtonGap == unsafeGap) {
            return;
        }
        this.unsafeButtonGap = unsafeGap;
        this.installGUI();
    }

    private void installGUI() {
        JButton comp;
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 10;
        int a = 0;
        while (a < this.leftControls.length) {
            this.add((Component)this.leftControls[a], c);
            ++c.gridx;
            c.insets = new Insets(0, 0, 0, this.buttonGap);
            ++a;
        }
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel fluff = new JPanel();
        fluff.setOpaque(false);
        if (this.leftControls.length > 0) {
            this.add((Component)fluff, c);
            ++c.gridx;
        }
        c.weightx = 0.0;
        int unsafeCtr = 0;
        int safeCtr = 0;
        int a2 = 0;
        while (a2 < this.dismissControls.length) {
            if (JVM.isMac && DialogFooter.isUnsafe(this.dismissControls[a2])) {
                ++unsafeCtr;
            } else {
                ++safeCtr;
            }
            ++a2;
        }
        JButton[] unsafeButtons = new JButton[unsafeCtr];
        JButton[] safeButtons = new JButton[safeCtr];
        unsafeCtr = 0;
        safeCtr = 0;
        int a3 = 0;
        while (a3 < this.dismissControls.length) {
            if (this.dismissControls[a3] instanceof JButton) {
                if (JVM.isMac && DialogFooter.isUnsafe(this.dismissControls[a3])) {
                    unsafeButtons[unsafeCtr++] = (JButton)this.dismissControls[a3];
                } else {
                    safeButtons[safeCtr++] = (JButton)this.dismissControls[a3];
                }
            }
            ++a3;
        }
        c.ipadx = this.buttonWidthPadding;
        c.ipady = this.buttonHeightPadding;
        c.insets = new Insets(0, 0, 0, 0);
        a3 = 0;
        while (a3 < unsafeButtons.length) {
            comp = reverseButtonOrder ? unsafeButtons[unsafeButtons.length - 1 - a3] : unsafeButtons[a3];
            this.add((Component)comp, c);
            ++c.gridx;
            c.insets.left = this.buttonGap;
            ++a3;
        }
        if (unsafeButtons.length > 0) {
            c.insets.left = this.unsafeButtonGap;
            if (this.fillWidth && this.leftControls.length == 0) {
                c.weightx = 1.0;
                this.add((Component)fluff, c);
                c.weightx = 0.0;
                ++c.gridx;
            }
        } else if (this.leftControls.length == 0) {
            c.weightx = 1.0;
            this.add((Component)fluff, c);
            c.weightx = 0.0;
            ++c.gridx;
        }
        a3 = 0;
        while (a3 < safeButtons.length) {
            comp = reverseButtonOrder ? safeButtons[safeButtons.length - 1 - a3] : safeButtons[a3];
            this.add((Component)comp, c);
            ++c.gridx;
            c.insets.left = this.buttonGap;
            ++a3;
        }
        DialogFooter.normalizeButtons(unsafeButtons);
        DialogFooter.normalizeButtons(safeButtons);
    }

    private static void addFocusArrowListener(JComponent jc) {
        KeyListener[] listeners = jc.getKeyListeners();
        int a = 0;
        while (a < listeners.length) {
            if (listeners[a] instanceof FocusArrowListener) {
                return;
            }
            ++a;
        }
        jc.addKeyListener(new FocusArrowListener());
    }

    public static void normalizeButtons(JButton[] buttons) {
        int maxWidth = 0;
        int maxHeight = 0;
        int a = 0;
        while (a < buttons.length) {
            buttons[a].setPreferredSize(null);
            Dimension d = buttons[a].getPreferredSize();
            Number n = (Number)buttons[a].getClientProperty(PROPERTY_OPTION);
            if (n != null && n.intValue() == DONT_SAVE_OPTION || d.width > 80) {
                buttons[a] = null;
            }
            if (buttons[a] != null) {
                maxWidth = Math.max(d.width, maxWidth);
                maxHeight = Math.max(d.height, maxHeight);
            }
            ++a;
        }
        a = 0;
        while (a < buttons.length) {
            if (buttons[a] != null) {
                buttons[a].setPreferredSize(new Dimension(maxWidth, maxHeight));
            }
            ++a;
        }
    }

    public static boolean isUnsafe(JComponent c) {
        Boolean b = (Boolean)c.getClientProperty(PROPERTY_UNSAFE);
        if (b == null) {
            b = Boolean.FALSE;
        }
        return b;
    }

    public static void setUnsafe(JComponent c, boolean b) {
        c.putClientProperty(PROPERTY_UNSAFE, new Boolean(b));
    }

    public void addActionListener(ActionListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    private void fireActionListeners(ActionEvent e) {
        if (this.listeners == null) {
            return;
        }
        int a = 0;
        while (a < this.listeners.size()) {
            ActionListener l = this.listeners.get(a);
            try {
                l.actionPerformed(e);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            ++a;
        }
    }

    public JComponent getLastSelectedComponent() {
        return this.lastSelectedComponent;
    }

    public JButton getButton(int buttonType) {
        int a = 0;
        while (a < this.getComponentCount()) {
            if (this.getComponent(a) instanceof JButton) {
                JButton button = (JButton)this.getComponent(a);
                Object value = button.getClientProperty(PROPERTY_OPTION);
                int intValue = -1;
                if (value instanceof Number) {
                    intValue = ((Number)value).intValue();
                }
                if (intValue == buttonType) {
                    return button;
                }
            }
            ++a;
        }
        return null;
    }

    public boolean containsButton(int buttonType) {
        return this.getButton(buttonType) != null;
    }

    public void reset() {
        this.lastSelectedComponent = null;
    }

    public JComponent[] getDismissControls() {
        return DialogFooter.copy(this.dismissControls);
    }

    public void setAutoClose(boolean b) {
        this.autoClose = b;
    }

    public JComponent[] getLeftControls() {
        return DialogFooter.copy(this.leftControls);
    }

    public static class ClickAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        JButton button;

        public ClickAction(JButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.button.doClick();
        }
    }

    public static enum EscapeKeyBehavior {
        DOES_NOTHING,
        TRIGGERS_CANCEL,
        TRIGGERS_DEFAULT,
        TRIGGERS_NONDEFAULT;

    }
}

