/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.util.BooleanProperty;
import com.bric.util.EnumProperty;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public class ContextualMenuHelper {
    private static final String MENU_KEY = String.valueOf(ContextualMenuHelper.class.getName()) + ".menuKey";
    JPopupMenu popup = new JPopupMenu();

    public static void add(JComponent jc, String menuItemName, Runnable runnable) {
        ContextualMenuHelper cmh = (ContextualMenuHelper)jc.getClientProperty(MENU_KEY);
        if (cmh == null) {
            cmh = new ContextualMenuHelper(jc);
            jc.putClientProperty(MENU_KEY, cmh);
        }
        cmh.add(menuItemName, runnable);
    }

    public static void addToggle(JComponent jc, BooleanProperty property, Runnable runnable) {
        ContextualMenuHelper cmh = (ContextualMenuHelper)jc.getClientProperty(MENU_KEY);
        if (cmh == null) {
            cmh = new ContextualMenuHelper(jc);
            jc.putClientProperty(MENU_KEY, cmh);
        }
        cmh.addToggle(property, runnable);
    }

    public static void addPopupMenu(String popupName, JComponent jc, EnumProperty<?> property, Runnable runnable) {
        ContextualMenuHelper cmh = (ContextualMenuHelper)jc.getClientProperty(MENU_KEY);
        if (cmh == null) {
            cmh = new ContextualMenuHelper(jc);
            jc.putClientProperty(MENU_KEY, cmh);
        }
        cmh.addPopupMenu(popupName, property, runnable);
    }

    ContextualMenuHelper(JComponent jc) {
        jc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.showPopupMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopupMenu(e);
            }

            private void showPopupMenu(final MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    return;
                }
                e.consume();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ContextualMenuHelper.this.showPopup(e.getComponent(), e.getX(), e.getY());
                    }
                });
            }
        });
    }

    void add(String menuItemName, final Runnable runnable) {
        JMenuItem menuItem = new JMenuItem(menuItemName);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(runnable);
            }
        });
        this.popup.add(menuItem);
    }

    void addToggle(final BooleanProperty property, final Runnable runnable) {
        final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(property.getName());
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                property.setValue(menuItem.isSelected());
                SwingUtilities.invokeLater(runnable);
            }
        });
        property.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        menuItem.setSelected((Boolean)property.getValue());
                    }
                });
                SwingUtilities.invokeLater(runnable);
            }
        });
        this.popup.add(menuItem);
    }

    void addPopupMenu(String popupName, final EnumProperty property, final Runnable runnable) {
        T[] values = property.getValues();
        JMenu myPopup = new JMenu(popupName);
        int a = 0;
        while (a < values.length) {
            final Object currentValue = values[a];
            final JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(currentValue.toString());
            myPopup.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    property.setValue(currentValue);
                    SwingUtilities.invokeLater(runnable);
                }
            });
            property.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            menuItem.setSelected(currentValue.equals(property.getValue()));
                        }
                    });
                    SwingUtilities.invokeLater(runnable);
                }
            });
            menuItem.setSelected(currentValue.equals(property.getValue()));
            ++a;
        }
        this.popup.add(myPopup);
    }

    void showPopup(Component c, int x, int y) {
        this.popup.show(c, x, y);
    }

    public static void clear(JComponent component) {
        ContextualMenuHelper cmh = (ContextualMenuHelper)component.getClientProperty(MENU_KEY);
        if (cmh == null) {
            return;
        }
        cmh.popup.removeAll();
    }
}

