/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.blog.Blurb;
import com.bric.swing.BricApplet;
import com.bric.swing.ColorPicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.UIManager;

@Blurb(filename="ColorPicker", title="Colors: a Color Dialog", releaseDate="April 2007", summary="This is a Photoshop-style color choosing dialog.\n<p>You can pull some parts of it apart for customization, but out-of-the-box it offers a great interface if you're dealing with a power user.\n<p>Of course: all dialogs are at least slightly evil, and they should be used with care...", instructions="This applet demonstrates the <code>ColorPicker</code> panel.\n<p>This is one of the most popular subprojects here: it's a more sophisticated alternative to the <code>JColorChooser</code>.\nThe controls should be self-explanatory: try clicking the color wheel, color slider, and all the controls on the left.", link="http://javagraphics.blogspot.com/2007/04/jcolorchooser-making-alternative.html", sandboxDemo=true)
public class ColorPickerDemo
extends BricApplet {
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) {
        final JFrame demo = new JFrame("Demo");
        final JWindow palette = new JWindow(demo);
        final ColorPicker picker = new ColorPicker(true, false);
        final JComboBox<String> comboBox = new JComboBox<String>();
        final JCheckBox alphaCheckbox = new JCheckBox("Include Alpha");
        final JCheckBox hsbCheckbox = new JCheckBox("Include HSB Values");
        final JCheckBox rgbCheckbox = new JCheckBox("Include RGB Values");
        final JCheckBox modeCheckbox = new JCheckBox("Include Mode Controls", true);
        JButton button = new JButton("Show Dialog");
        demo.getContentPane().setLayout(new GridBagLayout());
        palette.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        palette.getContentPane().add(comboBox, c);
        ++c.gridy;
        palette.getContentPane().add((Component)alphaCheckbox, c);
        ++c.gridy;
        palette.getContentPane().add((Component)hsbCheckbox, c);
        ++c.gridy;
        palette.getContentPane().add((Component)rgbCheckbox, c);
        ++c.gridy;
        palette.getContentPane().add((Component)modeCheckbox, c);
        c.gridy = 0;
        c.weighty = 1.0;
        c.fill = 1;
        picker.setPreferredSize(new Dimension(220, 200));
        demo.getContentPane().add((Component)picker, c);
        ++c.gridy;
        c.weighty = 0.0;
        demo.getContentPane().add((Component)picker.getExpertControls(), c);
        ++c.gridy;
        c.fill = 0;
        demo.getContentPane().add((Component)button, c);
        comboBox.addItem("Hue");
        comboBox.addItem("Saturation");
        comboBox.addItem("Brightness");
        comboBox.addItem("Red");
        comboBox.addItem("Green");
        comboBox.addItem("Blue");
        ActionListener checkboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src == alphaCheckbox) {
                    picker.setOpacityVisible(alphaCheckbox.isSelected());
                } else if (src == hsbCheckbox) {
                    picker.setHSBControlsVisible(hsbCheckbox.isSelected());
                } else if (src == rgbCheckbox) {
                    picker.setRGBControlsVisible(rgbCheckbox.isSelected());
                } else if (src == modeCheckbox) {
                    picker.setModeControlsVisible(modeCheckbox.isSelected());
                }
                demo.pack();
            }
        };
        picker.setOpacityVisible(false);
        picker.setHSBControlsVisible(false);
        picker.setRGBControlsVisible(false);
        picker.setHexControlsVisible(false);
        picker.setPreviewSwatchVisible(false);
        picker.addPropertyChangeListener("mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int m = picker.getMode();
                if (m == 0) {
                    comboBox.setSelectedIndex(0);
                } else if (m == 2) {
                    comboBox.setSelectedIndex(1);
                } else if (m == 1) {
                    comboBox.setSelectedIndex(2);
                } else if (m == 3) {
                    comboBox.setSelectedIndex(3);
                } else if (m == 4) {
                    comboBox.setSelectedIndex(4);
                } else if (m == 5) {
                    comboBox.setSelectedIndex(5);
                }
            }
        });
        alphaCheckbox.addActionListener(checkboxListener);
        hsbCheckbox.addActionListener(checkboxListener);
        rgbCheckbox.addActionListener(checkboxListener);
        modeCheckbox.addActionListener(checkboxListener);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = picker.getColor();
                if ((color = ColorPicker.showDialog(demo, color, true)) != null) {
                    picker.setColor(color);
                }
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = ((JComboBox)e.getSource()).getSelectedIndex();
                if (i == 0) {
                    picker.setMode(0);
                } else if (i == 1) {
                    picker.setMode(2);
                } else if (i == 2) {
                    picker.setMode(1);
                } else if (i == 3) {
                    picker.setMode(3);
                } else if (i == 4) {
                    picker.setMode(4);
                } else if (i == 5) {
                    picker.setMode(5);
                }
            }
        });
        comboBox.setSelectedIndex(2);
        palette.pack();
        palette.setLocationRelativeTo(null);
        demo.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Point p = demo.getLocation();
                palette.setLocation(new Point(p.x - palette.getWidth() - 10, p.y));
            }
        });
        demo.pack();
        demo.setLocationRelativeTo(null);
        demo.setVisible(true);
        palette.setVisible(true);
        demo.setDefaultCloseOperation(3);
    }

    public ColorPickerDemo() {
        try {
            String lf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(lf);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        ColorPicker picker = new ColorPicker();
        picker.setOpacityVisible(true);
        Random r = new Random(System.currentTimeMillis());
        picker.setColor(new Color(r.nextInt(255), r.nextInt(255), r.nextInt(255)));
        this.getContentPane().add(picker);
        picker.setBackground(Color.white);
        picker.setOpaque(true);
    }

    private static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Color) {
            Color c = (Color)obj;
            return "Color[ r=" + c.getRed() + ", g=" + c.getGreen() + ", b=" + c.getBlue() + ", a=" + c.getAlpha() + "]";
        }
        return obj.toString();
    }
}

