/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.util.Converters;
import org.geotools.xsd.Binding;
import org.geotools.xsd.ComplexBinding;
import org.geotools.xsd.SimpleBinding;
import org.geotools.xsd.impl.BindingWalker;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.helpers.NamespaceSupport;

public class ElementEncodeExecutor
implements BindingWalker.Visitor {
    Object object;
    XSDElementDeclaration element;
    Element encoding;
    Document document;
    Logger logger;
    NamespaceSupport namespaces;

    public ElementEncodeExecutor(Object object, XSDElementDeclaration element, Document document, Logger logger, NamespaceSupport namespaces) {
        this.object = object;
        this.element = element;
        this.document = document;
        this.logger = logger;
        this.namespaces = namespaces;
        this.encoding = document.createElementNS(element.getTargetNamespace(), element.getName());
    }

    public Element getEncodedElement() {
        return this.encoding;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(Binding binding) {
        if (binding.getType() == null) {
            if (!this.logger.isLoggable(Level.FINE)) return;
            this.logger.fine("Binding: " + binding.getTarget() + " does not declare a target type");
            return;
        }
        if (this.object != null && !(this.object instanceof ComplexAttribute) && !binding.getType().isAssignableFrom(this.object.getClass())) {
            Object converted = Converters.convert(this.object, binding.getType());
            if (converted != null) {
                this.object = converted;
            } else {
                if (!this.logger.isLoggable(Level.FINE)) return;
                this.logger.fine("[ " + this.object.getClass() + " ] is not of type " + binding.getType());
                return;
            }
        }
        if (binding instanceof ComplexBinding) {
            ComplexBinding complex = (ComplexBinding)binding;
            try {
                Element element = complex.encode(this.object, this.document, this.encoding);
                if (element == null) return;
                this.encoding = element;
                return;
            }
            catch (Throwable t) {
                String msg = "Encode failed for " + this.element.getName() + ". Cause: " + t.getLocalizedMessage();
                throw new RuntimeException(msg, t);
            }
        }
        SimpleBinding simple = (SimpleBinding)binding;
        CharacterData text = null;
        for (int i = 0; i < this.encoding.getChildNodes().getLength(); ++i) {
            Node node = this.encoding.getChildNodes().item(i);
            if (!(node instanceof Text)) continue;
            text = (Text)node;
            break;
        }
        try {
            if (this.object != null) {
                String value = simple.encode(this.object, text != null ? text.getData() : null);
                if (value == null) return;
                if (text == null) {
                    text = this.document.createTextNode(value);
                    this.encoding.appendChild(text);
                    return;
                } else {
                    text.setData(value);
                }
                return;
            } else {
                String prefix = null;
                if (this.namespaces != null) {
                    prefix = this.namespaces.getPrefix("http://www.w3.org/2001/XMLSchema");
                }
                if (prefix == null) {
                    prefix = "xs";
                }
                this.encoding.setAttribute(prefix + ":nil", "true");
            }
            return;
        }
        catch (Throwable t) {
            String msg = "Encode failed for " + this.element.getName() + ". Cause: " + t.getLocalizedMessage();
            throw new RuntimeException(msg, t);
        }
    }
}

