/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.api.util.InternationalString;
import org.geotools.util.Classes;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

@SuppressFBWarnings(value={"UI_INHERITANCE_UNSAFE_GETRESOURCE"})
public class IndexedResourceBundle
extends ResourceBundle {
    private static final int MAX_STRING_LENGTH = 200;
    private final String filename;
    private String[] values;
    private transient Locale locale;
    private transient MessageFormat format;
    private transient int lastKey;

    protected IndexedResourceBundle() {
        this.filename = this.getClass().getSimpleName() + ".utf";
    }

    protected IndexedResourceBundle(String filename) {
        this.filename = filename;
    }

    private Locale getFormatLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
            Locale resourceLocale = this.getLocale();
            if (!this.locale.getLanguage().equalsIgnoreCase(resourceLocale.getLanguage())) {
                this.locale = resourceLocale;
            }
        }
        return this.locale;
    }

    private String getPackageName() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(46);
        return index >= 0 ? name.substring(0, index) : "org.geotools";
    }

    public final void list(Writer out) throws IOException {
        IndexedResourceBundle.list(out, this.ensureLoaded(null));
    }

    private static void list(Writer out, String ... values) throws IOException {
        String lineSeparator = System.getProperty("line.separator", "\n");
        for (int i = 0; i < values.length; ++i) {
            int indexLF;
            String value = values[i];
            if (value == null) continue;
            int indexCR = value.indexOf(13);
            if (indexCR < 0) {
                indexCR = value.length();
            }
            if ((indexLF = value.indexOf(10)) < 0) {
                indexLF = value.length();
            }
            String number = String.valueOf(i);
            out.write(Utilities.spaces(5 - number.length()));
            out.write(number);
            out.write(":\t");
            out.write(value.substring(0, Math.min(indexCR, indexLF)));
            out.write(lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] ensureLoaded(String key) throws MissingResourceException {
        LogRecord record = null;
        try {
            String[] values;
            IndexedResourceBundle indexedResourceBundle = this;
            synchronized (indexedResourceBundle) {
                String language;
                block17: {
                    values = this.values;
                    if (values != null) {
                        return values;
                    }
                    record = new LogRecord(Level.FINER, "Loaded resources for {0} from bundle \"{1}\".");
                    record.setSourceClassName(this.getClass().getName());
                    record.setSourceMethodName(key != null ? "getObject" : "getKeys");
                    InputStream in = null;
                    Object name = this.filename;
                    boolean cleanupIn = true;
                    while ((in = this.getClass().getResourceAsStream((String)name)) == null) {
                        int ext = ((String)name).lastIndexOf(46);
                        int lang = ((String)name).lastIndexOf(95, ext - 1);
                        if (lang <= 0) {
                            throw new FileNotFoundException(this.filename);
                        }
                        name = ((String)name).substring(0, lang) + ((String)name).substring(ext);
                    }
                    try (DataInputStream input = new DataInputStream(new BufferedInputStream(in));){
                        values = new String[input.readInt()];
                        this.values = values;
                        for (int i = 0; i < values.length; ++i) {
                            values[i] = input.readUTF();
                            if (values[i].length() != 0) continue;
                            values[i] = null;
                        }
                        cleanupIn = true;
                    }
                    catch (Exception e) {
                        if (in == null || !cleanupIn) break block17;
                        in.close();
                    }
                }
                if ((language = this.getLocale().getDisplayName(Locale.US)) == null || language.length() == 0) {
                    language = "<default>";
                }
                record.setParameters(new String[]{language, this.getPackageName()});
            }
            Logger logger = Logging.getLogger(IndexedResourceBundle.class);
            record.setLoggerName(logger.getName());
            logger.log(record);
            return values;
        }
        catch (IOException exception) {
            record.setLevel(Level.WARNING);
            record.setMessage(exception.getLocalizedMessage());
            record.setThrown(exception);
            Logger logger = Logging.getLogger(IndexedResourceBundle.class);
            record.setLoggerName(logger.getName());
            logger.log(record);
            MissingResourceException error = new MissingResourceException(exception.getLocalizedMessage(), this.getClass().getName(), key);
            error.initCause(exception);
            throw error;
        }
    }

    @Override
    public final Enumeration<String> getKeys() {
        final String[] values = this.ensureLoaded(null);
        return new Enumeration<String>(){
            private int i = 0;

            @Override
            public boolean hasMoreElements() {
                while (this.i < values.length) {
                    if (values[this.i] != null) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }

            @Override
            public String nextElement() {
                while (true) {
                    if (this.i >= values.length) {
                        throw new NoSuchElementException();
                    }
                    if (values[this.i] != null) {
                        return String.valueOf(this.i++);
                    }
                    ++this.i;
                }
            }
        };
    }

    @Override
    protected final Object handleGetObject(String key) {
        int keyID;
        String[] values = this.ensureLoaded(key);
        try {
            keyID = Integer.parseInt(key);
        }
        catch (NumberFormatException exception) {
            return null;
        }
        return keyID >= 0 && keyID < values.length ? values[keyID] : null;
    }

    private static String summarize(String text, int maxLength) {
        int break1;
        int length = (text = text.trim()).length();
        if (length <= maxLength) {
            return text;
        }
        if ((maxLength = maxLength - 7 >> 1) <= 0) {
            return text;
        }
        int break2 = length - maxLength;
        int lower = maxLength >> 1;
        for (break1 = maxLength; break1 >= lower; --break1) {
            if (Character.isUnicodeIdentifierPart(text.charAt(break1))) continue;
            --break1;
            while (break1 >= lower && !Character.isUnicodeIdentifierPart(text.charAt(break1))) {
                --break1;
            }
            break;
        }
        int upper = length - (maxLength >> 1);
        while (break2 < upper) {
            if (!Character.isUnicodeIdentifierPart(text.charAt(break2))) {
                ++break2;
                while (break2 < upper && !Character.isUnicodeIdentifierPart(text.charAt(break2))) {
                    ++break2;
                }
                break;
            }
            ++break2;
        }
        return (text.substring(0, break1 + 1) + " (...) " + text.substring(break2)).trim();
    }

    private Object[] toArray(Object arguments) {
        Object[] array = arguments instanceof Object[] ? (Object[])arguments : new Object[]{arguments};
        for (int i = 0; i < array.length; ++i) {
            Object element = array[i];
            if (element instanceof CharSequence) {
                String s1;
                String s0 = element instanceof InternationalString ? ((InternationalString)element).toString(this.getFormatLocale()) : element.toString();
                if (s0 == (s1 = IndexedResourceBundle.summarize(s0, 200)) || s0.equals(s1)) continue;
                if (array == arguments) {
                    array = new Object[array.length];
                    System.arraycopy(arguments, 0, array, 0, array.length);
                }
                array[i] = s1;
                continue;
            }
            if (element instanceof Throwable) {
                String message = ((Throwable)element).getLocalizedMessage();
                if (message == null) {
                    message = Classes.getShortClassName(element);
                }
                array[i] = message;
                continue;
            }
            if (!(element instanceof Class)) continue;
            array[i] = Classes.getShortName((Class)element);
        }
        return array;
    }

    public final String getMenuLabel(int key) throws MissingResourceException {
        return this.getString(key) + "...";
    }

    public final String getLabel(int key) throws MissingResourceException {
        return this.getString(key) + ": ";
    }

    public final String getString(int key) throws MissingResourceException {
        return this.getString(String.valueOf(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getString(int key, Object arg0) throws MissingResourceException {
        String pattern = this.getString(key);
        Object[] arguments = this.toArray(arg0);
        IndexedResourceBundle indexedResourceBundle = this;
        synchronized (indexedResourceBundle) {
            if (this.format == null) {
                this.format = new MessageFormat(pattern, this.getFormatLocale());
            } else if (key != this.lastKey) {
                this.format.applyPattern(pattern);
                this.lastKey = key;
            }
            return this.format.format(arguments);
        }
    }

    public final String getString(int key, Object arg0, Object arg1) throws MissingResourceException {
        return this.getString(key, new Object[]{arg0, arg1});
    }

    public final String getString(int key, Object arg0, Object arg1, Object arg2) throws MissingResourceException {
        return this.getString(key, new Object[]{arg0, arg1, arg2});
    }

    public final String getString(int key, Object arg0, Object arg1, Object arg2, Object arg3) throws MissingResourceException {
        return this.getString(key, new Object[]{arg0, arg1, arg2, arg3});
    }

    public final String getString(int key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) throws MissingResourceException {
        return this.getString(key, new Object[]{arg0, arg1, arg2, arg3, arg4});
    }

    public LogRecord getLogRecord(Level level, int key) {
        return this.getLogRecord(level, key, null);
    }

    public LogRecord getLogRecord(Level level, int key, Object arg0) {
        LogRecord record = new LogRecord(level, String.valueOf(key));
        record.setResourceBundle(this);
        if (arg0 != null) {
            record.setParameters(this.toArray(arg0));
        }
        return record;
    }

    public LogRecord getLogRecord(Level level, int key, Object arg0, Object arg1) {
        return this.getLogRecord(level, key, new Object[]{arg0, arg1});
    }

    public LogRecord getLogRecord(Level level, int key, Object arg0, Object arg1, Object arg2) {
        return this.getLogRecord(level, key, new Object[]{arg0, arg1, arg2});
    }

    public LogRecord getLogRecord(Level level, int key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.getLogRecord(level, key, new Object[]{arg0, arg1, arg2, arg3});
    }

    public static String format(LogRecord record) {
        String message = record.getMessage();
        ResourceBundle resources = record.getResourceBundle();
        if (resources instanceof IndexedResourceBundle) {
            int key = -1;
            try {
                key = Integer.parseInt(message);
            }
            catch (NumberFormatException e) {
                IndexedResourceBundle.unexpectedException(e);
            }
            if (key >= 0) {
                Object[] parameters = record.getParameters();
                return ((IndexedResourceBundle)resources).getString(key, parameters);
            }
        }
        if (resources != null) {
            char c;
            int offset;
            try {
                message = resources.getString(message);
            }
            catch (MissingResourceException e) {
                IndexedResourceBundle.unexpectedException(e);
            }
            Object[] parameters = record.getParameters();
            if (parameters != null && parameters.length != 0 && (offset = message.indexOf(123)) >= 0 && offset < message.length() - 1 && (c = message.charAt(offset)) >= '0' && c <= '9') {
                try {
                    return MessageFormat.format(message, parameters);
                }
                catch (IllegalArgumentException e) {
                    IndexedResourceBundle.unexpectedException(e);
                }
            }
        }
        return message;
    }

    private static void unexpectedException(RuntimeException exception) {
        Logging.unexpectedException(IndexedResourceBundle.class, "format", exception);
    }

    public synchronized String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(this));
        buffer.append('[');
        if (this.values != null) {
            int count = 0;
            for (String value : this.values) {
                if (value == null) continue;
                ++count;
            }
            buffer.append(count);
            buffer.append(" values");
        }
        buffer.append(']');
        return buffer.toString();
    }
}

