/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.Description;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.Extent;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.ExternalMark;
import org.geotools.api.style.FeatureTypeConstraint;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicLegend;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Halo;
import org.geotools.api.style.ImageOutline;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.OtherText;
import org.geotools.api.style.OverlapBehavior;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbol;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.style.UserLayer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.OtherTextImpl;
import org.geotools.styling.OverlapBehaviorImpl;

public class DuplicatingStyleVisitor
implements StyleVisitor {
    protected final StyleFactory sf;
    protected final FilterFactory ff;
    protected boolean STRICT;
    protected final DuplicatingFilterVisitor copyFilter;
    protected Stack<Object> pages = new Stack();

    public DuplicatingStyleVisitor() {
        this(CommonFactoryFinder.getStyleFactory(null));
    }

    public DuplicatingStyleVisitor(StyleFactory styleFactory) {
        this(styleFactory, CommonFactoryFinder.getFilterFactory(null));
    }

    public DuplicatingStyleVisitor(StyleFactory styleFactory, FilterFactory filterFactory) {
        this(styleFactory, filterFactory, new DuplicatingFilterVisitor(filterFactory));
    }

    public DuplicatingStyleVisitor(StyleFactory styleFactory, FilterFactory filterFactory, DuplicatingFilterVisitor filterCloner) {
        this.copyFilter = filterCloner;
        this.sf = styleFactory;
        this.ff = filterFactory;
        this.STRICT = false;
    }

    public void setStrict(boolean strict) {
        this.STRICT = strict;
    }

    public Object getCopy() {
        return this.pages.peek();
    }

    @Override
    public void visit(StyledLayerDescriptor sld) {
        StyledLayer[] layers = sld.getStyledLayers();
        StyledLayer[] layersCopy = new StyledLayer[layers.length];
        int length = layers.length;
        for (int i = 0; i < length; ++i) {
            if (layers[i] instanceof UserLayer) {
                ((UserLayer)layers[i]).accept(this);
                layersCopy[i] = (UserLayer)this.pages.pop();
                continue;
            }
            if (!(layers[i] instanceof NamedLayer)) continue;
            ((NamedLayer)layers[i]).accept(this);
            layersCopy[i] = (NamedLayer)this.pages.pop();
        }
        StyledLayerDescriptor copy = this.sf.createStyledLayerDescriptor();
        copy.setAbstract(sld.getAbstract());
        copy.setName(sld.getName());
        copy.setTitle(sld.getTitle());
        copy.setStyledLayers(layersCopy);
        if (this.STRICT && !copy.equals(sld)) {
            throw new IllegalStateException("Was unable to duplicate provided SLD:" + sld);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(NamedLayer layer) {
        Style[] style = layer.getStyles();
        Style[] styleCopy = new Style[style.length];
        int length = style.length;
        for (int i = 0; i < length; ++i) {
            if (style[i] == null) continue;
            style[i].accept(this);
            styleCopy[i] = (Style)this.pages.pop();
        }
        FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
        FeatureTypeConstraint[] lfcCopy = new FeatureTypeConstraint[lfc.length];
        length = lfc.length;
        for (int i = 0; i < length; ++i) {
            if (lfc[i] == null) continue;
            lfc[i].accept(this);
            lfcCopy[i] = (FeatureTypeConstraint)this.pages.pop();
        }
        NamedLayer copy = this.sf.createNamedLayer();
        copy.setName(layer.getName());
        length = styleCopy.length;
        for (int i = 0; i < length; ++i) {
            copy.addStyle(styleCopy[i]);
        }
        copy.setLayerFeatureConstraints(lfcCopy);
        this.pages.push(copy);
    }

    @Override
    public void visit(UserLayer layer) {
        Style[] style = layer.getUserStyles();
        int length = style.length;
        Style[] styleCopy = new Style[length];
        for (int i = 0; i < length; ++i) {
            if (style[i] == null) continue;
            style[i].accept(this);
            styleCopy[i] = (Style)this.pages.pop();
        }
        FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
        FeatureTypeConstraint[] lfcCopy = new FeatureTypeConstraint[lfc.length];
        length = lfc.length;
        for (int i = 0; i < length; ++i) {
            if (lfc[i] == null) continue;
            lfc[i].accept(this);
            lfcCopy[i] = (FeatureTypeConstraint)this.pages.pop();
        }
        UserLayer copy = this.sf.createUserLayer();
        copy.setName(layer.getName());
        copy.setUserStyles(styleCopy);
        copy.setLayerFeatureConstraints(lfcCopy);
        if (this.STRICT && !copy.equals(layer)) {
            throw new IllegalStateException("Was unable to duplicate provided UserLayer:" + layer);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(Style style) {
        ArrayList<FeatureTypeStyle> ftsCopy = new ArrayList<FeatureTypeStyle>();
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            if (fts == null) continue;
            fts.accept(this);
            if (this.pages.empty()) continue;
            ftsCopy.add((FeatureTypeStyle)this.pages.pop());
        }
        Style copy = this.sf.createStyle();
        copy.getDescription().setAbstract(style.getDescription().getAbstract());
        copy.setName(style.getName());
        copy.getDescription().setTitle(style.getDescription().getTitle());
        copy.featureTypeStyles().addAll(ftsCopy);
        copy.setBackground(this.copy(style.getBackground()));
        if (this.STRICT && !copy.equals(style)) {
            throw new IllegalStateException("Was unable to duplicate provided Style:" + style);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(Rule rule) {
        Filter filterCopy = null;
        if (rule.getFilter() != null) {
            Filter filter = rule.getFilter();
            filterCopy = this.copy(filter);
        }
        List symsCopy = rule.symbolizers().stream().map(s -> this.copy((Symbolizer)s)).filter(s -> s != null).collect(Collectors.toList());
        GraphicLegend legendCopy = (GraphicLegend)this.copy(rule.getLegend());
        Description descCopy = rule.getDescription();
        descCopy = this.copy(descCopy);
        Rule copy = this.sf.createRule();
        copy.symbolizers().addAll(symsCopy);
        copy.setDescription(descCopy);
        copy.setLegend(legendCopy);
        copy.setName(rule.getName());
        copy.setFilter(filterCopy);
        copy.setElseFilter(rule.isElseFilter());
        copy.setMaxScaleDenominator(rule.getMaxScaleDenominator());
        copy.setMinScaleDenominator(rule.getMinScaleDenominator());
        copy.getOptions().putAll(rule.getOptions());
        if (this.STRICT && !copy.equals(rule)) {
            throw new IllegalStateException("Was unable to duplicate provided Rule:" + rule);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(FeatureTypeStyle fts) {
        FeatureTypeStyleImpl copy = new FeatureTypeStyleImpl(fts);
        List rulesCopy = fts.rules().stream().filter(r -> r != null).map(r -> {
            r.accept(this);
            return !this.pages.isEmpty() ? (Rule)this.pages.pop() : null;
        }).filter(r -> r != null).collect(Collectors.toList());
        copy.rules().clear();
        copy.rules().addAll(rulesCopy);
        if (fts.getTransformation() != null) {
            copy.setTransformation(this.copy(fts.getTransformation()));
        }
        if (fts.getOnlineResource() != null) {
            copy.setOnlineResource(fts.getOnlineResource());
        }
        copy.getOptions().clear();
        copy.getOptions().putAll(fts.getOptions());
        if (this.STRICT && !((Object)copy).equals(fts)) {
            throw new IllegalStateException("Was unable to duplicate provided FeatureTypeStyle:" + fts);
        }
        this.pages.push(copy);
    }

    protected List<Expression> copyExpressions(List<Expression> expressions) {
        if (expressions == null) {
            return null;
        }
        ArrayList<Expression> copy = new ArrayList<Expression>(expressions.size());
        for (Expression expression : expressions) {
            copy.add(this.copy(expression));
        }
        return copy;
    }

    protected Expression copy(Expression expression) {
        if (expression == null) {
            return null;
        }
        return (Expression)expression.accept(this.copyFilter, this.ff);
    }

    protected Filter copy(Filter filter) {
        if (filter == null) {
            return null;
        }
        return (Filter)filter.accept(this.copyFilter, this.ff);
    }

    protected Graphic copy(Graphic graphic) {
        if (graphic == null) {
            return null;
        }
        graphic.accept(this);
        return (Graphic)this.pages.pop();
    }

    protected Fill copy(Fill fill) {
        if (fill == null) {
            return null;
        }
        fill.accept(this);
        return (Fill)this.pages.pop();
    }

    protected float[] copy(float[] array) {
        if (array == null) {
            return null;
        }
        float[] copy = new float[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    protected <K, V> Map<K, V> copy(Map<K, V> customProperties) {
        if (customProperties == null) {
            return null;
        }
        return new HashMap<K, V>(customProperties);
    }

    protected Stroke copy(Stroke stroke) {
        if (stroke == null) {
            return null;
        }
        stroke.accept(this);
        return (Stroke)this.pages.pop();
    }

    protected ShadedRelief copy(ShadedRelief shaded) {
        if (shaded == null) {
            return null;
        }
        Expression reliefFactor = this.copy(shaded.getReliefFactor());
        ShadedRelief copy = this.sf.createShadedRelief(reliefFactor);
        copy.setBrightnessOnly(shaded.isBrightnessOnly());
        return copy;
    }

    protected Description copy(Description desc) {
        if (desc == null) {
            return null;
        }
        DescriptionImpl copy = new DescriptionImpl(desc.getTitle(), desc.getAbstract());
        return copy;
    }

    protected ExternalGraphic copy(ExternalGraphic externalGraphic) {
        if (externalGraphic == null) {
            return null;
        }
        externalGraphic.accept(this);
        return (ExternalGraphic)this.pages.pop();
    }

    protected Mark copy(Mark mark) {
        if (mark == null) {
            return null;
        }
        mark.accept(this);
        return (Mark)this.pages.pop();
    }

    private ExternalMark copy(ExternalMark other) {
        if (other == null) {
            return null;
        }
        if (other.getInlineContent() != null) {
            return this.sf.externalMark(other.getInlineContent());
        }
        return this.sf.externalMark(other.getOnlineResource(), other.getFormat(), other.getMarkIndex());
    }

    protected ColorMapEntry copy(ColorMapEntry entry) {
        if (entry == null) {
            return null;
        }
        entry.accept(this);
        return (ColorMapEntry)this.pages.pop();
    }

    protected Symbolizer copy(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        symbolizer.accept(this);
        Symbolizer result = this.pages.empty() ? null : (Symbolizer)this.pages.pop();
        return result;
    }

    protected OverlapBehavior copy(OverlapBehavior ob) {
        if (ob == null) {
            return null;
        }
        ob.accept(this);
        return (OverlapBehavior)this.pages.pop();
    }

    protected ContrastEnhancement copy(ContrastEnhancement contrast) {
        if (contrast == null) {
            return null;
        }
        ContrastEnhancement copy = this.sf.createContrastEnhancement();
        copy.setGammaValue(this.copy(contrast.getGammaValue()));
        copy.setMethod(contrast.getMethod());
        copy.setOptions(contrast.getOptions());
        return copy;
    }

    protected ColorMap copy(ColorMap colorMap) {
        if (colorMap == null) {
            return null;
        }
        colorMap.accept(this);
        return (ColorMap)this.pages.pop();
    }

    protected SelectedChannelType[] copy(SelectedChannelType ... channels) {
        if (channels == null) {
            return null;
        }
        SelectedChannelType[] copy = new SelectedChannelType[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            copy[i] = this.copy(channels[i]);
        }
        return copy;
    }

    protected SelectedChannelType copy(SelectedChannelType selectedChannelType) {
        if (selectedChannelType == null) {
            return null;
        }
        ContrastEnhancement enhancement = this.copy(selectedChannelType.getContrastEnhancement());
        Expression name = (Expression)selectedChannelType.getChannelName().accept(this.copyFilter, null);
        SelectedChannelType copy = this.sf.createSelectedChannelType(name, enhancement);
        return copy;
    }

    protected ChannelSelection copy(ChannelSelection channelSelection) {
        if (channelSelection == null) {
            return null;
        }
        if (channelSelection.getGrayChannel() != null) {
            return this.sf.createChannelSelection(this.copy(channelSelection.getGrayChannel()));
        }
        return this.sf.createChannelSelection(this.copy(channelSelection.getRGBChannels()));
    }

    protected List<Font> copyFonts(List<Font> fonts) {
        if (fonts == null) {
            return null;
        }
        ArrayList<Font> copy = new ArrayList<Font>(fonts.size());
        for (Font font : fonts) {
            copy.add(this.copy(font));
        }
        return copy;
    }

    protected Font copy(Font font) {
        if (font == null) {
            return font;
        }
        List<Expression> fontFamily = this.copyExpressions(font.getFamily());
        Expression fontStyle = this.copy(font.getStyle());
        Expression fontWeight = this.copy(font.getWeight());
        Expression fontSize = this.copy(font.getSize());
        Font copy = this.sf.font(fontFamily, fontStyle, fontWeight, fontSize);
        return copy;
    }

    protected Halo copy(Halo halo) {
        if (halo == null) {
            return null;
        }
        halo.accept(this);
        return (Halo)this.pages.pop();
    }

    protected Displacement copy(Displacement displacement) {
        if (displacement == null) {
            return null;
        }
        displacement.accept(this);
        return (Displacement)this.pages.pop();
    }

    protected LabelPlacement copy(LabelPlacement placement) {
        if (placement == null) {
            return null;
        }
        placement.accept(this);
        return (LabelPlacement)this.pages.pop();
    }

    protected Symbol copy(Symbol symbol) {
        if (symbol == null) {
            return null;
        }
        symbol.accept(this);
        return (Symbol)this.pages.pop();
    }

    protected AnchorPoint copy(AnchorPoint anchorPoint) {
        if (anchorPoint == null) {
            return null;
        }
        anchorPoint.accept(this);
        return (AnchorPoint)this.pages.pop();
    }

    @Override
    public void visit(Fill fill) {
        Fill copy = this.sf.getDefaultFill();
        copy.setColor(this.copy(fill.getColor()));
        copy.setGraphicFill(this.copy(fill.getGraphicFill()));
        copy.setOpacity(this.copy(fill.getOpacity()));
        if (this.STRICT && !copy.equals(fill)) {
            throw new IllegalStateException("Was unable to duplicate provided Fill:" + fill);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(Stroke stroke) {
        Stroke copy = this.sf.getDefaultStroke();
        copy.setColor(this.copy(stroke.getColor()));
        copy.setDashArray(this.copyExpressions(stroke.dashArray()));
        copy.setDashOffset(this.copy(stroke.getDashOffset()));
        copy.setGraphicFill(this.copy(stroke.getGraphicFill()));
        copy.setGraphicStroke(this.copy(stroke.getGraphicStroke()));
        copy.setLineCap(this.copy(stroke.getLineCap()));
        copy.setLineJoin(this.copy(stroke.getLineJoin()));
        copy.setOpacity(this.copy(stroke.getOpacity()));
        copy.setWidth(this.copy(stroke.getWidth()));
        if (this.STRICT && !copy.equals(stroke)) {
            throw new IllegalStateException("Was unable to duplicate provided Stroke:" + stroke);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(Symbolizer sym) {
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        } else if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        } else if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        } else if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        } else if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        } else {
            throw new RuntimeException("visit(Symbolizer) unsupported");
        }
    }

    @Override
    public void visit(PointSymbolizer ps) {
        PointSymbolizer copy = this.sf.getDefaultPointSymbolizer();
        copy.setGeometry(this.copy(ps.getGeometry()));
        copy.setUnitOfMeasure(ps.getUnitOfMeasure());
        copy.setGraphic(this.copy(ps.getGraphic()));
        copy.getOptions().putAll(ps.getOptions());
        if (this.STRICT && !copy.equals(ps)) {
            throw new IllegalStateException("Was unable to duplicate provided Graphic:" + ps);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(LineSymbolizer line) {
        LineSymbolizer copy = this.sf.getDefaultLineSymbolizer();
        copy.setGeometry(this.copy(line.getGeometry()));
        copy.setUnitOfMeasure(line.getUnitOfMeasure());
        copy.setStroke(this.copy(line.getStroke()));
        copy.getOptions().putAll(line.getOptions());
        copy.setPerpendicularOffset(line.getPerpendicularOffset());
        if (this.STRICT && !copy.equals(line)) {
            throw new IllegalStateException("Was unable to duplicate provided LineSymbolizer:" + line);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(PolygonSymbolizer poly) {
        PolygonSymbolizer copy = this.sf.createPolygonSymbolizer();
        copy.setFill(this.copy(poly.getFill()));
        copy.setGeometry(this.copy(poly.getGeometry()));
        copy.setUnitOfMeasure(poly.getUnitOfMeasure());
        copy.setStroke(this.copy(poly.getStroke()));
        copy.getOptions().putAll(poly.getOptions());
        if (this.STRICT && !copy.equals(poly)) {
            throw new IllegalStateException("Was unable to duplicate provided PolygonSymbolizer:" + poly);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(TextSymbolizer text) {
        TextSymbolizer copy = this.sf.createTextSymbolizer();
        copy.setFill(this.copy(text.getFill()));
        copy.fonts().clear();
        copy.fonts().addAll(this.copyFonts(text.fonts()));
        copy.setGeometry(this.copy(text.getGeometry()));
        copy.setUnitOfMeasure(text.getUnitOfMeasure());
        copy.setHalo(this.copy(text.getHalo()));
        copy.setLabel(this.copy(text.getLabel()));
        copy.setLabelPlacement(this.copy(text.getLabelPlacement()));
        copy.setPriority(this.copy(text.getPriority()));
        copy.getOptions().putAll(text.getOptions());
        if (text instanceof TextSymbolizer) {
            TextSymbolizer text2 = text;
            TextSymbolizer copy2 = copy;
            copy2.setGraphic(this.copy(text2.getGraphic()));
            copy2.setSnippet(this.copy(text2.getSnippet()));
            copy2.setFeatureDescription(this.copy(text2.getFeatureDescription()));
            copy2.setOtherText(this.copy(text2.getOtherText()));
        }
        if (this.STRICT && !copy.equals(text)) {
            throw new IllegalStateException("Was unable to duplicate provided TextSymbolizer:" + text);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(RasterSymbolizer raster) {
        RasterSymbolizer copy = this.sf.createRasterSymbolizer();
        copy.setChannelSelection(this.copy(raster.getChannelSelection()));
        copy.setColorMap(this.copy(raster.getColorMap()));
        copy.setContrastEnhancement(this.copy(raster.getContrastEnhancement()));
        copy.setGeometry(this.copy(raster.getGeometry()));
        copy.setUnitOfMeasure(raster.getUnitOfMeasure());
        copy.setImageOutline(this.copy(raster.getImageOutline()));
        copy.setOpacity(this.copy(raster.getOpacity()));
        copy.setOverlapBehavior(raster.getOverlapBehavior());
        copy.setShadedRelief(this.copy(raster.getShadedRelief()));
        if (this.STRICT && !copy.equals(raster)) {
            throw new IllegalStateException("Was unable to duplicate provided raster:" + raster);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(Graphic gr) {
        Displacement displacementCopy = this.copy(gr.getDisplacement());
        List<GraphicalSymbol> symbolsCopy = this.copy(gr.graphicalSymbols());
        Expression opacityCopy = this.copy(gr.getOpacity());
        Expression rotationCopy = this.copy(gr.getRotation());
        Expression sizeCopy = this.copy(gr.getSize());
        AnchorPoint anchorCopy = this.copy(gr.getAnchorPoint());
        Graphic copy = this.sf.createDefaultGraphic();
        copy.setDisplacement(displacementCopy);
        copy.graphicalSymbols().clear();
        copy.graphicalSymbols().addAll(symbolsCopy);
        copy.setOpacity(opacityCopy);
        copy.setRotation(rotationCopy);
        copy.setSize(sizeCopy);
        copy.setAnchorPoint(anchorCopy);
        if (this.STRICT && !copy.equals(gr)) {
            throw new IllegalStateException("Was unable to duplicate provided Graphic:" + gr);
        }
        this.pages.push(copy);
    }

    private List<GraphicalSymbol> copy(List<GraphicalSymbol> symbols) {
        ArrayList<GraphicalSymbol> copy = new ArrayList<GraphicalSymbol>(symbols.size());
        for (GraphicalSymbol symbol : symbols) {
            if (symbol instanceof Symbol) {
                copy.add(this.copy((Symbol)symbol));
                continue;
            }
            throw new RuntimeException("Don't know how to copy " + symbol);
        }
        return copy;
    }

    @Override
    public void visit(Mark mark) {
        Mark copy = this.sf.createMark();
        copy.setFill(this.copy(mark.getFill()));
        copy.setStroke(this.copy(mark.getStroke()));
        copy.setWellKnownName(this.copy(mark.getWellKnownName()));
        copy.setExternalMark(this.copy(mark.getExternalMark()));
        if (this.STRICT && !copy.equals(mark)) {
            throw new IllegalStateException("Was unable to duplicate provided Mark:" + mark);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(ExternalGraphic exgr) {
        URL uri = null;
        try {
            uri = exgr.getLocation();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String format = exgr.getFormat();
        Icon inlineContent = exgr.getInlineContent();
        ExternalGraphic copy = inlineContent != null ? this.sf.createExternalGraphic(inlineContent, format) : this.sf.createExternalGraphic(uri, format);
        copy.setCustomProperties(this.copy(exgr.getCustomProperties()));
        if (this.STRICT && !copy.equals(exgr)) {
            throw new IllegalStateException("Was unable to duplicate provided ExternalGraphic:" + exgr);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(PointPlacement pp) {
        PointPlacement copy = this.sf.getDefaultPointPlacement();
        copy.setAnchorPoint(this.copy(pp.getAnchorPoint()));
        copy.setDisplacement(this.copy(pp.getDisplacement()));
        copy.setRotation(this.copy(pp.getRotation()));
        if (this.STRICT && !copy.equals(pp)) {
            throw new IllegalStateException("Was unable to duplicate provided PointPlacement:" + pp);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(AnchorPoint ap) {
        Expression x = this.copy(ap.getAnchorPointX());
        Expression y = this.copy(ap.getAnchorPointY());
        AnchorPoint copy = this.sf.createAnchorPoint(x, y);
        if (this.STRICT && !copy.equals(ap)) {
            throw new IllegalStateException("Was unable to duplicate provided AnchorPoint:" + ap);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(Displacement dis) {
        Expression x = this.copy(dis.getDisplacementX());
        Expression y = this.copy(dis.getDisplacementY());
        Displacement copy = this.sf.createDisplacement(x, y);
        if (this.STRICT && !copy.equals(dis)) {
            throw new IllegalStateException("Was unable to duplicate provided Displacement:" + dis);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(LinePlacement lp) {
        Expression offset = this.copy(lp.getPerpendicularOffset());
        LinePlacement copy = this.sf.createLinePlacement(offset);
        copy.setAligned(lp.isAligned());
        copy.setGap(this.copy(lp.getGap()));
        copy.setGeneralized(lp.isGeneralizeLine());
        copy.setInitialGap(this.copy(lp.getInitialGap()));
        copy.setRepeated(lp.isRepeated());
        if (this.STRICT && !copy.equals(lp)) {
            throw new IllegalStateException("Was unable to duplicate provided LinePlacement:" + lp);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(Halo halo) {
        Fill fill = this.copy(halo.getFill());
        Expression radius = this.copy(halo.getRadius());
        Halo copy = this.sf.createHalo(fill, radius);
        if (this.STRICT && !copy.equals(halo)) {
            throw new IllegalStateException("Was unable to duplicate provided raster:" + halo);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(FeatureTypeConstraint ftc) {
        String typeName = ftc.getFeatureTypeName();
        Filter filter = this.copy(ftc.getFilter());
        Extent[] extents = this.copy(ftc.getExtents());
        FeatureTypeConstraint copy = this.sf.createFeatureTypeConstraint(typeName, filter, extents);
        if (this.STRICT && !copy.equals(ftc)) {
            throw new IllegalStateException("Was unable to duplicate provided FeatureTypeConstraint:" + ftc);
        }
        this.pages.push(copy);
    }

    protected Extent[] copy(Extent ... extents) {
        if (extents == null) {
            return null;
        }
        Extent[] copy = new Extent[extents.length];
        for (int i = 0; i < extents.length; ++i) {
            copy[i] = this.copy(extents[i]);
        }
        return copy;
    }

    protected Extent copy(Extent extent) {
        String name = extent.getName();
        String value = extent.getValue();
        Extent copy = this.sf.createExtent(name, value);
        return copy;
    }

    private OtherText copy(OtherText otherText) {
        if (otherText == null) {
            return null;
        }
        OtherTextImpl copy = new OtherTextImpl();
        copy.setTarget(otherText.getTarget());
        copy.setText(this.copy(otherText.getText()));
        return copy;
    }

    @Override
    public void visit(ColorMap colorMap) {
        ColorMap copy = this.sf.createColorMap();
        copy.setType(colorMap.getType());
        copy.setExtendedColors(colorMap.getExtendedColors());
        ColorMapEntry[] entries = colorMap.getColorMapEntries();
        if (entries != null) {
            for (ColorMapEntry entry : entries) {
                copy.addColorMapEntry(this.copy(entry));
            }
        }
        if (this.STRICT && !copy.equals(colorMap)) {
            throw new IllegalStateException("Was unable to duplicate provided ColorMap:" + colorMap);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(ColorMapEntry colorMapEntry) {
        ColorMapEntry copy = this.sf.createColorMapEntry();
        copy.setColor(this.copy(colorMapEntry.getColor()));
        copy.setLabel(colorMapEntry.getLabel());
        copy.setOpacity(this.copy(colorMapEntry.getOpacity()));
        copy.setQuantity(this.copy(colorMapEntry.getQuantity()));
        if (this.STRICT && !copy.equals(colorMapEntry)) {
            throw new IllegalStateException("Was unable to duplicate provided ColorMapEntry:" + colorMapEntry);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(ContrastEnhancement contrastEnhancement) {
        ContrastEnhancement copy = this.sf.createContrastEnhancement();
        copy.setMethod(contrastEnhancement.getMethod());
        copy.setOptions(contrastEnhancement.getOptions());
        copy.setGammaValue(contrastEnhancement.getGammaValue());
        if (this.STRICT && !copy.equals(contrastEnhancement)) {
            throw new IllegalStateException("Was unable to duplicate provided contrastEnhancement:" + contrastEnhancement);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(ImageOutline outline) {
        Symbolizer symb = outline.getSymbolizer();
        Symbolizer copySymb = this.copy(symb);
        ImageOutline copy = this.sf.createImageOutline(copySymb);
        copy.setSymbolizer(copySymb);
        if (this.STRICT && !copy.equals(outline)) {
            throw new IllegalStateException("Was unable to duplicate provided ImageOutline:" + outline);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(ChannelSelection cs) {
        ChannelSelection copy = this.copy(cs);
        this.pages.push(copy);
    }

    @Override
    public void visit(OverlapBehavior ob) {
        String behavior = (String)((OverlapBehaviorImpl)ob).getValue();
        if (behavior.equalsIgnoreCase("AVERAGE")) {
            this.pages.push("AVERAGE");
        } else if (behavior.equalsIgnoreCase("EARLIEST_ON_TOP")) {
            this.pages.push("EARLIEST_ON_TOP");
        } else if (behavior.equalsIgnoreCase("LATEST_ON_TOP")) {
            this.pages.push("LATEST_ON_TOP");
        } else if (behavior.equalsIgnoreCase("RANDOM")) {
            this.pages.push("RANDOM");
        } else {
            throw new IllegalStateException("Was unable to duplicate provided OverlapBehavior:" + ob);
        }
    }

    @Override
    public void visit(SelectedChannelType sct) {
        SelectedChannelType copy = this.sf.createSelectedChannelType(sct.getChannelName(), this.copy(sct.getContrastEnhancement()));
        if (this.STRICT && !copy.equals(sct)) {
            throw new IllegalStateException("Was unable to duplicate provided SelectedChannelType:" + sct);
        }
        this.pages.push(copy);
    }

    @Override
    public void visit(ShadedRelief sr) {
        ShadedRelief copy = this.sf.createShadedRelief(this.copy(sr.getReliefFactor()));
        copy.setBrightnessOnly(sr.isBrightnessOnly());
        if (this.STRICT && !copy.equals(sr)) {
            throw new IllegalStateException("Was unable to duplicate provided ShadedRelief:" + sr);
        }
        this.pages.push(copy);
    }
}

