/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.DerivedCRS;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.crs.OffsetOrdinateFilter;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.WrappingCoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import si.uom.SI;

public class WrappingProjectionHandler
extends ProjectionHandler {
    private static final Object LARGE_EARTH_OBJECT = new Object();
    private int maxWraps;
    private boolean datelineWrappingCheckEnabled = true;
    public static final String DATELINE_WRAPPING_CHECK_ENABLED = "datelineWrappingCheckEnabled";
    double sourceHalfCircle;

    public WrappingProjectionHandler(ReferencedEnvelope renderingEnvelope, ReferencedEnvelope validArea, CoordinateReferenceSystem sourceCrs, double centralMeridian, int maxWraps) throws FactoryException {
        super(sourceCrs, validArea, renderingEnvelope);
        this.maxWraps = maxWraps;
        this.queryAcrossDateline = true;
        this.setCentralMeridian(centralMeridian);
        CoordinateSystemAxis axis = sourceCrs.getCoordinateSystem().getAxis(0);
        if (sourceCrs instanceof GeographicCRS || sourceCrs instanceof DerivedCRS && axis.getUnit().isCompatible(SI.RADIAN)) {
            this.sourceHalfCircle = 180.0;
        } else {
            Unit<?> sourceUnit = axis.getUnit();
            UnitConverter converter = SI.METRE.getConverterTo(sourceUnit);
            this.sourceHalfCircle = converter.convert(2.00375E7);
        }
    }

    @Override
    public void setProjectionParameters(Map<String, Object> projectionParameters) {
        super.setProjectionParameters(projectionParameters);
        if (projectionParameters.containsKey(DATELINE_WRAPPING_CHECK_ENABLED)) {
            this.datelineWrappingCheckEnabled = (Boolean)projectionParameters.get(DATELINE_WRAPPING_CHECK_ENABLED);
        }
    }

    @Override
    public Geometry preProcess(Geometry geometry) throws TransformException, FactoryException {
        if ((geometry = super.preProcess(geometry)) == null) {
            return null;
        }
        double width = this.getWidth(geometry.getEnvelopeInternal(), this.sourceCRS);
        if (width > this.sourceHalfCircle) {
            Geometry copy = geometry.copy();
            copy.setUserData(LARGE_EARTH_OBJECT);
            return copy;
        }
        return geometry;
    }

    private double getWidth(Envelope envelope, CoordinateReferenceSystem crs) {
        boolean northEast;
        boolean bl = northEast = CRS.getAxisOrder(crs) == CRS.AxisOrder.NORTH_EAST;
        if (northEast) {
            return envelope.getHeight();
        }
        return envelope.getWidth();
    }

    @Override
    public Geometry postProcess(MathTransform mt, Geometry geometry) {
        double highLimit;
        double lowLimit;
        double curr;
        double base;
        boolean northEast;
        Envelope env = geometry.getEnvelopeInternal();
        double width = this.getWidth(env, this.targetCRS);
        double reWidth = this.getWidth(this.renderingEnvelope, this.targetCRS);
        if (width < this.targetHalfCircle && this.renderingEnvelope.contains(env) && reWidth <= this.targetHalfCircle * 2.0) {
            return geometry;
        }
        boolean bl = northEast = CRS.getAxisOrder(this.targetCRS) == CRS.AxisOrder.NORTH_EAST;
        if (this.datelineWrappingCheckEnabled && (geometry.getUserData() == LARGE_EARTH_OBJECT && width < this.targetHalfCircle || geometry.getUserData() != LARGE_EARTH_OBJECT && width > this.targetHalfCircle && width < this.targetHalfCircle * 2.0)) {
            Geometry wrapped = geometry.copy();
            wrapped.apply((GeometryComponentFilter)new WrappingCoordinateFilter(this.targetHalfCircle, this.targetHalfCircle * 2.0, mt, northEast));
            wrapped.geometryChanged();
            geometry = wrapped;
            env = geometry.getEnvelopeInternal();
        }
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        Class geomType = null;
        if (northEast) {
            base = env.getMinY();
            curr = env.getMinY();
            lowLimit = Math.max(this.renderingEnvelope.getMinY(), this.renderingEnvelope.getMedian(1) - (double)this.maxWraps * this.targetHalfCircle * 2.0);
            highLimit = Math.min(this.renderingEnvelope.getMaxY(), this.renderingEnvelope.getMedian(1) + (double)this.maxWraps * this.targetHalfCircle * 2.0);
        } else {
            base = env.getMinX();
            curr = env.getMinX();
            double geometryWidth = geometry.getEnvelopeInternal().getWidth();
            lowLimit = Math.max(this.renderingEnvelope.getMinX() - geometryWidth, this.renderingEnvelope.getMedian(0) - (double)this.maxWraps * this.targetHalfCircle * 2.0);
            highLimit = Math.min(this.renderingEnvelope.getMaxX() + geometryWidth, this.renderingEnvelope.getMedian(0) + (double)this.maxWraps * this.targetHalfCircle * 2.0);
        }
        while (curr > lowLimit) {
            curr -= this.targetHalfCircle * 2.0;
        }
        geomType = WrappingProjectionHandler.accumulate(geoms, geometry, geomType, this.renderingEnvelope);
        while (curr <= highLimit) {
            double offset = curr - base;
            if (Math.abs(offset) >= this.targetHalfCircle) {
                Geometry offseted = geometry.copy();
                offseted.apply((CoordinateSequenceFilter)new OffsetOrdinateFilter(northEast ? 1 : 0, offset));
                offseted.geometryChanged();
                geomType = WrappingProjectionHandler.accumulate(geoms, offseted, geomType, this.renderingEnvelope);
            }
            curr += this.targetHalfCircle * 2.0;
        }
        if (geomType == null) {
            return null;
        }
        if (geoms.size() == 1) {
            return (Geometry)geoms.get(0);
        }
        if (Point.class.equals((Object)geomType)) {
            Point[] points = geoms.toArray(new Point[geoms.size()]);
            return geometry.getFactory().createMultiPoint(points);
        }
        if (LineString.class.isAssignableFrom(geomType)) {
            LineString[] lines = geoms.toArray(new LineString[geoms.size()]);
            return geometry.getFactory().createMultiLineString(lines);
        }
        if (Polygon.class.equals((Object)geomType)) {
            Polygon[] polys = geoms.toArray(new Polygon[geoms.size()]);
            return geometry.getFactory().createMultiPolygon(polys);
        }
        return geometry.getFactory().createGeometryCollection(geoms.toArray(new Geometry[geoms.size()]));
    }

    static Class accumulate(List<Geometry> geoms, Geometry geometry, Class geomType, ReferencedEnvelope envelope) {
        Class<Object> gtype = null;
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry g = geometry.getGeometryN(i);
            Class<?> lastType = gtype;
            if (g instanceof GeometryCollection) {
                gtype = WrappingProjectionHandler.accumulate(geoms, g, geomType, envelope);
            } else if (envelope.intersects(g.getEnvelopeInternal())) {
                geoms.add(g);
                gtype = g.getClass();
            }
            if (gtype == null) {
                gtype = g.getClass();
                continue;
            }
            if ((geomType == null || g.getClass().equals(geomType)) && (lastType == null || g.getClass().equals(lastType))) continue;
            gtype = Geometry.class;
        }
        return gtype;
    }

    @Override
    public boolean requiresProcessing(Geometry geometry) {
        return true;
    }

    public boolean isDatelineWrappingCheckEnabled() {
        return this.datelineWrappingCheckEnabled;
    }

    public void setDatelineWrappingCheckEnabled(boolean datelineWrappingCheckEnabled) {
        this.datelineWrappingCheckEnabled = datelineWrappingCheckEnabled;
    }
}

