/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.WorldVanDerGrintenI;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;

public class WorldVanDerGrintenIHandlerFactory
implements ProjectionHandlerFactory {
    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        if (renderingEnvelope == null) {
            return null;
        }
        MapProjection mapProjection = CRS.getMapProjection(renderingEnvelope.getCoordinateReferenceSystem());
        if (mapProjection instanceof WorldVanDerGrintenI) {
            ReferencedEnvelope validArea = new ReferencedEnvelope(-2.147483647E9, 2.147483647E9, -90.0, 90.0, DefaultGeographicCRS.WGS84);
            return new ProjectionHandler(sourceCrs, validArea, renderingEnvelope);
        }
        return null;
    }
}

