/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.Point2D;
import java.awt.image.RasterFormatException;
import java.text.MessageFormat;
import javax.media.jai.Warp;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;

final class WarpAdapter
extends Warp {
    private static final long serialVersionUID = -8679060848877065181L;
    private final CharSequence name;
    private final MathTransform2D inverse;

    public WarpAdapter(CharSequence name, MathTransform2D inverse) {
        this.name = name;
        this.inverse = inverse;
    }

    public MathTransform2D getTransform() {
        return this.inverse;
    }

    @Override
    public float[] warpSparseRect(int xmin, int ymin, int width, int height, int periodX, int periodY, float[] destRect) {
        if (periodX < 1) {
            throw new IllegalArgumentException(String.valueOf(periodX));
        }
        if (periodY < 1) {
            throw new IllegalArgumentException(String.valueOf(periodY));
        }
        int xmax = xmin + width;
        int ymax = ymin + height;
        int count = (width + (periodX - 1)) / periodX * ((height + (periodY - 1)) / periodY);
        if (destRect == null) {
            destRect = new float[2 * count];
        }
        int index = 0;
        for (int y = ymin; y < ymax; y += periodY) {
            for (int x = xmin; x < xmax; x += periodX) {
                destRect[index++] = (float)x + 0.5f;
                destRect[index++] = (float)y + 0.5f;
            }
        }
        try {
            this.inverse.transform(destRect, 0, destRect, 0, count);
        }
        catch (TransformException exception) {
            RasterFormatException e = new RasterFormatException(MessageFormat.format("Can't reproject grid coverage \"{0}\".", this.name));
            e.initCause(exception);
            throw e;
        }
        while (--index >= 0) {
            int n = index;
            destRect[n] = destRect[n] - 0.5f;
        }
        return destRect;
    }

    @Override
    public Point2D mapDestPoint(Point2D destPt) {
        Point2D result = new Point2D.Double(destPt.getX() + 0.5, destPt.getY() + 0.5);
        try {
            result = this.inverse.transform(result, result);
        }
        catch (TransformException exception) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter \"{0}\" can't have value \"{1}\".", "destPt", destPt), exception);
        }
        result.setLocation(result.getX() - 0.5, result.getY() - 0.5);
        return result;
    }

    @Override
    public Point2D mapSourcePoint(Point2D sourcePt) {
        Point2D result = new Point2D.Double(sourcePt.getX() + 0.5, sourcePt.getY() + 0.5);
        try {
            result = this.inverse.inverse().transform(result, result);
        }
        catch (TransformException exception) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter \"{0}\" can't have value \"{1}\".", "sourcePt", sourcePt), exception);
        }
        result.setLocation(result.getX() - 0.5, result.getY() - 0.5);
        return result;
    }
}

