/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.util.SuppressFBWarnings;
import si.uom.NonSI;

public class WinkelTripel
extends MapProjection {
    private static final long serialVersionUID = -8643765000703074857L;
    private final double cosphi1;
    private final ProjectionMode mode;
    private ParameterDescriptorGroup descriptors;

    protected WinkelTripel(ProjectionMode mode, ParameterDescriptorGroup descriptors, ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters, descriptors.descriptors());
        this.descriptors = descriptors;
        this.invertible = false;
        if (mode == ProjectionMode.Winkel) {
            List<GeneralParameterDescriptor> expected = this.getParameterDescriptors().descriptors();
            double phi1 = this.doubleValue(expected, WinkelProvider.STANDARD_PARALLEL_1, parameters);
            this.cosphi1 = Math.cos(phi1);
        } else {
            this.cosphi1 = 0.0;
        }
        this.mode = mode;
    }

    @Override
    @SuppressFBWarnings(value={"UR_UNINIT_READ_CALLED_FROM_SUPER_CONSTRUCTOR"})
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.descriptors;
    }

    @Override
    protected Point2D transformNormalized(double lam, double phi, Point2D ptDst) throws ProjectionException {
        double x;
        double y;
        double c = 0.5 * lam;
        double d = Math.acos(Math.cos(phi) * Math.cos(c));
        if (d != 0.0) {
            y = 1.0 / Math.sin(d);
            x = 2.0 * d * Math.cos(phi) * Math.sin(c) * y;
            y *= d * Math.sin(phi);
        } else {
            y = 0.0;
            x = 0.0;
        }
        if (this.mode == ProjectionMode.Winkel) {
            x = (x + lam * this.cosphi1) * 0.5;
            y = (y + phi) * 0.5;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        throw new UnsupportedOperationException("Cannot invert this transformation");
    }

    @Override
    public int hashCode() {
        long code = Double.doubleToLongBits(this.cosphi1);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            WinkelTripel that = (WinkelTripel)object;
            return WinkelTripel.equals(this.cosphi1, that.cosphi1);
        }
        return false;
    }

    public static class AitoffProvider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 1189973109778926762L;
        static final ParameterDescriptorGroup PARAMETERS = AitoffProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Aitoff"), new NamedIdentifier(Citations.GEOTOOLS, "Aitoff")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR});

        public AitoffProvider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new WinkelTripel(ProjectionMode.Aitoff, PARAMETERS, parameters);
        }
    }

    public static class WinkelProvider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -2484567298319140781L;
        public static final ParameterDescriptor STANDARD_PARALLEL_1 = WinkelProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_1"), new NamedIdentifier(Citations.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(Citations.GEOTIFF, "StdParallel1")}, Math.toDegrees(0.880689235), -90.0, 90.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = WinkelProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Winkel_Tripel"), new NamedIdentifier(Citations.GEOTOOLS, "Winkel Tripel")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, STANDARD_PARALLEL_1});

        public WinkelProvider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new WinkelTripel(ProjectionMode.Winkel, PARAMETERS, parameters);
        }
    }

    private static enum ProjectionMode {
        Winkel,
        Aitoff;

    }
}

