/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.text.MessageFormat;
import java.util.Map;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeneralDerivedCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.operation.Conversion;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.api.referencing.operation.Projection;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.crs.UnprefixedMap;
import org.geotools.referencing.operation.DefaultConversion;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.wkt.Formatter;

public class AbstractDerivedCRS
extends AbstractSingleCRS
implements GeneralDerivedCRS {
    private static final long serialVersionUID = -175151161496419854L;
    public static final String CONVERSION_TYPE_KEY = "conversionType";
    public static final ThreadLocal<Boolean> _COMPARING = new ThreadLocal();
    protected final CoordinateReferenceSystem baseCRS;
    protected final Conversion conversionFromBase;

    protected AbstractDerivedCRS(GeneralDerivedCRS crs) {
        super(crs);
        this.baseCRS = crs.getBaseCRS();
        this.conversionFromBase = crs.getConversionFromBase();
    }

    protected AbstractDerivedCRS(Map<String, ?> properties, Conversion conversionFromBase, CoordinateReferenceSystem base, MathTransform baseToDerived, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        super(properties, AbstractDerivedCRS.getDatum(base), derivedCS);
        AbstractDerivedCRS.ensureNonNull("conversionFromBase", conversionFromBase);
        AbstractDerivedCRS.ensureNonNull("baseToDerived", baseToDerived);
        this.baseCRS = base;
        AbstractDerivedCRS.checkDimensions(base, baseToDerived, derivedCS);
        DefaultOperationMethod.checkDimensions(conversionFromBase.getMethod(), baseToDerived);
        Class c = (Class)properties.get(CONVERSION_TYPE_KEY);
        Class<? extends Conversion> typeHint = this.getConversionType();
        if (c != null) {
            typeHint = c.asSubclass(typeHint);
        }
        this.conversionFromBase = DefaultConversion.create(conversionFromBase, base, this, baseToDerived, typeHint);
    }

    protected AbstractDerivedCRS(Map<String, Object> properties, CoordinateReferenceSystem base, MathTransform baseToDerived, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        this(properties, new DefaultOperationMethod(baseToDerived), base, baseToDerived, derivedCS);
    }

    AbstractDerivedCRS(Map<String, Object> properties, OperationMethod method, CoordinateReferenceSystem base, MathTransform baseToDerived, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        super(properties, AbstractDerivedCRS.getDatum(base), derivedCS);
        AbstractDerivedCRS.ensureNonNull("method", method);
        AbstractDerivedCRS.ensureNonNull("baseToDerived", baseToDerived);
        this.baseCRS = base;
        AbstractDerivedCRS.checkDimensions(base, baseToDerived, derivedCS);
        DefaultOperationMethod.checkDimensions(method, baseToDerived);
        this.conversionFromBase = (Conversion)DefaultOperation.create(new UnprefixedMap(properties, "conversion."), base, this, baseToDerived, method, this instanceof ProjectedCRS ? Projection.class : Conversion.class);
    }

    private static Datum getDatum(CoordinateReferenceSystem base) {
        AbstractDerivedCRS.ensureNonNull("base", base);
        return base instanceof SingleCRS ? ((SingleCRS)base).getDatum() : null;
    }

    private static void checkDimensions(CoordinateReferenceSystem base, MathTransform baseToDerived, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        int dimSource = baseToDerived.getSourceDimensions();
        int dimTarget = baseToDerived.getTargetDimensions();
        int dim1 = dimSource;
        int dim2 = base.getCoordinateSystem().getDimension();
        if (dim1 != dim2 || (dim1 = dimTarget) != (dim2 = derivedCS.getDimension())) {
            throw new MismatchedDimensionException(MessageFormat.format("Mismatched object dimension: {0}D and {1}D.", dim1, dim2));
        }
    }

    @Override
    public CoordinateReferenceSystem getBaseCRS() {
        return this.baseCRS;
    }

    @Override
    public Conversion getConversionFromBase() {
        return this.conversionFromBase;
    }

    Class<? extends Conversion> getConversionType() {
        return Conversion.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            AbstractDerivedCRS that = (AbstractDerivedCRS)object;
            if (AbstractDerivedCRS.equals(this.baseCRS, that.baseCRS, compareMetadata)) {
                Boolean comparing = _COMPARING.get();
                if (comparing != null && comparing.booleanValue()) {
                    return true;
                }
                try {
                    _COMPARING.set(Boolean.TRUE);
                    boolean bl = AbstractDerivedCRS.equals(this.conversionFromBase, that.conversionFromBase, compareMetadata);
                    return bl;
                }
                finally {
                    _COMPARING.remove();
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x550241F2 ^ this.baseCRS.hashCode() ^ this.conversionFromBase.getName().hashCode();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        MathTransform inverse = this.conversionFromBase.getMathTransform();
        try {
            inverse = inverse.inverse();
        }
        catch (NoninvertibleTransformException exception) {
            throw new IllegalStateException(exception.getLocalizedMessage(), exception);
        }
        formatter.append(inverse);
        formatter.append(this.baseCRS);
        return "FITTED_CS";
    }
}

